/*
 * Decompiled with CFR 0.152.
 */
package net.permutated.exmachinis.data.builders;

import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.ModLoadedCondition;
import net.permutated.exmachinis.data.RecipeException;
import net.permutated.exmachinis.recipes.CompactingRecipe;
import net.permutated.exmachinis.util.IngredientStack;
import net.permutated.exmachinis.util.ResourceUtil;

public class CompactingRecipeBuilder {
    private IngredientStack ingredient = new IngredientStack(Ingredient.EMPTY, 0);
    private final ItemStack output;

    protected String getPrefix() {
        return "compacting";
    }

    public CompactingRecipeBuilder(ItemStack output) {
        this.output = output;
    }

    public static CompactingRecipeBuilder builder(Item output, int count) {
        return new CompactingRecipeBuilder(new ItemStack((ItemLike)output, count));
    }

    public static CompactingRecipeBuilder builder(Item output) {
        return new CompactingRecipeBuilder(new ItemStack((ItemLike)output));
    }

    public static CompactingRecipeBuilder builder(Supplier<Item> output) {
        return CompactingRecipeBuilder.builder(output.get());
    }

    public CompactingRecipeBuilder setInput(Ingredient input, int count) {
        this.ingredient = new IngredientStack(input, count);
        return this;
    }

    public CompactingRecipeBuilder setInput(ItemLike input, int count) {
        return this.setInput(Ingredient.of((ItemLike[])new ItemLike[]{input}), count);
    }

    public CompactingRecipeBuilder setInput(TagKey<Item> input, int count) {
        return this.setInput(Ingredient.of(input), count);
    }

    public void build(RecipeOutput consumer) {
        ResourceLocation key = BuiltInRegistries.ITEM.getKey((Object)this.output.getItem());
        String modId = key.getNamespace();
        String path = key.getPath();
        ResourceLocation id = ResourceUtil.prefix(this.getPrefix() + "/" + path);
        if (Ingredient.EMPTY.equals((Object)this.ingredient.ingredient())) {
            throw new RecipeException(id.toString(), "input is required");
        }
        consumer.withConditions(new ICondition[]{new ModLoadedCondition(modId)}).accept(id, (Recipe)new CompactingRecipe(this.ingredient, this.output), null);
    }
}

