/*
 * Decompiled with CFR 0.152.
 */
package net.permutated.exmachinis.events;

import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RecipesUpdatedEvent;
import net.neoforged.neoforge.common.util.TriState;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.permutated.exmachinis.ExMachinis;
import net.permutated.exmachinis.ModRegistry;
import net.permutated.exmachinis.compat.exnihilo.ExNihiloAPI;
import net.permutated.exmachinis.machines.base.AbstractMachineBlock;

@EventBusSubscriber(modid="exmachinis", bus=EventBusSubscriber.Bus.GAME)
public class ServerEventHandler {
    private ServerEventHandler() {
    }

    public static void loadCompactingRecipes(RecipeManager recipeManager) {
        List compactingRecipes = recipeManager.getAllRecipesFor(ModRegistry.COMPACTING_RECIPE_TYPE.get());
        ModRegistry.COMPACTING_REGISTRY.setRecipeList(compactingRecipes);
        ExMachinis.LOGGER.debug("Registered {} compacting recipes", (Object)compactingRecipes.size());
    }

    @SubscribeEvent
    public static void onRecipesUpdatedEvent(RecipesUpdatedEvent event) {
        ExMachinis.LOGGER.debug("Loading recipes on server sync");
        ServerEventHandler.loadCompactingRecipes(event.getRecipeManager());
    }

    @SubscribeEvent
    public static void onServerStartingEvent(ServerStartingEvent event) {
        if (event.getServer().isDedicatedServer()) {
            ExMachinis.LOGGER.debug("Loading recipes on server startup");
            ServerEventHandler.loadCompactingRecipes(event.getServer().getRecipeManager());
        }
    }

    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        Level level = event.getLevel();
        if (level instanceof ServerLevel) {
            BlockState blockState;
            ServerLevel level2 = (ServerLevel)level;
            if (event.getEntity().isShiftKeyDown() && ExNihiloAPI.isHammerItem(event.getItemStack()) && (blockState = level2.getBlockState(event.getPos())).getBlock() instanceof AbstractMachineBlock) {
                Direction facing = event.getHitVec().getDirection();
                Direction output = (Direction)blockState.getValue((Property)AbstractMachineBlock.OUTPUT);
                event.setUseBlock(TriState.FALSE);
                if (!facing.equals((Object)output)) {
                    level2.setBlock(event.getPos(), (BlockState)blockState.setValue((Property)AbstractMachineBlock.OUTPUT, (Comparable)facing), 2);
                }
            }
        }
    }
}

