/*
 * Decompiled with CFR 0.152.
 */
package net.permutated.exmachinis.machines.buffer;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.permutated.exmachinis.ModRegistry;
import net.permutated.exmachinis.items.ComparatorUpgradeItem;
import net.permutated.exmachinis.machines.base.AbstractMachineBlock;
import net.permutated.exmachinis.machines.base.AbstractMachineTile;
import net.permutated.exmachinis.util.WorkStatus;
import org.jetbrains.annotations.Nullable;

public class ItemBufferTile
extends AbstractMachineTile {
    private boolean inventoryChanged = false;
    private int redstoneLevel = 0;
    private Direction redstoneDirection = null;

    public ItemBufferTile(BlockPos pos, BlockState state) {
        super(ModRegistry.ITEM_BUFFER_TILE.get(), pos, state);
        ItemStackHandler itemStackHandler = this.itemStackHandler;
        if (itemStackHandler instanceof AbstractMachineTile.MachineItemStackHandler) {
            AbstractMachineTile.MachineItemStackHandler m = (AbstractMachineTile.MachineItemStackHandler)itemStackHandler;
            m.setListener(this::inventoryChangeListener);
        }
    }

    @Override
    protected boolean isItemValid(ItemStack stack) {
        return true;
    }

    @Override
    protected boolean enableComparatorSlot() {
        return true;
    }

    public static void registerItemCapability(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, ModRegistry.ITEM_BUFFER_TILE.get(), (machine, side) -> machine.itemStackHandler);
    }

    @Override
    public void tick() {
        if (this.level instanceof ServerLevel && this.canTick(this.getUpgradeTickDelay())) {
            Boolean enabled = (Boolean)this.getBlockState().getValue((Property)AbstractMachineBlock.ENABLED);
            if (Boolean.FALSE.equals(enabled)) {
                this.workStatus = WorkStatus.REDSTONE_DISABLED;
                return;
            }
            Direction output = (Direction)this.getBlockState().getValue((Property)AbstractMachineBlock.OUTPUT);
            BlockPos outPos = this.getBlockPos().relative(output);
            IItemHandler itemHandler = (IItemHandler)this.level.getCapability(Capabilities.ItemHandler.BLOCK, outPos, (Object)output.getOpposite());
            if (itemHandler == null || itemHandler.getSlots() == 0) {
                this.workStatus = WorkStatus.MISSING_INVENTORY;
                return;
            }
            this.workStatus = WorkStatus.WORKING;
            for (int i = 0; i < this.itemStackHandler.getSlots(); ++i) {
                ItemStack stack = this.itemStackHandler.getStackInSlot(i);
                if (stack.isEmpty()) continue;
                ItemStack extractResult = this.itemStackHandler.extractItem(i, stack.getMaxStackSize(), true);
                ItemStack insertResult = ItemHandlerHelper.insertItemStacked((IItemHandler)itemHandler, (ItemStack)extractResult, (boolean)true);
                if (extractResult.getCount() <= insertResult.getCount()) continue;
                int inserted = extractResult.getCount() - insertResult.getCount();
                ItemStack extracted = this.itemStackHandler.extractItem(i, inserted, false);
                ItemHandlerHelper.insertItemStacked((IItemHandler)itemHandler, (ItemStack)extracted, (boolean)false);
            }
            this.sortSlots();
        }
        this.checkForRedstoneSignal();
    }

    private void inventoryChangeListener() {
        this.inventoryChanged = true;
    }

    private void checkForRedstoneSignal() {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (!this.inventoryChanged) {
                return;
            }
            this.inventoryChanged = false;
            int calulated = 0;
            ItemStack stack = this.upgradeStackHandler.getStackInSlot(1);
            if (!stack.isEmpty() && stack.getItem() instanceof ComparatorUpgradeItem) {
                this.redstoneDirection = ComparatorUpgradeItem.getDirection(stack);
                if (this.redstoneDirection != null) {
                    calulated = ItemHandlerHelper.calcRedstoneFromInventory((IItemHandler)this.itemStackHandler);
                }
            }
            if (this.redstoneLevel != calulated) {
                this.redstoneLevel = calulated;
                serverLevel.updateNeighborsAt(this.getBlockPos(), this.getBlockState().getBlock());
            }
        }
    }

    public int getRedstoneLevel() {
        return this.redstoneLevel;
    }

    @Nullable
    public Direction getRedstoneDirection() {
        return this.redstoneDirection;
    }
}

