/*
 * Decompiled with CFR 0.152.
 */
package net.permutated.exmachinis.machines.compactor;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.permutated.exmachinis.ModRegistry;
import net.permutated.exmachinis.machines.base.AbstractMachineBlock;
import net.permutated.exmachinis.machines.base.AbstractMachineTile;
import net.permutated.exmachinis.recipes.CompactingRecipe;
import net.permutated.exmachinis.util.ItemStackUtil;
import net.permutated.exmachinis.util.WorkStatus;

public class FluxCompactorTile
extends AbstractMachineTile {
    public FluxCompactorTile(BlockPos pos, BlockState state) {
        super(ModRegistry.FLUX_COMPACTOR_TILE.get(), pos, state);
    }

    @Override
    protected boolean isItemValid(ItemStack stack) {
        return true;
    }

    @Override
    public void tick() {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.canTick(this.getUpgradeTickDelay())) {
                int quotient;
                Boolean enabled = (Boolean)this.getBlockState().getValue((Property)AbstractMachineBlock.ENABLED);
                if (Boolean.FALSE.equals(enabled)) {
                    this.workStatus = WorkStatus.REDSTONE_DISABLED;
                    return;
                }
                Direction output = (Direction)this.getBlockState().getValue((Property)AbstractMachineBlock.OUTPUT);
                BlockPos outPos = this.getBlockPos().relative(output);
                IItemHandler itemHandler = (IItemHandler)this.level.getCapability(Capabilities.ItemHandler.BLOCK, outPos, (Object)output.getOpposite());
                if (itemHandler == null || itemHandler.getSlots() == 0) {
                    this.workStatus = WorkStatus.MISSING_INVENTORY;
                    return;
                }
                this.workStatus = WorkStatus.WORKING;
                int cost = this.getUpgradeEnergyCost();
                int stored = this.energyStorage.getEnergyStored();
                int maxProcessed = this.getUpgradeItemsProcessed();
                if (stored < cost) {
                    this.workStatus = WorkStatus.OUT_OF_ENERGY;
                    return;
                }
                if (cost > 0 && (quotient = stored / cost) < maxProcessed) {
                    maxProcessed = quotient;
                }
                for (int i = 0; i < this.itemStackHandler.getSlots() && maxProcessed != 0; ++i) {
                    int multiplier;
                    int maxInputs;
                    Optional<CompactingRecipe> maybe;
                    ItemStack stack = this.itemStackHandler.getStackInSlot(i);
                    if (stack.isEmpty() || (maybe = ModRegistry.COMPACTING_REGISTRY.findRecipe(stack.getItem())).isEmpty() || !maybe.get().getIngredient().test(stack)) continue;
                    CompactingRecipe recipe = maybe.get();
                    int recipeInput = recipe.getIngredient().count();
                    ItemStack copy = stack.copy();
                    int count = stack.getCount();
                    if (count >= (maxInputs = maxProcessed * recipeInput)) {
                        multiplier = maxProcessed;
                        copy.shrink(maxInputs);
                        maxProcessed = 0;
                    } else {
                        multiplier = count / recipeInput;
                        int inputUsed = multiplier * recipeInput;
                        copy.shrink(inputUsed);
                        maxProcessed -= multiplier;
                    }
                    if (!this.processResults(itemHandler, recipe, multiplier, true)) {
                        return;
                    }
                    int totalCost = cost * multiplier;
                    boolean result = this.energyStorage.consumeEnergy(totalCost, true);
                    if (!result) {
                        this.workStatus = WorkStatus.OUT_OF_ENERGY;
                        return;
                    }
                    this.itemStackHandler.setStackInSlot(i, copy);
                    this.energyStorage.consumeEnergy(totalCost, false);
                    this.processResults(itemHandler, recipe, multiplier, false);
                }
                this.sortSlots();
            }
        }
    }

    private boolean processResults(IItemHandler itemHandler, CompactingRecipe recipe, int multiplier, boolean simulate) {
        ItemStack output = ItemStackUtil.multiplyStackCount(recipe.getOutput(), multiplier);
        ItemStack response = ItemHandlerHelper.insertItemStacked((IItemHandler)itemHandler, (ItemStack)output, (boolean)simulate);
        if (!response.isEmpty()) {
            this.workStatus = WorkStatus.INVENTORY_FULL;
        }
        return this.workStatus == WorkStatus.WORKING;
    }
}

