/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.api.material;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.codec.StreamCodec;
import net.silentchaos512.gear.api.material.TextureType;
import net.silentchaos512.lib.util.Color;

public record MaterialDisplayData(Component name, Component namePrefix, Color color, TextureType mainTextureType) {
    public static final Codec<MaterialDisplayData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ComponentSerialization.CODEC.fieldOf("name").forGetter(d -> d.name), (App)ComponentSerialization.CODEC.optionalFieldOf("name_prefix").forGetter(d -> Optional.ofNullable(d.namePrefix)), (App)Color.CODEC.fieldOf("color").forGetter(d -> d.color), (App)TextureType.CODEC.fieldOf("main_texture_type").forGetter(d -> d.mainTextureType)).apply((Applicative)instance, (name, prefix, color, textureType) -> new MaterialDisplayData((Component)name, (Component)prefix.orElse(Component.empty()), (Color)color, (TextureType)((Object)((Object)textureType)))));
    private static final StreamCodec<FriendlyByteBuf, Color> TEMP_COLOR_STREAM_CODEC = StreamCodec.of((buf, color) -> buf.writeVarInt(color.getColor()), buf -> new Color(buf.readVarInt()));
    public static final StreamCodec<RegistryFriendlyByteBuf, MaterialDisplayData> STREAM_CODEC = StreamCodec.composite((StreamCodec)ComponentSerialization.STREAM_CODEC, d -> d.name, (StreamCodec)ComponentSerialization.STREAM_CODEC, d -> d.namePrefix, TEMP_COLOR_STREAM_CODEC, d -> d.color, TextureType.STREAM_CODEC, d -> d.mainTextureType, MaterialDisplayData::new);
}

