/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.block.alloymaker;

import java.util.Collection;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;
import net.silentchaos512.gear.api.material.IMaterialCategory;
import net.silentchaos512.gear.block.alloymaker.AlloyMakerBlockEntity;
import net.silentchaos512.gear.network.payload.client.AlloyMakerUpdatePayload;
import net.silentchaos512.lib.inventory.SlotOutputOnly;
import net.silentchaos512.lib.util.InventoryUtils;

public class AlloyMakerContainer
extends AbstractContainerMenu {
    private final Container inventory;
    private final ContainerData fields;

    public AlloyMakerContainer(MenuType<?> containerType, int id, Inventory playerInventory, FriendlyByteBuf buffer, Collection<IMaterialCategory> categories) {
        this(containerType, id, playerInventory, (Container)new SimpleContainer((int)buffer.readByte()), (ContainerData)new SimpleContainerData((int)buffer.readByte()), categories);
    }

    public AlloyMakerContainer(MenuType<?> containerType, int id, Inventory playerInventory, Container inventory, ContainerData fields, Collection<IMaterialCategory> categories) {
        super(containerType, id);
        this.inventory = inventory;
        this.fields = fields;
        for (int i = 0; i < this.inventory.getContainerSize() - 2; ++i) {
            this.addSlot(new Slot(this.inventory, i, 17 + 18 * i, 35));
        }
        this.addSlot((Slot)new SlotOutputOnly(this.inventory, this.inventory.getContainerSize() - 2, 126, 35));
        this.addSlot((Slot)new SlotOutputOnly(this, this.inventory, this.inventory.getContainerSize() - 1, 126, 60){

            public boolean mayPickup(Player playerIn) {
                return false;
            }
        });
        InventoryUtils.createPlayerSlots((Inventory)playerInventory, (int)8, (int)84).forEach(x$0 -> this.addSlot((Slot)x$0));
        this.addDataSlots(this.fields);
    }

    boolean getWorkEnabled() {
        return this.fields.get(1) != 0;
    }

    public void setWorkEnabled(boolean value) {
        this.fields.set(1, value ? 1 : 0);
    }

    void toggleWorkEnabled() {
        this.fields.set(1, this.fields.get(1) == 0 ? 1 : 0);
        PacketDistributor.sendToServer((CustomPacketPayload)new AlloyMakerUpdatePayload(this.getWorkEnabled()), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public int getProgressArrowScale() {
        int progress = this.fields.get(0);
        return progress != 0 ? progress * 24 / AlloyMakerBlockEntity.WORK_TIME : 0;
    }

    public boolean stillValid(Player playerIn) {
        return this.inventory.stillValid(playerIn);
    }

    public ItemStack quickMoveStack(Player playerIn, int index) {
        ItemStack stack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack stack1 = slot.getItem();
            stack = stack1.copy();
            int inventorySize = this.inventory.getContainerSize();
            int playerInventoryEnd = inventorySize + 27;
            int playerHotbarEnd = playerInventoryEnd + 9;
            int outputSlot = inventorySize - 2;
            if (index == outputSlot) {
                if (!this.moveItemStackTo(stack1, inventorySize, playerHotbarEnd, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(stack1, stack);
            } else if (index >= inventorySize ? (this.isValidIngredient() ? !this.moveItemStackTo(stack1, 0, outputSlot, false) : (index < playerInventoryEnd ? !this.moveItemStackTo(stack1, playerInventoryEnd, playerHotbarEnd, false) : index < playerHotbarEnd && !this.moveItemStackTo(stack1, inventorySize, playerInventoryEnd, false))) : !this.moveItemStackTo(stack1, inventorySize, playerHotbarEnd, false)) {
                return ItemStack.EMPTY;
            }
            if (stack1.getCount() == 0) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (stack1.getCount() == stack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(playerIn, stack1);
        }
        return stack;
    }

    private boolean isValidIngredient() {
        return true;
    }
}

