/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.data.recipes;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.crafting.ICustomIngredient;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.crafting.ingredient.GearPartIngredient;
import net.silentchaos512.gear.crafting.ingredient.PartMaterialIngredient;
import net.silentchaos512.gear.crafting.recipe.smithing.CoatingSmithingRecipe;
import net.silentchaos512.gear.crafting.recipe.smithing.GearSmithingRecipe;
import net.silentchaos512.gear.crafting.recipe.smithing.UpgradeSmithingRecipe;
import net.silentchaos512.gear.setup.SgItems;
import net.silentchaos512.gear.setup.gear.PartTypes;

public class GearSmithingRecipeBuilder<R extends GearSmithingRecipe>
implements RecipeBuilder {
    private final GearSmithingRecipe.Factory<R> factory;
    private final String recipeFolder;
    private final Item gearItem;
    private final Ingredient template;
    private final Ingredient addition;
    private final Map<String, Criterion<?>> criteria = new LinkedHashMap();

    public GearSmithingRecipeBuilder(GearSmithingRecipe.Factory<R> factory, String recipeFolder, Item gearItem, Ingredient template, Ingredient addition) {
        this.factory = factory;
        this.recipeFolder = recipeFolder;
        this.gearItem = gearItem;
        this.template = template;
        this.addition = addition;
    }

    public static GearSmithingRecipeBuilder<CoatingSmithingRecipe> coating(ItemLike gearItem) {
        return new GearSmithingRecipeBuilder<CoatingSmithingRecipe>(CoatingSmithingRecipe::new, "coating", gearItem.asItem(), Ingredient.of((ItemLike[])new ItemLike[]{SgItems.COATING_SMITHING_TEMPLATE}), new Ingredient((ICustomIngredient)PartMaterialIngredient.of((PartType)PartTypes.COATING.get())));
    }

    public static GearSmithingRecipeBuilder<UpgradeSmithingRecipe> upgrade(ItemLike gearItem, PartType partType) {
        return new GearSmithingRecipeBuilder<UpgradeSmithingRecipe>(UpgradeSmithingRecipe::new, "upgrade", gearItem.asItem(), Ingredient.of((ItemLike[])new ItemLike[]{Items.STICK}), new Ingredient((ICustomIngredient)GearPartIngredient.of(partType)));
    }

    public RecipeBuilder unlockedBy(String pName, Criterion<?> pCriterion) {
        this.criteria.put(pName, pCriterion);
        return this;
    }

    public RecipeBuilder group(@Nullable String pGroupName) {
        return this;
    }

    public Item getResult() {
        return this.gearItem;
    }

    public void save(RecipeOutput pRecipeOutput) {
        String name = "smithing/" + this.recipeFolder + "/" + BuiltInRegistries.ITEM.getKey((Object)this.gearItem).getPath();
        this.save(pRecipeOutput, SilentGear.getId(name));
    }

    public void save(RecipeOutput pRecipeOutput, ResourceLocation pId) {
        Advancement.Builder advancement$builder = null;
        if (!this.criteria.isEmpty()) {
            advancement$builder = pRecipeOutput.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked((ResourceLocation)pId)).rewards(AdvancementRewards.Builder.recipe((ResourceLocation)pId)).requirements(AdvancementRequirements.Strategy.OR);
            this.criteria.forEach((arg_0, arg_1) -> ((Advancement.Builder)advancement$builder).addCriterion(arg_0, arg_1));
        }
        R recipe = this.factory.create(new ItemStack((ItemLike)this.gearItem), this.template, this.addition);
        AdvancementHolder advancementHolder = advancement$builder != null ? advancement$builder.build(pId.withPrefix("recipes/smithing/" + this.recipeFolder + "/")) : null;
        pRecipeOutput.accept(pId, recipe, advancementHolder);
    }
}

