/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.material.Material;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.gear.material.CustomCompoundMaterial;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.item.IColoredMaterialItem;
import net.silentchaos512.gear.item.ItemWithSubItems;
import net.silentchaos512.gear.item.SingleMaterialItem;
import net.silentchaos512.gear.setup.SgRegistries;
import net.silentchaos512.gear.setup.gear.GearTypes;
import net.silentchaos512.gear.setup.gear.PartTypes;
import net.silentchaos512.gear.util.Const;

public class CustomMaterialItem
extends SingleMaterialItem
implements IColoredMaterialItem,
ItemWithSubItems {
    public CustomMaterialItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    @Nullable
    public MaterialInstance getPrimarySubMaterial(ItemStack stack) {
        return CustomMaterialItem.getMaterial(stack);
    }

    @Override
    public int getColor(ItemStack stack, int layer) {
        MaterialInstance material = CustomMaterialItem.getMaterial(stack);
        if (layer == 0 && material != null) {
            return material.getColor((GearType)GearTypes.ALL.get(), (PartType)PartTypes.MAIN.get()) | 0xFF000000;
        }
        return -1;
    }

    public Component getName(ItemStack stack) {
        MaterialInstance material = CustomMaterialItem.getMaterial(stack);
        if (material == null) {
            return super.getName(stack);
        }
        return Component.translatable((String)this.getDescriptionId(), (Object[])new Object[]{material.getDisplayName((PartType)PartTypes.MAIN.get())});
    }

    public void appendHoverText(ItemStack pStack, Item.TooltipContext pContext, List<Component> pTooltipComponents, TooltipFlag pTooltipFlag) {
        MutableComponent translatable = Component.translatable((String)(this.getDescriptionId() + ".literal"));
        MutableComponent withStyle = translatable.withStyle(ChatFormatting.ITALIC);
        pTooltipComponents.add((Component)withStyle);
    }

    @Override
    public void addSubItems(CreativeModeTab.Output output) {
        output.accept(this.create(MaterialInstance.of(Const.Materials.EXAMPLE)));
        for (Material material : SgRegistries.MATERIAL) {
            if (!(material instanceof CustomCompoundMaterial)) continue;
            MaterialInstance mat = MaterialInstance.of(material);
            ItemStack stack = this.create(mat);
            if (!mat.getIngredient().test(stack)) continue;
            output.accept(stack);
        }
    }
}

