/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.loot.modifier;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.silentchaos512.gear.loot.modifier.EnchantedDropsTraitLootModifier;

public class FortuneTraitLootModifier
extends EnchantedDropsTraitLootModifier {
    public static final Supplier<MapCodec<FortuneTraitLootModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.mapCodec(inst -> inst.group((App)Codec.INT.fieldOf("level").forGetter(glm -> glm.traitLevel), (App)IGlobalLootModifier.LOOT_CONDITIONS_CODEC.fieldOf("conditions").forGetter(glm -> glm.conditions)).apply((Applicative)inst, FortuneTraitLootModifier::new)));

    public FortuneTraitLootModifier(int traitLevel, LootItemCondition[] conditionsIn) {
        super(traitLevel, conditionsIn);
    }

    @Override
    protected void addEnchantments(HolderLookup.RegistryLookup<Enchantment> registry, ItemEnchantments.Mutable enchantments, int traitLevel) {
        Holder.Reference fortune = registry.getOrThrow(Enchantments.FORTUNE);
        enchantments.set((Holder)fortune, traitLevel);
    }

    public MapCodec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }
}

