/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.genextras.client.gui;

import com.jerry.genextras.client.gui.GuiNaquadahReactorInfo;
import com.jerry.genextras.client.gui.element.GuiNaquadahReactorTab;
import com.jerry.genextras.common.content.naquadah.NaquadahReactorMultiblockData;
import com.jerry.genextras.common.tile.naquadah.TileEntityNaquadahReactorController;
import mekanism.api.text.EnumColor;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.render.IFancyFontRenderer;
import mekanism.common.inventory.container.tile.EmptyTileContainer;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.UnitDisplayUtils;
import mekanism.common.util.text.EnergyDisplay;
import mekanism.common.util.text.TextUtils;
import mekanism.generators.common.GeneratorsLang;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import org.jetbrains.annotations.NotNull;

public class GuiNaquadahReactorStats
extends GuiNaquadahReactorInfo {
    public GuiNaquadahReactorStats(EmptyTileContainer<TileEntityNaquadahReactorController> container, Inventory inv, Component title) {
        super(container, inv, title);
    }

    @Override
    protected void addGuiElements() {
        super.addGuiElements();
        this.addRenderableWidget((GuiElement)new GuiNaquadahReactorTab((IGuiWrapper)this, (TileEntityNaquadahReactorController)this.tile, GuiNaquadahReactorTab.NaquadahReactorTab.HEAT));
        this.addRenderableWidget((GuiElement)new GuiNaquadahReactorTab((IGuiWrapper)this, (TileEntityNaquadahReactorController)this.tile, GuiNaquadahReactorTab.NaquadahReactorTab.FUEL));
    }

    @Override
    protected void drawForegroundText(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY) {
        NaquadahReactorMultiblockData multiblock = (NaquadahReactorMultiblockData)((TileEntityNaquadahReactorController)this.tile).getMultiblock();
        if (multiblock.isFormed()) {
            int indentation = 4;
            int textArea = this.getXSize() - indentation;
            this.drawScrollingString(guiGraphics, (Component)GeneratorsLang.REACTOR_PASSIVE.translateColored(EnumColor.DARK_GREEN), 0, 26, IFancyFontRenderer.TextAlignment.LEFT, this.titleTextColor(), 6, false);
            this.drawScrollingString(guiGraphics, (Component)GeneratorsLang.REACTOR_MIN_INJECTION.translate(new Object[]{multiblock.getMinInjectionRate(false)}), indentation, 36, IFancyFontRenderer.TextAlignment.LEFT, this.titleTextColor(), textArea, 6, false);
            this.drawScrollingString(guiGraphics, (Component)GeneratorsLang.REACTOR_IGNITION.translate(new Object[]{MekanismUtils.getTemperatureDisplay((double)multiblock.getIgnitionTemperature(false), (UnitDisplayUtils.TemperatureUnit)UnitDisplayUtils.TemperatureUnit.KELVIN, (boolean)true)}), indentation, 46, IFancyFontRenderer.TextAlignment.LEFT, this.titleTextColor(), textArea, 6, false);
            this.drawScrollingString(guiGraphics, (Component)GeneratorsLang.REACTOR_MAX_PLASMA.translate(new Object[]{MekanismUtils.getTemperatureDisplay((double)multiblock.getMaxPlasmaTemperature(false), (UnitDisplayUtils.TemperatureUnit)UnitDisplayUtils.TemperatureUnit.KELVIN, (boolean)true)}), indentation, 56, IFancyFontRenderer.TextAlignment.LEFT, this.titleTextColor(), textArea, 6, false);
            this.drawScrollingString(guiGraphics, (Component)GeneratorsLang.REACTOR_MAX_CASING.translate(new Object[]{MekanismUtils.getTemperatureDisplay((double)multiblock.getMaxCasingTemperature(false), (UnitDisplayUtils.TemperatureUnit)UnitDisplayUtils.TemperatureUnit.KELVIN, (boolean)true)}), indentation, 66, IFancyFontRenderer.TextAlignment.LEFT, this.titleTextColor(), textArea, 6, false);
            this.drawScrollingString(guiGraphics, (Component)GeneratorsLang.REACTOR_PASSIVE_RATE.translate(new Object[]{EnergyDisplay.of((long)multiblock.getPassiveGeneration(false, false))}), indentation, 76, IFancyFontRenderer.TextAlignment.LEFT, this.titleTextColor(), textArea, 6, false);
            this.drawScrollingString(guiGraphics, (Component)GeneratorsLang.REACTOR_ACTIVE.translateColored(EnumColor.DARK_BLUE), 0, 92, IFancyFontRenderer.TextAlignment.LEFT, this.titleTextColor(), 6, false);
            this.drawScrollingString(guiGraphics, (Component)GeneratorsLang.REACTOR_MIN_INJECTION.translate(new Object[]{multiblock.getMinInjectionRate(true)}), indentation, 102, IFancyFontRenderer.TextAlignment.LEFT, this.titleTextColor(), textArea, 6, false);
            this.drawScrollingString(guiGraphics, (Component)GeneratorsLang.REACTOR_IGNITION.translate(new Object[]{MekanismUtils.getTemperatureDisplay((double)multiblock.getIgnitionTemperature(true), (UnitDisplayUtils.TemperatureUnit)UnitDisplayUtils.TemperatureUnit.KELVIN, (boolean)true)}), indentation, 112, IFancyFontRenderer.TextAlignment.LEFT, this.titleTextColor(), textArea, 6, false);
            this.drawScrollingString(guiGraphics, (Component)GeneratorsLang.REACTOR_MAX_PLASMA.translate(new Object[]{MekanismUtils.getTemperatureDisplay((double)multiblock.getMaxPlasmaTemperature(true), (UnitDisplayUtils.TemperatureUnit)UnitDisplayUtils.TemperatureUnit.KELVIN, (boolean)true)}), indentation, 122, IFancyFontRenderer.TextAlignment.LEFT, this.titleTextColor(), textArea, 6, false);
            this.drawScrollingString(guiGraphics, (Component)GeneratorsLang.REACTOR_MAX_CASING.translate(new Object[]{MekanismUtils.getTemperatureDisplay((double)multiblock.getMaxCasingTemperature(true), (UnitDisplayUtils.TemperatureUnit)UnitDisplayUtils.TemperatureUnit.KELVIN, (boolean)true)}), indentation, 132, IFancyFontRenderer.TextAlignment.LEFT, this.titleTextColor(), textArea, 6, false);
            this.drawScrollingString(guiGraphics, (Component)GeneratorsLang.REACTOR_PASSIVE_RATE.translate(new Object[]{EnergyDisplay.of((long)multiblock.getPassiveGeneration(true, false))}), indentation, 142, IFancyFontRenderer.TextAlignment.LEFT, this.titleTextColor(), textArea, 6, false);
            this.drawScrollingString(guiGraphics, (Component)GeneratorsLang.REACTOR_STEAM_PRODUCTION.translate(new Object[]{TextUtils.format((long)multiblock.getSteamPerTick(false))}), indentation, 152, IFancyFontRenderer.TextAlignment.LEFT, this.titleTextColor(), textArea, 6, false);
        }
        super.drawForegroundText(guiGraphics, mouseX, mouseY);
    }
}

