/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.genextras.common.content.naquadah;

import com.jerry.genextras.common.content.naquadah.NaquadahReactorMultiblockData;
import com.jerry.genextras.common.registries.GenExtraBlockTypes;
import com.jerry.genextras.common.tile.naquadah.TileEntityNaquadahReactorController;
import java.util.EnumSet;
import mekanism.api.text.ILangEntry;
import mekanism.common.MekanismLang;
import mekanism.common.content.blocktype.BlockType;
import mekanism.common.lib.math.voxel.VoxelCuboid;
import mekanism.common.lib.multiblock.CuboidStructureValidator;
import mekanism.common.lib.multiblock.FormationProtocol;
import mekanism.common.lib.multiblock.Structure;
import mekanism.common.lib.multiblock.StructureHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class NaquadahReactorValidator
extends CuboidStructureValidator<NaquadahReactorMultiblockData> {
    private static final VoxelCuboid BOUNDS = new VoxelCuboid(9, 9, 9);
    private static final byte[][] ALLOWED_GRID = new byte[][]{{0, 0, 0, 1, 1, 1, 0, 0, 0}, {0, 1, 1, 2, 2, 2, 1, 1, 0}, {0, 1, 2, 2, 2, 2, 2, 1, 0}, {1, 2, 2, 2, 2, 2, 2, 2, 1}, {1, 2, 2, 2, 2, 2, 2, 2, 1}, {1, 2, 2, 2, 2, 2, 2, 2, 1}, {0, 1, 2, 2, 2, 2, 2, 1, 0}, {0, 1, 1, 2, 2, 2, 1, 1, 0}, {0, 0, 0, 1, 1, 1, 0, 0, 0}};

    protected FormationProtocol.StructureRequirement getStructureRequirement(BlockPos pos) {
        VoxelCuboid.WallRelative relative = this.cuboid.getWallRelative(pos);
        if (relative.isWall()) {
            Structure.Axis axis = Structure.Axis.get((Direction)this.cuboid.getSide(pos));
            Structure.Axis h = axis.horizontal();
            Structure.Axis v = axis.vertical();
            pos = pos.subtract((Vec3i)this.cuboid.getMinPos());
            return FormationProtocol.StructureRequirement.REQUIREMENTS[ALLOWED_GRID[h.getCoord(pos)][v.getCoord(pos)]];
        }
        return super.getStructureRequirement(pos);
    }

    protected FormationProtocol.FormationResult validateFrame(FormationProtocol<NaquadahReactorMultiblockData> ctx, BlockPos pos, BlockState state, FormationProtocol.CasingType type, boolean needsFrame) {
        boolean isControllerPos = pos.getY() == this.cuboid.getMaxPos().getY() && pos.getX() == this.cuboid.getMinPos().getX() + 4 && pos.getZ() == this.cuboid.getMinPos().getZ() + 4;
        boolean controller = this.structure.getTile(pos) instanceof TileEntityNaquadahReactorController;
        if (isControllerPos && !controller) {
            return FormationProtocol.FormationResult.fail((ILangEntry)MekanismLang.MULTIBLOCK_INVALID_NO_CONTROLLER);
        }
        if (!isControllerPos && controller) {
            return FormationProtocol.FormationResult.fail((ILangEntry)MekanismLang.MULTIBLOCK_INVALID_CONTROLLER_CONFLICT, (BlockPos)pos, (boolean)true);
        }
        return super.validateFrame(ctx, pos, state, type, needsFrame);
    }

    protected FormationProtocol.CasingType getCasingType(BlockState state) {
        Block block = state.getBlock();
        if (BlockType.is((Block)block, (BlockType[])new BlockType[]{GenExtraBlockTypes.NAQUADAH_REACTOR_CASING})) {
            return FormationProtocol.CasingType.FRAME;
        }
        if (BlockType.is((Block)block, (BlockType[])new BlockType[]{GenExtraBlockTypes.NAQUADAH_REACTOR_PORT})) {
            return FormationProtocol.CasingType.VALVE;
        }
        if (BlockType.is((Block)block, (BlockType[])new BlockType[]{GenExtraBlockTypes.NAQUADAH_REACTOR_CONTROLLER, GenExtraBlockTypes.NAQUADAH_REACTOR_LOGIC_ADAPTER, GenExtraBlockTypes.LEAD_COATED_LASER_FOCUS_MATRIX})) {
            return FormationProtocol.CasingType.OTHER;
        }
        return FormationProtocol.CasingType.INVALID;
    }

    public boolean precheck() {
        this.cuboid = StructureHelper.fetchCuboid((Structure)this.structure, (VoxelCuboid)BOUNDS, (VoxelCuboid)BOUNDS, EnumSet.allOf(VoxelCuboid.CuboidSide.class), (int)120);
        return this.cuboid != null;
    }
}

