/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekextras.client.gui;

import com.jerry.mekextras.client.gui.GuiReinforcedMatrixTab;
import com.jerry.mekextras.common.content.matrix.ReinforcedMatrixMultiblockData;
import com.jerry.mekextras.common.tile.multiblock.TileEntityReinforcedInductionCasing;
import java.util.List;
import mekanism.api.math.MathUtils;
import mekanism.client.gui.GuiMekanismTile;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.bar.GuiBar;
import mekanism.client.gui.element.bar.GuiVerticalRateBar;
import mekanism.client.gui.element.gauge.GaugeType;
import mekanism.client.gui.element.gauge.GuiEnergyGauge;
import mekanism.client.gui.element.tab.GuiEnergyTab;
import mekanism.client.render.IFancyFontRenderer;
import mekanism.common.MekanismLang;
import mekanism.common.inventory.container.tile.EmptyTileContainer;
import mekanism.common.util.text.EnergyDisplay;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import org.jetbrains.annotations.NotNull;

public class GuiReinforcedMatrixStats
extends GuiMekanismTile<TileEntityReinforcedInductionCasing, EmptyTileContainer<TileEntityReinforcedInductionCasing>> {
    public GuiReinforcedMatrixStats(EmptyTileContainer<TileEntityReinforcedInductionCasing> container, Inventory inv, Component title) {
        super(container, inv, title);
    }

    protected void addGuiElements() {
        super.addGuiElements();
        this.addRenderableWidget((GuiElement)new GuiReinforcedMatrixTab((IGuiWrapper)this, (TileEntityReinforcedInductionCasing)this.tile, GuiReinforcedMatrixTab.ReinforcedMatrixTab.MAIN));
        this.addRenderableWidget((GuiElement)new GuiEnergyGauge(new GuiEnergyGauge.IEnergyInfoHandler(){

            public long getEnergy() {
                return ((ReinforcedMatrixMultiblockData)((TileEntityReinforcedInductionCasing)GuiReinforcedMatrixStats.this.tile).getMultiblock()).getEnergy();
            }

            public long getMaxEnergy() {
                return ((ReinforcedMatrixMultiblockData)((TileEntityReinforcedInductionCasing)GuiReinforcedMatrixStats.this.tile).getMultiblock()).getStorageCap();
            }
        }, GaugeType.STANDARD, (IGuiWrapper)this, 6, 13));
        this.addRenderableWidget((GuiElement)new GuiVerticalRateBar((IGuiWrapper)this, new GuiBar.IBarInfoHandler(){

            public Component getTooltip() {
                return MekanismLang.MATRIX_RECEIVING_RATE.translate(new Object[]{EnergyDisplay.of((long)((ReinforcedMatrixMultiblockData)((TileEntityReinforcedInductionCasing)GuiReinforcedMatrixStats.this.tile).getMultiblock()).getLastInput())});
            }

            public double getLevel() {
                ReinforcedMatrixMultiblockData multiBlock = (ReinforcedMatrixMultiblockData)((TileEntityReinforcedInductionCasing)GuiReinforcedMatrixStats.this.tile).getMultiblock();
                return multiBlock.isFormed() ? MathUtils.divideToLevel((double)multiBlock.getLastInput(), (double)multiBlock.getTransferCap()) : 0.0;
            }
        }, 30, 13));
        this.addRenderableWidget((GuiElement)new GuiVerticalRateBar((IGuiWrapper)this, new GuiBar.IBarInfoHandler(){

            public Component getTooltip() {
                return MekanismLang.MATRIX_OUTPUTTING_RATE.translate(new Object[]{EnergyDisplay.of((long)((ReinforcedMatrixMultiblockData)((TileEntityReinforcedInductionCasing)GuiReinforcedMatrixStats.this.tile).getMultiblock()).getLastOutput())});
            }

            public double getLevel() {
                ReinforcedMatrixMultiblockData multiBlock = (ReinforcedMatrixMultiblockData)((TileEntityReinforcedInductionCasing)GuiReinforcedMatrixStats.this.tile).getMultiblock();
                if (!multiBlock.isFormed()) {
                    return 0.0;
                }
                return MathUtils.divideToLevel((double)multiBlock.getLastOutput(), (double)multiBlock.getTransferCap());
            }
        }, 38, 13));
        this.addRenderableWidget((GuiElement)new GuiEnergyTab((IGuiWrapper)this, () -> {
            ReinforcedMatrixMultiblockData multiBlock = (ReinforcedMatrixMultiblockData)((TileEntityReinforcedInductionCasing)this.tile).getMultiblock();
            return List.of(MekanismLang.STORING.translate(new Object[]{EnergyDisplay.of((long)multiBlock.getEnergy(), (long)multiBlock.getStorageCap())}), MekanismLang.MATRIX_INPUT_RATE.translate(new Object[]{EnergyDisplay.of((long)multiBlock.getLastInput())}), MekanismLang.MATRIX_OUTPUT_RATE.translate(new Object[]{EnergyDisplay.of((long)multiBlock.getLastOutput())}));
        }));
    }

    protected void drawForegroundText(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY) {
        this.renderTitleText(guiGraphics);
        ReinforcedMatrixMultiblockData multiBlock = (ReinforcedMatrixMultiblockData)((TileEntityReinforcedInductionCasing)this.tile).getMultiblock();
        this.drawScrollingString(guiGraphics, (Component)MekanismLang.INPUT.translate(), 45, 26, IFancyFontRenderer.TextAlignment.LEFT, this.subheadingTextColor(), this.getXSize() - 54, 8, false);
        this.drawScrollingString(guiGraphics, EnergyDisplay.of((long)multiBlock.getLastInput(), (long)multiBlock.getTransferCap()).getTextComponent(), 51, 35, IFancyFontRenderer.TextAlignment.LEFT, this.titleTextColor(), this.getXSize() - 60, 8, false);
        this.drawScrollingString(guiGraphics, (Component)MekanismLang.OUTPUT.translate(), 45, 46, IFancyFontRenderer.TextAlignment.LEFT, this.subheadingTextColor(), this.getXSize() - 54, 8, false);
        this.drawScrollingString(guiGraphics, EnergyDisplay.of((long)multiBlock.getLastOutput(), (long)multiBlock.getTransferCap()).getTextComponent(), 51, 55, IFancyFontRenderer.TextAlignment.LEFT, this.titleTextColor(), this.getXSize() - 60, 8, false);
        this.drawScrollingString(guiGraphics, (Component)MekanismLang.MATRIX_DIMENSIONS.translate(), 0, 82, IFancyFontRenderer.TextAlignment.LEFT, this.subheadingTextColor(), 8, false);
        if (multiBlock.isFormed()) {
            this.drawScrollingString(guiGraphics, (Component)MekanismLang.MATRIX_DIMENSION_REPRESENTATION.translate(new Object[]{multiBlock.width(), multiBlock.height(), multiBlock.length()}), 6, 91, IFancyFontRenderer.TextAlignment.LEFT, this.titleTextColor(), this.getXSize() - 6, 8, false);
        }
        this.drawScrollingString(guiGraphics, (Component)MekanismLang.MATRIX_CONSTITUENTS.translate(), 0, 102, IFancyFontRenderer.TextAlignment.LEFT, this.subheadingTextColor(), 8, false);
        this.drawScrollingString(guiGraphics, (Component)MekanismLang.MATRIX_CELLS.translate(new Object[]{multiBlock.getCellCount()}), 6, 111, IFancyFontRenderer.TextAlignment.LEFT, this.titleTextColor(), this.getXSize() - 6, 8, false);
        this.drawScrollingString(guiGraphics, (Component)MekanismLang.MATRIX_PROVIDERS.translate(new Object[]{multiBlock.getProviderCount()}), 6, 120, IFancyFontRenderer.TextAlignment.LEFT, this.titleTextColor(), this.getXSize() - 6, 8, false);
        super.drawForegroundText(guiGraphics, mouseX, mouseY);
    }
}

