/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekextras.client.model.energycube;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.jerry.mekextras.client.model.energycube.ExtraEnergyCubeGeometry;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Locale;
import mekanism.api.RelativeSide;
import mekanism.common.util.EnumUtils;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.util.GsonHelper;
import net.neoforged.neoforge.client.model.geometry.IGeometryLoader;
import org.jetbrains.annotations.NotNull;

public class ExtraEnergyCubeModelLoader
implements IGeometryLoader<ExtraEnergyCubeGeometry> {
    public static final ExtraEnergyCubeModelLoader INSTANCE = new ExtraEnergyCubeModelLoader();

    private ExtraEnergyCubeModelLoader() {
    }

    @NotNull
    public ExtraEnergyCubeGeometry read(@NotNull JsonObject jsonObject, @NotNull JsonDeserializationContext ctx) throws JsonParseException {
        List<BlockElement> frame = this.readElements(jsonObject, ctx, "frame");
        EnumMap<RelativeSide, List<BlockElement>> leds = new EnumMap<RelativeSide, List<BlockElement>>(RelativeSide.class);
        EnumMap<RelativeSide, List<BlockElement>> ports = new EnumMap<RelativeSide, List<BlockElement>>(RelativeSide.class);
        for (RelativeSide side : EnumUtils.SIDES) {
            String name = side.name().toLowerCase(Locale.ROOT);
            leds.put(side, this.readElements(jsonObject, ctx, name + "LEDs"));
            ports.put(side, this.readElements(jsonObject, ctx, name + "Port"));
        }
        return new ExtraEnergyCubeGeometry(frame, leds, ports);
    }

    private List<BlockElement> readElements(JsonObject jsonObject, JsonDeserializationContext ctx, String key) {
        ArrayList<BlockElement> elements = new ArrayList<BlockElement>();
        for (JsonElement element : GsonHelper.getAsJsonArray((JsonObject)jsonObject, (String)key)) {
            elements.add((BlockElement)ctx.deserialize(element, BlockElement.class));
        }
        if (elements.isEmpty()) {
            throw new JsonParseException("Energy cube models requires a \"" + key + "\" element with at least one element.");
        }
        return elements;
    }
}

