/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekextras.client.render.transmitter;

import com.jerry.mekextras.common.content.network.transmitter.ExtraPressurizedTube;
import com.jerry.mekextras.common.tile.transmitter.ExtraTileEntityPressurizedTube;
import com.mojang.blaze3d.vertex.PoseStack;
import mekanism.api.MekanismAPI;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.render.transmitter.RenderTransmitterBase;
import mekanism.common.content.network.ChemicalNetwork;
import mekanism.common.tile.transmitter.TileEntityTransmitter;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Holder;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@NothingNullByDefault
public class ExtraRenderPressurizedTube
extends RenderTransmitterBase<ExtraTileEntityPressurizedTube> {
    public ExtraRenderPressurizedTube(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    protected void render(@NotNull ExtraTileEntityPressurizedTube tile, float partialTick, PoseStack matrix, MultiBufferSource renderer, int light, int overlayLight, ProfilerFiller profiler) {
        ChemicalNetwork network = (ChemicalNetwork)tile.getTransmitter().getTransmitterNetwork();
        matrix.pushPose();
        matrix.translate(0.5, 0.5, 0.5);
        this.renderModel(tile, matrix, renderer.getBuffer(Sheets.translucentCullBlockSheet()), MekanismRenderer.getTint((Holder)network.lastChemical), Math.max(0.2f, network.currentScale), 0xF000F0, overlayLight, MekanismRenderer.getChemicalTexture((Holder)network.lastChemical));
        matrix.popPose();
    }

    @NotNull
    protected String getProfilerSection() {
        return "pressurizedTube";
    }

    protected boolean shouldRenderTransmitter(@NotNull ExtraTileEntityPressurizedTube tile, @NotNull Vec3 camera) {
        ExtraPressurizedTube tube;
        if (super.shouldRenderTransmitter((TileEntityTransmitter)tile, camera) && (tube = tile.getTransmitter()).hasTransmitterNetwork()) {
            ChemicalNetwork network = (ChemicalNetwork)tube.getTransmitterNetwork();
            return !network.lastChemical.is(MekanismAPI.EMPTY_CHEMICAL_KEY) && !network.getChemicalTank().isEmpty() && network.currentScale > 0.0f;
        }
        return false;
    }
}

