/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekextras.common.block;

import com.jerry.mekextras.common.tile.ExtraTileEntityEnergyCube;
import mekanism.api.RelativeSide;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.block.prefab.BlockTile;
import mekanism.common.content.blocktype.Machine;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.tile.component.config.ConfigInfo;
import mekanism.common.tile.component.config.slot.ISlotInfo;
import mekanism.common.util.VoxelShapeUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class ExtraBlockEnergyCube
extends BlockTile.BlockTileModel<ExtraTileEntityEnergyCube, Machine<ExtraTileEntityEnergyCube>> {
    private static final VoxelShape[] bounds = new VoxelShape[256];

    private static int getIndex(int top, int bottom, int front, int back, int left, int right, boolean rotateVertical, boolean rotateHorizontal) {
        return top | bottom << 1 | front << 2 | back << 3 | left << 4 | right << 5 | (rotateVertical ? 1 : 0) << 6 | (rotateHorizontal ? 1 : 0) << 7;
    }

    public ExtraBlockEnergyCube(Machine<ExtraTileEntityEnergyCube> type) {
        super(type, BlockBehaviour.Properties.of().strength(2.0f, 2.4f).requiresCorrectToolForDrops().dynamicShape().mapColor(MapColor.DEEPSLATE));
    }

    @Deprecated
    public boolean isPathfindable(@NotNull BlockState state, @NotNull PathComputationType pathType) {
        return false;
    }

    @Deprecated
    @NotNull
    public VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        int index;
        ExtraTileEntityEnergyCube energyCube = (ExtraTileEntityEnergyCube)WorldUtils.getTileEntity(ExtraTileEntityEnergyCube.class, (BlockGetter)world, (BlockPos)pos);
        if (energyCube == null) {
            index = ExtraBlockEnergyCube.getIndex(1, 1, 1, 1, 1, 1, false, false);
        } else {
            ConfigInfo energyConfig = energyCube.configComponent.getConfig(TransmissionType.ENERGY);
            if (energyConfig == null) {
                index = ExtraBlockEnergyCube.getIndex(1, 1, 1, 1, 1, 1, false, false);
            } else {
                Direction facing = Attribute.getFacing((BlockState)state);
                index = ExtraBlockEnergyCube.getIndex(ExtraBlockEnergyCube.isSideEnabled(energyConfig, facing, Direction.UP), ExtraBlockEnergyCube.isSideEnabled(energyConfig, facing, Direction.DOWN), ExtraBlockEnergyCube.isSideEnabled(energyConfig, facing, Direction.SOUTH), ExtraBlockEnergyCube.isSideEnabled(energyConfig, facing, Direction.NORTH), ExtraBlockEnergyCube.isSideEnabled(energyConfig, facing, Direction.EAST), ExtraBlockEnergyCube.isSideEnabled(energyConfig, facing, Direction.WEST), facing == Direction.EAST || facing == Direction.WEST, facing == Direction.DOWN || facing == Direction.UP);
            }
        }
        return bounds[index];
    }

    private static int isSideEnabled(ConfigInfo energyConfig, Direction facing, Direction side) {
        ISlotInfo slotInfo = energyConfig.getSlotInfo(RelativeSide.fromDirections((Direction)facing, (Direction)side));
        return slotInfo != null && slotInfo.isEnabled() ? 1 : 0;
    }

    static {
        VoxelShape frame = VoxelShapeUtils.combine((VoxelShape[])new VoxelShape[]{ExtraBlockEnergyCube.box((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)3.0, (double)16.0), ExtraBlockEnergyCube.box((double)0.0, (double)3.0, (double)0.0, (double)3.0, (double)16.0, (double)3.0), ExtraBlockEnergyCube.box((double)0.0, (double)3.0, (double)13.0, (double)3.0, (double)16.0, (double)16.0), ExtraBlockEnergyCube.box((double)0.0, (double)13.0, (double)3.0, (double)3.0, (double)16.0, (double)13.0), ExtraBlockEnergyCube.box((double)3.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)3.0), ExtraBlockEnergyCube.box((double)3.0, (double)0.0, (double)13.0, (double)16.0, (double)3.0, (double)16.0), ExtraBlockEnergyCube.box((double)3.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)3.0), ExtraBlockEnergyCube.box((double)3.0, (double)13.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0), ExtraBlockEnergyCube.box((double)13.0, (double)0.0, (double)3.0, (double)16.0, (double)3.0, (double)13.0), ExtraBlockEnergyCube.box((double)13.0, (double)3.0, (double)0.0, (double)16.0, (double)13.0, (double)3.0), ExtraBlockEnergyCube.box((double)13.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0, (double)16.0), ExtraBlockEnergyCube.box((double)13.0, (double)13.0, (double)3.0, (double)16.0, (double)16.0, (double)13.0), ExtraBlockEnergyCube.box((double)12.5, (double)15.0, (double)7.5, (double)13.5, (double)15.9, (double)8.5), ExtraBlockEnergyCube.box((double)2.5, (double)15.0, (double)7.5, (double)3.5, (double)15.9, (double)8.5), ExtraBlockEnergyCube.box((double)12.5, (double)7.5, (double)0.1, (double)13.5, (double)8.5, (double)1.0), ExtraBlockEnergyCube.box((double)2.5, (double)7.5, (double)0.1, (double)3.5, (double)8.5, (double)1.0), ExtraBlockEnergyCube.box((double)2.5, (double)0.1, (double)7.5, (double)3.5, (double)1.0, (double)8.5), ExtraBlockEnergyCube.box((double)12.5, (double)0.1, (double)7.5, (double)13.5, (double)1.0, (double)8.5), ExtraBlockEnergyCube.box((double)12.5, (double)7.5, (double)15.0, (double)13.5, (double)8.5, (double)15.9), ExtraBlockEnergyCube.box((double)2.5, (double)7.5, (double)15.0, (double)3.5, (double)8.5, (double)15.9), ExtraBlockEnergyCube.box((double)0.1, (double)7.5, (double)2.5, (double)1.0, (double)8.5, (double)3.5), ExtraBlockEnergyCube.box((double)0.1, (double)7.5, (double)12.5, (double)1.0, (double)8.5, (double)13.5), ExtraBlockEnergyCube.box((double)15.0, (double)7.5, (double)2.5, (double)15.9, (double)8.5, (double)3.5), ExtraBlockEnergyCube.box((double)15.0, (double)7.5, (double)12.5, (double)15.9, (double)8.5, (double)13.5)});
        VoxelShape frontPanel = VoxelShapeUtils.combine((VoxelShape[])new VoxelShape[]{ExtraBlockEnergyCube.box((double)3.0, (double)5.0, (double)14.0, (double)13.0, (double)11.0, (double)15.0), ExtraBlockEnergyCube.box((double)4.0, (double)4.0, (double)15.0, (double)12.0, (double)12.0, (double)16.0)});
        VoxelShape rightPanel = VoxelShapeUtils.combine((VoxelShape[])new VoxelShape[]{ExtraBlockEnergyCube.box((double)1.0, (double)5.0, (double)3.0, (double)2.0, (double)11.0, (double)13.0), ExtraBlockEnergyCube.box((double)0.0, (double)4.0, (double)4.0, (double)1.0, (double)12.0, (double)12.0)});
        VoxelShape leftPanel = VoxelShapeUtils.combine((VoxelShape[])new VoxelShape[]{ExtraBlockEnergyCube.box((double)14.0, (double)5.0, (double)3.0, (double)15.0, (double)11.0, (double)13.0), ExtraBlockEnergyCube.box((double)15.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0, (double)12.0)});
        VoxelShape backPanel = VoxelShapeUtils.combine((VoxelShape[])new VoxelShape[]{ExtraBlockEnergyCube.box((double)3.0, (double)5.0, (double)1.0, (double)13.0, (double)11.0, (double)2.0), ExtraBlockEnergyCube.box((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)1.0)});
        VoxelShape topPanel = VoxelShapeUtils.combine((VoxelShape[])new VoxelShape[]{ExtraBlockEnergyCube.box((double)3.0, (double)14.0, (double)5.0, (double)13.0, (double)15.0, (double)11.0), ExtraBlockEnergyCube.box((double)4.0, (double)15.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0)});
        VoxelShape bottomPanel = VoxelShapeUtils.combine((VoxelShape[])new VoxelShape[]{ExtraBlockEnergyCube.box((double)3.0, (double)1.0, (double)5.0, (double)13.0, (double)2.0, (double)11.0), ExtraBlockEnergyCube.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)1.0, (double)12.0)});
        VoxelShape frameRotated = VoxelShapeUtils.rotate((VoxelShape)frame, (Rotation)Rotation.CLOCKWISE_90);
        VoxelShape topRotated = VoxelShapeUtils.rotate((VoxelShape)topPanel, (Rotation)Rotation.CLOCKWISE_90);
        VoxelShape bottomRotated = VoxelShapeUtils.rotate((VoxelShape)bottomPanel, (Rotation)Rotation.CLOCKWISE_90);
        VoxelShape frameRotatedAlt = VoxelShapeUtils.rotate((VoxelShape)frame, (Direction)Direction.NORTH);
        VoxelShape rightRotated = VoxelShapeUtils.rotate((VoxelShape)rightPanel, (Direction)Direction.NORTH);
        VoxelShape leftRotated = VoxelShapeUtils.rotate((VoxelShape)leftPanel, (Direction)Direction.NORTH);
        for (int rotated = 0; rotated < 3; ++rotated) {
            boolean rotateHorizontal;
            boolean rotateVertical = rotated == 1;
            boolean bl = rotateHorizontal = rotated == 2;
            VoxelShape baseFrame = rotateVertical ? frameRotated : (rotateHorizontal ? frameRotatedAlt : frame);
            for (int top = 0; top < 2; ++top) {
                VoxelShape withTop = top == 0 ? baseFrame : Shapes.or((VoxelShape)baseFrame, (VoxelShape)(rotateVertical ? topRotated : topPanel));
                for (int bottom = 0; bottom < 2; ++bottom) {
                    VoxelShape withBottom = bottom == 0 ? withTop : Shapes.or((VoxelShape)withTop, (VoxelShape)(rotateVertical ? bottomRotated : bottomPanel));
                    for (int front = 0; front < 2; ++front) {
                        VoxelShape withFront = front == 0 ? withBottom : Shapes.or((VoxelShape)withBottom, (VoxelShape)frontPanel);
                        for (int back = 0; back < 2; ++back) {
                            VoxelShape withBack = back == 0 ? withFront : Shapes.or((VoxelShape)withFront, (VoxelShape)backPanel);
                            for (int left = 0; left < 2; ++left) {
                                VoxelShape withLeft = left == 0 ? withBack : Shapes.or((VoxelShape)withBack, (VoxelShape)(rotateHorizontal ? leftRotated : leftPanel));
                                for (int right = 0; right < 2; ++right) {
                                    VoxelShape withRight;
                                    ExtraBlockEnergyCube.bounds[ExtraBlockEnergyCube.getIndex((int)top, (int)bottom, (int)front, (int)back, (int)left, (int)right, (boolean)rotateVertical, (boolean)rotateHorizontal)] = withRight = right == 0 ? withLeft : Shapes.or((VoxelShape)withLeft, (VoxelShape)(rotateHorizontal ? rightRotated : rightPanel));
                                }
                            }
                        }
                    }
                }
            }
        }
    }
}

