/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekextras.common.capabilities.energy;

import com.jerry.mekextras.common.tier.ECTier;
import java.util.Objects;
import java.util.function.LongSupplier;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.IContentsListener;
import mekanism.api.functions.ConstantPredicates;
import mekanism.common.capabilities.energy.BasicEnergyContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExtraEnergyCubeEnergyContainer
extends BasicEnergyContainer {
    private final boolean isCreative;
    private final LongSupplier rate = tier::getOutput;

    public static ExtraEnergyCubeEnergyContainer create(ECTier tier, @Nullable IContentsListener listener) {
        Objects.requireNonNull(tier, "Energy cube tier cannot be null");
        return new ExtraEnergyCubeEnergyContainer(tier, listener);
    }

    protected ExtraEnergyCubeEnergyContainer(ECTier tier, @Nullable IContentsListener listener) {
        super(tier.getMaxEnergy(), ConstantPredicates.alwaysTrue(), ConstantPredicates.alwaysTrue(), listener);
        this.isCreative = false;
    }

    protected long getInsertRate(@Nullable AutomationType automationType) {
        return automationType == AutomationType.INTERNAL ? this.rate.getAsLong() : super.getInsertRate(automationType);
    }

    public long getExtractRate(AutomationType automationType) {
        return automationType == AutomationType.INTERNAL ? this.rate.getAsLong() : super.getExtractRate(automationType);
    }

    public long insert(long amount, Action action, @NotNull AutomationType automationType) {
        return super.insert(amount, action.combine(!this.isCreative), automationType);
    }

    public long extract(long amount, Action action, @NotNull AutomationType automationType) {
        return super.extract(amount, action.combine(!this.isCreative), automationType);
    }
}

