/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekextras.common.command.builders;

import com.jerry.genextras.common.registries.GenExtraBlocks;
import com.jerry.mekextras.common.registries.ExtraBlocks;
import mekanism.common.command.builders.StructureBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class ExtraBuilders {
    private ExtraBuilders() {
    }

    public static class ReinforcedMatrixBuilder
    extends StructureBuilder {
        public ReinforcedMatrixBuilder() {
            super(18, 18, 18);
        }

        public void build(Level world, BlockPos start, boolean empty) {
            this.buildFrame(world, start);
            this.buildWalls(world, start);
            if (empty) {
                this.buildInteriorLayers(world, start, 1, 16, Blocks.AIR.defaultBlockState());
            } else {
                this.buildInteriorLayers(world, start, 1, 15, ExtraBlocks.INFINITE_INDUCTION_CELL.defaultState());
                this.buildInteriorLayer(world, start, 16, ExtraBlocks.INFINITE_INDUCTION_PROVIDER.defaultState());
            }
        }

        protected BlockState getCasing() {
            return ExtraBlocks.REINFORCED_INDUCTION_CASING.defaultState();
        }
    }

    public static class NaquadahReactorBuilder
    extends StructureBuilder {
        public NaquadahReactorBuilder() {
            super(9, 9, 9);
        }

        protected void build(Level world, BlockPos start, boolean empty) {
            this.buildPartialFrame(world, start, 2);
            this.buildWalls(world, start);
            this.buildInteriorLayers(world, start, 1, 7, Blocks.AIR.defaultBlockState());
            world.setBlockAndUpdate(start.offset(4, 8, 4), GenExtraBlocks.NAQUADAH_REACTOR_CONTROLLER.defaultState());
        }

        protected BlockState getWallBlock(BlockPos pos) {
            return GenExtraBlocks.NAQUADAH_REACTOR_CASING.defaultState();
        }

        protected BlockState getCasing() {
            return GenExtraBlocks.NAQUADAH_REACTOR_CASING.defaultState();
        }
    }
}

