/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekextras.common.content.blocktype;

import com.jerry.mekextras.common.block.attribute.ExtraAttributeTier;
import com.jerry.mekextras.common.block.attribute.ExtraAttributeUpgradeable;
import com.jerry.mekextras.common.content.blocktype.ExtraMachine;
import com.jerry.mekextras.common.registries.ExtraBlockTypes;
import com.jerry.mekextras.common.registries.ExtraBlocks;
import com.jerry.mekextras.common.registries.ExtraContainerTypes;
import com.jerry.mekextras.common.tier.ExtraFactoryTier;
import com.jerry.mekextras.common.tile.factory.TileEntityExtraFactory;
import com.jerry.mekextras.common.util.ExtraEnumUtils;
import java.util.function.Supplier;
import mekanism.api.math.MathUtils;
import mekanism.api.text.ILangEntry;
import mekanism.common.MekanismLang;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.block.attribute.AttributeEnergy;
import mekanism.common.block.attribute.AttributeFactoryType;
import mekanism.common.block.attribute.AttributeGui;
import mekanism.common.block.attribute.AttributeParticleFX;
import mekanism.common.block.attribute.AttributeSideConfig;
import mekanism.common.block.attribute.AttributeSound;
import mekanism.common.block.attribute.AttributeUpgradeSupport;
import mekanism.common.content.blocktype.BlockShapes;
import mekanism.common.content.blocktype.BlockTypeTile;
import mekanism.common.content.blocktype.FactoryType;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.lib.math.Pos3D;
import mekanism.common.registration.impl.ContainerTypeRegistryObject;
import mekanism.common.registration.impl.TileEntityTypeRegistryObject;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import org.jetbrains.annotations.NotNull;

public class ExtraFactory<TILE extends TileEntityExtraFactory<?>>
extends ExtraMachine.ExtraFactoryMachine<TILE> {
    private final ExtraMachine.ExtraFactoryMachine<?> origMachine;

    public ExtraFactory(Supplier<TileEntityTypeRegistryObject<TILE>> tileEntityRegistrar, Supplier<ContainerTypeRegistryObject<? extends MekanismContainer>> containerRegistrar, ExtraMachine.ExtraFactoryMachine<?> origMachine, ExtraFactoryTier tier) {
        super(tileEntityRegistrar, (ILangEntry)MekanismLang.DESCRIPTION_FACTORY, origMachine.getFactoryType());
        this.origMachine = origMachine;
        this.setMachineData(tier);
        this.add(new Attribute[]{new AttributeGui(containerRegistrar, null), new ExtraAttributeTier<ExtraFactoryTier>(tier)});
        if (tier.ordinal() < ExtraEnumUtils.ADVANCED_FACTORY_TIERS.length - 1) {
            this.add(new Attribute[]{new ExtraAttributeUpgradeable(() -> ExtraBlocks.getExtraFactory(ExtraEnumUtils.ADVANCED_FACTORY_TIERS[tier.ordinal() + 1], origMachine.getFactoryType()))});
        }
    }

    private void setMachineData(ExtraFactoryTier tier) {
        this.setFrom((BlockTypeTile)this.origMachine, new Class[]{AttributeSound.class, AttributeFactoryType.class, AttributeUpgradeSupport.class});
        AttributeEnergy origEnergy = (AttributeEnergy)this.origMachine.get(AttributeEnergy.class);
        Attribute[] attributeArray = new Attribute[1];
        attributeArray[0] = new AttributeEnergy(() -> ((AttributeEnergy)origEnergy).getUsage(), () -> MathUtils.clampToLong((double)(Math.max(origEnergy.getConfigStorage(), origEnergy.getUsage()) * (long)tier.processes)));
        this.add(attributeArray);
    }

    @NotNull
    private static <TILE extends TileEntityExtraFactory<?>> ExtraFactoryBuilder<ExtraFactory<TILE>, TILE, ?> getAdvancedFactoryTILEAdvancedFactoryBuilder(Supplier<TileEntityTypeRegistryObject<TILE>> tileEntityRegistrar, FactoryType type, ExtraFactoryTier tier) {
        Supplier<ContainerTypeRegistryObject<? extends MekanismContainer>> supplier = () -> ExtraContainerTypes.FACTORY;
        ExtraFactoryBuilder builder = new ExtraFactoryBuilder(new ExtraFactory<TILE>(tileEntityRegistrar, supplier, switch (type) {
            default -> throw new MatchException(null, null);
            case FactoryType.SAWING -> ExtraBlockTypes.PRECISION_SAWMILL;
            case FactoryType.SMELTING -> ExtraBlockTypes.ENERGIZED_SMELTER;
            case FactoryType.ENRICHING -> ExtraBlockTypes.ENRICHMENT_CHAMBER;
            case FactoryType.CRUSHING -> ExtraBlockTypes.CRUSHER;
            case FactoryType.COMPRESSING -> ExtraBlockTypes.OSMIUM_COMPRESSOR;
            case FactoryType.COMBINING -> ExtraBlockTypes.COMBINER;
            case FactoryType.PURIFYING -> ExtraBlockTypes.PURIFICATION_CHAMBER;
            case FactoryType.INJECTING -> ExtraBlockTypes.CHEMICAL_INJECTION_CHAMBER;
            case FactoryType.INFUSING -> ExtraBlockTypes.METALLURGIC_INFUSER;
        }, tier));
        builder.withComputerSupport(tier.getAdvanceTier().getLowerName() + type.getRegistryNameComponentCapitalized() + "Factory");
        return builder;
    }

    public static class ExtraFactoryBuilder<FACTORY extends ExtraFactory<TILE>, TILE extends TileEntityExtraFactory<?>, T extends ExtraMachine.ExtraMachineBuilder<FACTORY, TILE, T>>
    extends BlockTypeTile.BlockTileBuilder<FACTORY, TILE, T> {
        protected ExtraFactoryBuilder(FACTORY holder) {
            super(holder);
        }

        public static <TILE extends TileEntityExtraFactory<?>> ExtraFactoryBuilder<ExtraFactory<TILE>, TILE, ?> createFactory(Supplier<?> tileEntityRegistrar, FactoryType type, ExtraFactoryTier tier) {
            ExtraFactoryBuilder builder = ExtraFactory.getAdvancedFactoryTILEAdvancedFactoryBuilder(tileEntityRegistrar, type, tier);
            builder.withCustomShape(BlockShapes.getShape(null, (FactoryType)type));
            Attribute[] attributeArray = new Attribute[1];
            attributeArray[0] = switch (type) {
                default -> throw new MatchException(null, null);
                case FactoryType.SMELTING, FactoryType.ENRICHING, FactoryType.CRUSHING, FactoryType.COMBINING, FactoryType.SAWING -> AttributeSideConfig.ELECTRIC_MACHINE;
                case FactoryType.COMPRESSING, FactoryType.INJECTING, FactoryType.PURIFYING, FactoryType.INFUSING -> AttributeSideConfig.ADVANCED_ELECTRIC_MACHINE;
            };
            builder.with(attributeArray);
            builder.replace(new Attribute[]{new AttributeParticleFX().addDense((ParticleOptions)ParticleTypes.SMOKE, 5, rand -> new Pos3D((double)(rand.nextFloat() * 0.7f - 0.3f), (double)(rand.nextFloat() * 0.1f + 0.7f), (double)(rand.nextFloat() * 0.7f - 0.3f)))});
            return builder;
        }
    }
}

