/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekextras.common.content.network.transmitter;

import com.jerry.mekextras.common.tier.transmitter.TTier;
import com.jerry.mekextras.common.tile.transmitter.ExtraTileEntityTransmitter;
import com.jerry.mekextras.common.util.IExtraUpgradeableTransmitter;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalHandler;
import mekanism.api.chemical.IChemicalTank;
import mekanism.common.capabilities.chemical.IChemicalTracker;
import mekanism.common.content.network.ChemicalNetwork;
import mekanism.common.content.network.transmitter.PressurizedTube;
import mekanism.common.lib.transmitter.ConnectionType;
import mekanism.common.lib.transmitter.acceptor.AcceptorCache;
import mekanism.common.tile.transmitter.TileEntityTransmitter;
import mekanism.common.upgrade.transmitter.PressurizedTubeUpgradeData;
import mekanism.common.upgrade.transmitter.TransmitterUpgradeData;
import mekanism.common.util.EnumUtils;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExtraPressurizedTube
extends PressurizedTube
implements IChemicalTracker,
IExtraUpgradeableTransmitter<PressurizedTubeUpgradeData> {
    public ExtraPressurizedTube(Holder<Block> blockProvider, ExtraTileEntityTransmitter tile) {
        super(blockProvider, (TileEntityTransmitter)tile);
    }

    public void pullFromAcceptors() {
        if (!this.hasPullSide || this.getAvailablePull() <= 0L) {
            return;
        }
        AcceptorCache acceptorCache = this.getAcceptorCache();
        for (Direction side : EnumUtils.DIRECTIONS) {
            IChemicalHandler connectedAcceptor;
            if (!this.isConnectionType(side, ConnectionType.PULL) || (connectedAcceptor = (IChemicalHandler)acceptorCache.getConnectedAcceptor(side)) == null) continue;
            ChemicalStack bufferWithFallback = this.getBufferWithFallback();
            this.pullFromAcceptor(connectedAcceptor, bufferWithFallback, bufferWithFallback.isEmpty());
        }
    }

    private boolean pullFromAcceptor(IChemicalHandler connectedAcceptor, ChemicalStack bufferWithFallback, boolean bufferIsEmpty) {
        if (connectedAcceptor == null) {
            return false;
        }
        long availablePull = this.getAvailablePull();
        ChemicalStack received = bufferIsEmpty ? connectedAcceptor.extractChemical(availablePull, Action.SIMULATE) : connectedAcceptor.extractChemical(bufferWithFallback.copyWithAmount(availablePull), Action.SIMULATE);
        if (!received.isEmpty() && this.takeChemical(received, Action.SIMULATE).isEmpty()) {
            this.takeChemical(connectedAcceptor.extractChemical(received, Action.EXECUTE), Action.EXECUTE);
            return true;
        }
        return false;
    }

    private long getAvailablePull() {
        if (this.hasTransmitterNetwork()) {
            return Math.min(TTier.getTubePullAmount(this.tier), ((ChemicalNetwork)this.getTransmitterNetwork()).chemicalTank.getNeeded());
        }
        return Math.min(TTier.getTubePullAmount(this.tier), this.chemicalTank.getNeeded());
    }

    @Override
    @Nullable
    public PressurizedTubeUpgradeData getUpgradeData() {
        return super.getUpgradeData();
    }

    @Override
    public boolean dataTypeMatches(@NotNull TransmitterUpgradeData data) {
        return data instanceof PressurizedTubeUpgradeData;
    }

    @Override
    public void parseUpgradeData(@NotNull PressurizedTubeUpgradeData data) {
        this.redstoneReactive = data.redstoneReactive;
        this.setConnectionTypesRaw(data.connectionTypes);
        this.takeChemical(data.contents, Action.EXECUTE);
    }

    public long getCapacity() {
        return TTier.getTubeCapacity(this.tier);
    }

    private ChemicalStack takeChemical(ChemicalStack stack, Action action) {
        IChemicalTank tank = this.hasTransmitterNetwork() ? ((ChemicalNetwork)this.getTransmitterNetwork()).chemicalTank : this.chemicalTank;
        return tank.insert(stack, action, AutomationType.INTERNAL);
    }
}

