/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekextras.common.recipe.bin;

import com.jerry.mekextras.common.attachments.containers.item.ExtraComponentBackedBinInventorySlot;
import com.jerry.mekextras.common.item.block.ExtraItemBlockBin;
import com.jerry.mekextras.common.recipe.bin.ExtraBinRecipe;
import com.jerry.mekextras.common.registries.ExtraRecipeSerializersInternal;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.ArrayList;
import java.util.function.Supplier;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.common.registries.MekanismDataComponents;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;

@NothingNullByDefault
public class ExtraBinInsertRecipe
extends ExtraBinRecipe {
    public ExtraBinInsertRecipe(CraftingBookCategory category) {
        super(category);
    }

    public boolean matches(CraftingInput inv, Level world) {
        ItemStack binStack = ItemStack.EMPTY;
        ItemStack foundType = ItemStack.EMPTY;
        int slots = inv.size();
        for (int i = 0; i < slots; ++i) {
            ItemStack stackInSlot = inv.getItem(i);
            if (stackInSlot.isEmpty()) continue;
            if (stackInSlot.getItem() instanceof ExtraItemBlockBin) {
                if (!binStack.isEmpty() || stackInSlot.getCount() > 1) {
                    return false;
                }
                binStack = stackInSlot;
                continue;
            }
            if (foundType.isEmpty()) {
                foundType = stackInSlot;
                continue;
            }
            if (ItemStack.isSameItemSameComponents((ItemStack)foundType, (ItemStack)stackInSlot)) continue;
            return false;
        }
        if (binStack.isEmpty() || foundType.isEmpty()) {
            return false;
        }
        ExtraComponentBackedBinInventorySlot slot = ExtraBinInsertRecipe.convertToSlot(binStack);
        ItemStack remaining = slot.insertItem(foundType, Action.SIMULATE, AutomationType.MANUAL);
        return !ItemStack.matches((ItemStack)remaining, (ItemStack)foundType);
    }

    public ItemStack assemble(CraftingInput inv, HolderLookup.Provider provider) {
        ItemStack binStack = ItemStack.EMPTY;
        ItemStack foundType = ItemStack.EMPTY;
        ArrayList<ItemStack> foundItems = new ArrayList<ItemStack>();
        int slots = inv.size();
        for (int i = 0; i < slots; ++i) {
            ItemStack stackInSlot = inv.getItem(i);
            if (stackInSlot.isEmpty()) continue;
            if (stackInSlot.getItem() instanceof ExtraItemBlockBin) {
                if (!binStack.isEmpty() || stackInSlot.getCount() > 1) {
                    return ItemStack.EMPTY;
                }
                binStack = stackInSlot;
                continue;
            }
            if (foundType.isEmpty()) {
                foundType = stackInSlot;
            } else if (!ItemStack.isSameItemSameComponents((ItemStack)foundType, (ItemStack)stackInSlot)) {
                return ItemStack.EMPTY;
            }
            foundItems.add(stackInSlot);
        }
        if (binStack.isEmpty() || foundType.isEmpty()) {
            return ItemStack.EMPTY;
        }
        binStack = binStack.copy();
        ExtraComponentBackedBinInventorySlot slot = ExtraBinInsertRecipe.convertToSlot(binStack);
        boolean hasInserted = false;
        for (ItemStack stack : foundItems) {
            ItemStack toInsert = stack.copyWithCount(1);
            ItemStack remainder = slot.insertItem(toInsert, Action.EXECUTE, AutomationType.MANUAL);
            if (remainder.isEmpty()) {
                hasInserted = true;
                continue;
            }
            if (hasInserted) {
                return binStack;
            }
            return ItemStack.EMPTY;
        }
        binStack.set((Supplier)MekanismDataComponents.FROM_RECIPE, (Object)true);
        return binStack;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInput inv) {
        int slots = inv.size();
        NonNullList remainingItems = NonNullList.withSize((int)slots, (Object)ItemStack.EMPTY);
        ItemStack binStack = ItemStack.EMPTY;
        ItemStack foundType = ItemStack.EMPTY;
        Int2ObjectArrayMap foundSlots = new Int2ObjectArrayMap(slots);
        for (int i = 0; i < slots; ++i) {
            ItemStack stackInSlot = inv.getItem(i);
            if (stackInSlot.isEmpty()) continue;
            if (stackInSlot.getItem() instanceof ExtraItemBlockBin) {
                if (!binStack.isEmpty()) {
                    return remainingItems;
                }
                binStack = stackInSlot;
                continue;
            }
            if (foundType.isEmpty()) {
                foundType = stackInSlot;
            } else if (!ItemStack.isSameItemSameComponents((ItemStack)foundType, (ItemStack)stackInSlot)) {
                return remainingItems;
            }
            foundSlots.put(i, (Object)stackInSlot);
        }
        if (binStack.isEmpty() || foundType.isEmpty()) {
            return remainingItems;
        }
        binStack = binStack.copy();
        ExtraComponentBackedBinInventorySlot slot = ExtraBinInsertRecipe.convertToSlot(binStack);
        ObjectIterator iterator = Int2ObjectMaps.fastIterator((Int2ObjectMap)foundSlots);
        while (iterator.hasNext()) {
            Int2ObjectMap.Entry entry = (Int2ObjectMap.Entry)iterator.next();
            ItemStack slotItem = (ItemStack)entry.getValue();
            ItemStack remaining = slot.insertItem(slotItem.copyWithCount(1), Action.EXECUTE, AutomationType.MANUAL);
            if (remaining.isEmpty()) continue;
            remainingItems.set(entry.getIntKey(), (Object)remaining);
        }
        return remainingItems;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= 2;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ExtraRecipeSerializersInternal.BIN_INSERT.get();
    }

    public static void onCrafting(PlayerEvent.ItemCraftedEvent event) {
        ExtraComponentBackedBinInventorySlot slot;
        ItemStack storedStack;
        Boolean fromRecipe;
        ItemStack result = event.getCrafting();
        if (!result.isEmpty() && result.getItem() instanceof ExtraItemBlockBin && (fromRecipe = (Boolean)result.remove((Supplier)MekanismDataComponents.FROM_RECIPE)) != null && fromRecipe.booleanValue() && !(storedStack = (slot = ExtraBinInsertRecipe.convertToSlot(result)).getStack()).isEmpty()) {
            Container craftingMatrix = event.getInventory();
            int slots = craftingMatrix.getContainerSize();
            for (int i = 0; i < slots; ++i) {
                ItemStack stack = craftingMatrix.getItem(i);
                if (stack.getCount() <= 1 || !ItemStack.isSameItemSameComponents((ItemStack)storedStack, (ItemStack)stack)) continue;
                ItemStack toInsert = stack.copyWithCount(stack.getCount() - 1);
                ItemStack remaining = slot.insertItem(toInsert, Action.EXECUTE, AutomationType.MANUAL);
                if (remaining.isEmpty()) {
                    craftingMatrix.setItem(i, stack.copyWithCount(1));
                    continue;
                }
                if (remaining.getCount() >= toInsert.getCount()) continue;
                craftingMatrix.setItem(i, stack.copyWithCount(remaining.getCount() + 1));
            }
        }
    }
}

