/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekextras.common.registries;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.jerry.mekextras.api.tier.IAdvancedTier;
import com.jerry.mekextras.common.attachments.containers.chemical.ExtraComponentBackedChemicalTankTank;
import com.jerry.mekextras.common.attachments.containers.fluid.ExtraComponentBackedFluidTankFluidTank;
import com.jerry.mekextras.common.attachments.containers.item.ExtraComponentBackedBinInventorySlot;
import com.jerry.mekextras.common.block.BlockLargeCapRadioactiveWasteBarrel;
import com.jerry.mekextras.common.block.ExtraBlockEnergyCube;
import com.jerry.mekextras.common.block.attribute.ExtraAttributeTier;
import com.jerry.mekextras.common.block.basic.ExtraBlockBin;
import com.jerry.mekextras.common.block.basic.ExtraBlockFluidTank;
import com.jerry.mekextras.common.block.basic.ExtraBlockResource;
import com.jerry.mekextras.common.block.prefab.BlockExtraFactoryMachine;
import com.jerry.mekextras.common.content.blocktype.ExtraFactory;
import com.jerry.mekextras.common.item.block.ExtraItemBlockBin;
import com.jerry.mekextras.common.item.block.ExtraItemBlockChemicalTank;
import com.jerry.mekextras.common.item.block.ExtraItemBlockEnergyCube;
import com.jerry.mekextras.common.item.block.ExtraItemBlockInductionCell;
import com.jerry.mekextras.common.item.block.ExtraItemBlockInductionProvider;
import com.jerry.mekextras.common.item.block.ItemBlockLargeCapRadioactiveWasteBarrel;
import com.jerry.mekextras.common.item.block.machine.ExtraItemBlockFluidTank;
import com.jerry.mekextras.common.item.block.machine.ItemBlockExtraFactory;
import com.jerry.mekextras.common.item.block.transmitter.ExtraItemBlockLogisticalTransporter;
import com.jerry.mekextras.common.item.block.transmitter.ExtraItemBlockMechanicalPipe;
import com.jerry.mekextras.common.item.block.transmitter.ExtraItemBlockPressurizedTube;
import com.jerry.mekextras.common.item.block.transmitter.ExtraItemBlockThermodynamicConductor;
import com.jerry.mekextras.common.item.block.transmitter.ExtraItemBlockUniversalCable;
import com.jerry.mekextras.common.registries.ExtraBlockTypes;
import com.jerry.mekextras.common.resource.ExtraBlockResourceInfo;
import com.jerry.mekextras.common.resource.ExtraResource;
import com.jerry.mekextras.common.resource.ore.ExtraOreType;
import com.jerry.mekextras.common.tier.BTier;
import com.jerry.mekextras.common.tier.CTTier;
import com.jerry.mekextras.common.tier.ECTier;
import com.jerry.mekextras.common.tier.ExtraFactoryTier;
import com.jerry.mekextras.common.tier.FTTier;
import com.jerry.mekextras.common.tier.ICTier;
import com.jerry.mekextras.common.tier.IPTier;
import com.jerry.mekextras.common.tier.RWBTier;
import com.jerry.mekextras.common.tile.ExtraTileEntityBin;
import com.jerry.mekextras.common.tile.ExtraTileEntityChemicalTank;
import com.jerry.mekextras.common.tile.ExtraTileEntityEnergyCube;
import com.jerry.mekextras.common.tile.ExtraTileEntityFluidTank;
import com.jerry.mekextras.common.tile.TileEntityLargeCapRadioactiveWasteBarrel;
import com.jerry.mekextras.common.tile.factory.TileEntityExtraFactory;
import com.jerry.mekextras.common.tile.machine.TileEntityAdvancedElectricPump;
import com.jerry.mekextras.common.tile.multiblock.ExtraTileEntityInductionCell;
import com.jerry.mekextras.common.tile.multiblock.ExtraTileEntityInductionProvider;
import com.jerry.mekextras.common.tile.multiblock.TileEntityReinforcedInductionCasing;
import com.jerry.mekextras.common.tile.multiblock.TileEntityReinforcedInductionPort;
import com.jerry.mekextras.common.tile.transmitter.ExtraTileEntityLogisticalTransporter;
import com.jerry.mekextras.common.tile.transmitter.ExtraTileEntityMechanicalPipe;
import com.jerry.mekextras.common.tile.transmitter.ExtraTileEntityPressurizedTube;
import com.jerry.mekextras.common.tile.transmitter.ExtraTileEntityThermodynamicConductor;
import com.jerry.mekextras.common.tile.transmitter.ExtraTileEntityUniversalCable;
import com.jerry.mekextras.common.util.ExtraEnumUtils;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import mekanism.common.attachments.containers.ContainerType;
import mekanism.common.attachments.containers.chemical.ChemicalTanksBuilder;
import mekanism.common.attachments.containers.fluid.FluidTanksBuilder;
import mekanism.common.attachments.containers.item.ItemSlotsBuilder;
import mekanism.common.block.BlockOre;
import mekanism.common.block.prefab.BlockBasicMultiblock;
import mekanism.common.block.prefab.BlockTile;
import mekanism.common.block.transmitter.BlockLargeTransmitter;
import mekanism.common.block.transmitter.BlockSmallTransmitter;
import mekanism.common.config.IMekanismConfig;
import mekanism.common.content.blocktype.BlockTypeTile;
import mekanism.common.content.blocktype.FactoryType;
import mekanism.common.content.blocktype.Machine;
import mekanism.common.item.block.ItemBlockMekanism;
import mekanism.common.item.block.ItemBlockTooltip;
import mekanism.common.recipe.IMekanismRecipeTypeProvider;
import mekanism.common.recipe.MekanismRecipeType;
import mekanism.common.recipe.lookup.cache.DoubleInputRecipeCache;
import mekanism.common.recipe.lookup.cache.InputRecipeCache;
import mekanism.common.registration.impl.BlockDeferredRegister;
import mekanism.common.registration.impl.BlockRegistryObject;
import mekanism.common.resource.BlockResourceInfo;
import mekanism.common.resource.IResource;
import mekanism.common.resource.ore.OreBlockType;
import mekanism.common.resource.ore.OreType;
import mekanism.common.util.EnumUtils;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.neoforged.bus.api.IEventBus;
import org.jetbrains.annotations.NotNull;

public class ExtraBlocks {
    public static final BlockDeferredRegister EXTRA_BLOCKS = new BlockDeferredRegister("mekanism_extras");
    public static final Map<IResource, BlockRegistryObject<?, ?>> PROCESSED_RESOURCE_BLOCKS = new LinkedHashMap();
    public static final Map<OreType, OreBlockType> ORES = new LinkedHashMap<OreType, OreBlockType>();
    private static final Table<ExtraFactoryTier, FactoryType, BlockRegistryObject<BlockExtraFactoryMachine.BlockExtraFactory<?>, ItemBlockExtraFactory>> FACTORIES = HashBasedTable.create();
    public static final BlockRegistryObject<ExtraBlockBin, ExtraItemBlockBin> ABSOLUTE_BIN;
    public static final BlockRegistryObject<ExtraBlockBin, ExtraItemBlockBin> SUPREME_BIN;
    public static final BlockRegistryObject<ExtraBlockBin, ExtraItemBlockBin> COSMIC_BIN;
    public static final BlockRegistryObject<ExtraBlockBin, ExtraItemBlockBin> INFINITE_BIN;
    public static final BlockRegistryObject<BlockBasicMultiblock<TileEntityReinforcedInductionCasing>, ItemBlockTooltip<BlockBasicMultiblock<TileEntityReinforcedInductionCasing>>> REINFORCED_INDUCTION_CASING;
    public static final BlockRegistryObject<BlockBasicMultiblock<TileEntityReinforcedInductionPort>, ItemBlockTooltip<BlockBasicMultiblock<TileEntityReinforcedInductionPort>>> REINFORCED_INDUCTION_PORT;
    public static final BlockRegistryObject<BlockTile<ExtraTileEntityInductionCell, BlockTypeTile<ExtraTileEntityInductionCell>>, ExtraItemBlockInductionCell> ABSOLUTE_INDUCTION_CELL;
    public static final BlockRegistryObject<BlockTile<ExtraTileEntityInductionCell, BlockTypeTile<ExtraTileEntityInductionCell>>, ExtraItemBlockInductionCell> SUPREME_INDUCTION_CELL;
    public static final BlockRegistryObject<BlockTile<ExtraTileEntityInductionCell, BlockTypeTile<ExtraTileEntityInductionCell>>, ExtraItemBlockInductionCell> COSMIC_INDUCTION_CELL;
    public static final BlockRegistryObject<BlockTile<ExtraTileEntityInductionCell, BlockTypeTile<ExtraTileEntityInductionCell>>, ExtraItemBlockInductionCell> INFINITE_INDUCTION_CELL;
    public static final BlockRegistryObject<BlockTile<ExtraTileEntityInductionProvider, BlockTypeTile<ExtraTileEntityInductionProvider>>, ExtraItemBlockInductionProvider> ABSOLUTE_INDUCTION_PROVIDER;
    public static final BlockRegistryObject<BlockTile<ExtraTileEntityInductionProvider, BlockTypeTile<ExtraTileEntityInductionProvider>>, ExtraItemBlockInductionProvider> SUPREME_INDUCTION_PROVIDER;
    public static final BlockRegistryObject<BlockTile<ExtraTileEntityInductionProvider, BlockTypeTile<ExtraTileEntityInductionProvider>>, ExtraItemBlockInductionProvider> COSMIC_INDUCTION_PROVIDER;
    public static final BlockRegistryObject<BlockTile<ExtraTileEntityInductionProvider, BlockTypeTile<ExtraTileEntityInductionProvider>>, ExtraItemBlockInductionProvider> INFINITE_INDUCTION_PROVIDER;
    public static final BlockRegistryObject<ExtraBlockEnergyCube, ExtraItemBlockEnergyCube> ABSOLUTE_ENERGY_CUBE;
    public static final BlockRegistryObject<ExtraBlockEnergyCube, ExtraItemBlockEnergyCube> SUPREME_ENERGY_CUBE;
    public static final BlockRegistryObject<ExtraBlockEnergyCube, ExtraItemBlockEnergyCube> COSMIC_ENERGY_CUBE;
    public static final BlockRegistryObject<ExtraBlockEnergyCube, ExtraItemBlockEnergyCube> INFINITE_ENERGY_CUBE;
    public static final BlockRegistryObject<ExtraBlockFluidTank, ExtraItemBlockFluidTank> ABSOLUTE_FLUID_TANK;
    public static final BlockRegistryObject<ExtraBlockFluidTank, ExtraItemBlockFluidTank> SUPREME_FLUID_TANK;
    public static final BlockRegistryObject<ExtraBlockFluidTank, ExtraItemBlockFluidTank> COSMIC_FLUID_TANK;
    public static final BlockRegistryObject<ExtraBlockFluidTank, ExtraItemBlockFluidTank> INFINITE_FLUID_TANK;
    public static final BlockRegistryObject<BlockSmallTransmitter<ExtraTileEntityUniversalCable>, ExtraItemBlockUniversalCable> ABSOLUTE_UNIVERSAL_CABLE;
    public static final BlockRegistryObject<BlockSmallTransmitter<ExtraTileEntityUniversalCable>, ExtraItemBlockUniversalCable> SUPREME_UNIVERSAL_CABLE;
    public static final BlockRegistryObject<BlockSmallTransmitter<ExtraTileEntityUniversalCable>, ExtraItemBlockUniversalCable> COSMIC_UNIVERSAL_CABLE;
    public static final BlockRegistryObject<BlockSmallTransmitter<ExtraTileEntityUniversalCable>, ExtraItemBlockUniversalCable> INFINITE_UNIVERSAL_CABLE;
    public static final BlockRegistryObject<BlockLargeTransmitter<ExtraTileEntityMechanicalPipe>, ExtraItemBlockMechanicalPipe> ABSOLUTE_MECHANICAL_PIPE;
    public static final BlockRegistryObject<BlockLargeTransmitter<ExtraTileEntityMechanicalPipe>, ExtraItemBlockMechanicalPipe> SUPREME_MECHANICAL_PIPE;
    public static final BlockRegistryObject<BlockLargeTransmitter<ExtraTileEntityMechanicalPipe>, ExtraItemBlockMechanicalPipe> COSMIC_MECHANICAL_PIPE;
    public static final BlockRegistryObject<BlockLargeTransmitter<ExtraTileEntityMechanicalPipe>, ExtraItemBlockMechanicalPipe> INFINITE_MECHANICAL_PIPE;
    public static final BlockRegistryObject<BlockSmallTransmitter<ExtraTileEntityPressurizedTube>, ExtraItemBlockPressurizedTube> ABSOLUTE_PRESSURIZED_TUBE;
    public static final BlockRegistryObject<BlockSmallTransmitter<ExtraTileEntityPressurizedTube>, ExtraItemBlockPressurizedTube> SUPREME_PRESSURIZED_TUBE;
    public static final BlockRegistryObject<BlockSmallTransmitter<ExtraTileEntityPressurizedTube>, ExtraItemBlockPressurizedTube> COSMIC_PRESSURIZED_TUBE;
    public static final BlockRegistryObject<BlockSmallTransmitter<ExtraTileEntityPressurizedTube>, ExtraItemBlockPressurizedTube> INFINITE_PRESSURIZED_TUBE;
    public static final BlockRegistryObject<BlockLargeTransmitter<ExtraTileEntityLogisticalTransporter>, ExtraItemBlockLogisticalTransporter> ABSOLUTE_LOGISTICAL_TRANSPORTER;
    public static final BlockRegistryObject<BlockLargeTransmitter<ExtraTileEntityLogisticalTransporter>, ExtraItemBlockLogisticalTransporter> SUPREME_LOGISTICAL_TRANSPORTER;
    public static final BlockRegistryObject<BlockLargeTransmitter<ExtraTileEntityLogisticalTransporter>, ExtraItemBlockLogisticalTransporter> COSMIC_LOGISTICAL_TRANSPORTER;
    public static final BlockRegistryObject<BlockLargeTransmitter<ExtraTileEntityLogisticalTransporter>, ExtraItemBlockLogisticalTransporter> INFINITE_LOGISTICAL_TRANSPORTER;
    public static final BlockRegistryObject<BlockSmallTransmitter<ExtraTileEntityThermodynamicConductor>, ExtraItemBlockThermodynamicConductor> ABSOLUTE_THERMODYNAMIC_CONDUCTOR;
    public static final BlockRegistryObject<BlockSmallTransmitter<ExtraTileEntityThermodynamicConductor>, ExtraItemBlockThermodynamicConductor> SUPREME_THERMODYNAMIC_CONDUCTOR;
    public static final BlockRegistryObject<BlockSmallTransmitter<ExtraTileEntityThermodynamicConductor>, ExtraItemBlockThermodynamicConductor> COSMIC_THERMODYNAMIC_CONDUCTOR;
    public static final BlockRegistryObject<BlockSmallTransmitter<ExtraTileEntityThermodynamicConductor>, ExtraItemBlockThermodynamicConductor> INFINITE_THERMODYNAMIC_CONDUCTOR;
    public static final BlockRegistryObject<BlockTile.BlockTileModel<ExtraTileEntityChemicalTank, Machine<ExtraTileEntityChemicalTank>>, ExtraItemBlockChemicalTank> ABSOLUTE_CHEMICAL_TANK;
    public static final BlockRegistryObject<BlockTile.BlockTileModel<ExtraTileEntityChemicalTank, Machine<ExtraTileEntityChemicalTank>>, ExtraItemBlockChemicalTank> SUPREME_CHEMICAL_TANK;
    public static final BlockRegistryObject<BlockTile.BlockTileModel<ExtraTileEntityChemicalTank, Machine<ExtraTileEntityChemicalTank>>, ExtraItemBlockChemicalTank> COSMIC_CHEMICAL_TANK;
    public static final BlockRegistryObject<BlockTile.BlockTileModel<ExtraTileEntityChemicalTank, Machine<ExtraTileEntityChemicalTank>>, ExtraItemBlockChemicalTank> INFINITE_CHEMICAL_TANK;
    public static final BlockRegistryObject<BlockLargeCapRadioactiveWasteBarrel, ItemBlockLargeCapRadioactiveWasteBarrel> ABSOLUTE_RADIOACTIVE_WASTE_BARREL;
    public static final BlockRegistryObject<BlockLargeCapRadioactiveWasteBarrel, ItemBlockLargeCapRadioactiveWasteBarrel> SUPREME_RADIOACTIVE_WASTE_BARREL;
    public static final BlockRegistryObject<BlockLargeCapRadioactiveWasteBarrel, ItemBlockLargeCapRadioactiveWasteBarrel> COSMIC_RADIOACTIVE_WASTE_BARREL;
    public static final BlockRegistryObject<BlockLargeCapRadioactiveWasteBarrel, ItemBlockLargeCapRadioactiveWasteBarrel> INFINITE_RADIOACTIVE_WASTE_BARREL;
    public static final BlockRegistryObject<BlockTile.BlockTileModel<TileEntityAdvancedElectricPump, Machine<TileEntityAdvancedElectricPump>>, ItemBlockTooltip<BlockTile.BlockTileModel<TileEntityAdvancedElectricPump, Machine<TileEntityAdvancedElectricPump>>>> ADVANCE_ELECTRIC_PUMP;

    private static <BLOCK extends Block, ITEM extends BlockItem> BlockRegistryObject<BLOCK, ITEM> registerTieredBlock(IAdvancedTier tier, String suffix, Function<MapColor, ? extends BLOCK> blockSupplier, BiFunction<BLOCK, Item.Properties, ITEM> itemCreator) {
        return ExtraBlocks.registerTieredBlock(tier, suffix, () -> (Block)blockSupplier.apply(tier.getAdvanceTier().getMapColor()), itemCreator);
    }

    private static <BLOCK extends Block, ITEM extends BlockItem> BlockRegistryObject<BLOCK, ITEM> registerTieredBlock(IAdvancedTier tier, String suffix, Supplier<? extends BLOCK> blockSupplier, BiFunction<BLOCK, Item.Properties, ITEM> itemCreator) {
        return EXTRA_BLOCKS.register(tier.getAdvanceTier().getLowerName() + suffix, blockSupplier, itemCreator);
    }

    private static <BLOCK extends Block, ITEM extends BlockItem> BlockRegistryObject<BLOCK, ITEM> registerTieredBlock(String registerName, Supplier<? extends BLOCK> blockSupplier, BiFunction<BLOCK, Item.Properties, ITEM> itemCreator) {
        return EXTRA_BLOCKS.register(registerName, blockSupplier, itemCreator);
    }

    private static <BLOCK extends Block> BlockRegistryObject<BLOCK, ItemBlockTooltip<BLOCK>> registerBlock(String name, Supplier<? extends BLOCK> blockSupplier) {
        return EXTRA_BLOCKS.register(name, blockSupplier, (x$0, x$1) -> new ItemBlockTooltip((Block)x$0, x$1));
    }

    private static BlockRegistryObject<ExtraBlockResource, ItemBlockMekanism<ExtraBlockResource>> registerResourceBlock(ExtraBlockResourceInfo resource) {
        return EXTRA_BLOCKS.register("block_" + resource.getRegistrySuffix(), () -> new ExtraBlockResource(resource), (block, properties) -> {
            if (!block.getResourceInfo().burnsInFire()) {
                properties = properties.fireResistant();
            }
            return new ItemBlockMekanism((Block)block, properties);
        });
    }

    public static OreBlockType registerOre(OreType ore) {
        String name = ore.getResource().getRegistrySuffix() + "_ore";
        BlockRegistryObject<BlockOre, ItemBlockTooltip<BlockOre>> stoneOre = ExtraBlocks.registerBlock(name, () -> new BlockOre(ore));
        BlockRegistryObject endOre = EXTRA_BLOCKS.register("end_" + name, () -> new BlockOre(ore, BlockBehaviour.Properties.ofLegacyCopy((BlockBehaviour)((BlockBehaviour)stoneOre.value())).mapColor(MapColor.SAND).strength(3.0f, 9.0f).sound(SoundType.STONE)), ItemBlockTooltip::new);
        return new OreBlockType(stoneOre, endOre);
    }

    private static BlockRegistryObject<ExtraBlockBin, ExtraItemBlockBin> registerBin(BlockTypeTile<ExtraTileEntityBin> type) {
        BTier tier = (BTier)Objects.requireNonNull((ExtraAttributeTier)type.get(ExtraAttributeTier.class)).tier();
        return ExtraBlocks.registerTieredBlock((IAdvancedTier)tier, "_bin", (MapColor color) -> new ExtraBlockBin(type, properties -> properties.mapColor(color)), ExtraItemBlockBin::new).forItemHolder(holder -> holder.addAttachmentOnlyContainers(ContainerType.ITEM, () -> ItemSlotsBuilder.builder().addSlot(ExtraComponentBackedBinInventorySlot::create).build()));
    }

    private static BlockRegistryObject<BlockTile<ExtraTileEntityInductionCell, BlockTypeTile<ExtraTileEntityInductionCell>>, ExtraItemBlockInductionCell> registerInductionCell(BlockTypeTile<ExtraTileEntityInductionCell> type) {
        ICTier tier = (ICTier)Objects.requireNonNull((ExtraAttributeTier)type.get(ExtraAttributeTier.class)).tier();
        return ExtraBlocks.registerTieredBlock((IAdvancedTier)tier, "_induction_cell", (MapColor color) -> new BlockTile(type, properties -> properties.mapColor(color)), ExtraItemBlockInductionCell::new);
    }

    private static BlockRegistryObject<BlockTile<ExtraTileEntityInductionProvider, BlockTypeTile<ExtraTileEntityInductionProvider>>, ExtraItemBlockInductionProvider> registerInductionProvider(BlockTypeTile<ExtraTileEntityInductionProvider> type) {
        IPTier tier = (IPTier)Objects.requireNonNull((ExtraAttributeTier)type.get(ExtraAttributeTier.class)).tier();
        return ExtraBlocks.registerTieredBlock((IAdvancedTier)tier, "_induction_provider", (MapColor color) -> new BlockTile(type, properties -> properties.mapColor(color)), ExtraItemBlockInductionProvider::new);
    }

    private static BlockRegistryObject<ExtraBlockEnergyCube, ExtraItemBlockEnergyCube> registerEnergyCube(Machine<ExtraTileEntityEnergyCube> type) {
        ECTier tier = (ECTier)Objects.requireNonNull((ExtraAttributeTier)type.get(ExtraAttributeTier.class)).tier();
        return ExtraBlocks.registerTieredBlock((IAdvancedTier)tier, "_energy_cube", () -> new ExtraBlockEnergyCube(type), ExtraItemBlockEnergyCube::new).forItemHolder(holder -> holder.addAttachmentOnlyContainers(ContainerType.ITEM, () -> ItemSlotsBuilder.builder().addEnergy().addDrainEnergy().build()));
    }

    private static BlockRegistryObject<ExtraBlockFluidTank, ExtraItemBlockFluidTank> registerFluidTank(Machine<ExtraTileEntityFluidTank> type) {
        FTTier tier = (FTTier)Objects.requireNonNull((ExtraAttributeTier)type.get(ExtraAttributeTier.class)).tier();
        return ExtraBlocks.registerTieredBlock((IAdvancedTier)tier, "_fluid_tank", () -> new ExtraBlockFluidTank(type), ExtraItemBlockFluidTank::new).forItemHolder(holder -> holder.addAttachedContainerCapabilities(ContainerType.FLUID, () -> FluidTanksBuilder.builder().addTank(ExtraComponentBackedFluidTankFluidTank::create).build(), new IMekanismConfig[0]).addAttachmentOnlyContainers(ContainerType.ITEM, () -> ItemSlotsBuilder.builder().addFluidInputSlot(0).addOutput().build()));
    }

    private static BlockRegistryObject<BlockSmallTransmitter<ExtraTileEntityUniversalCable>, ExtraItemBlockUniversalCable> registerUniversalCable(String nameTier, BlockTypeTile<ExtraTileEntityUniversalCable> type) {
        return ExtraBlocks.registerTieredBlock(nameTier + "_universal_cable", () -> new BlockSmallTransmitter(type), ExtraItemBlockUniversalCable::new);
    }

    private static BlockRegistryObject<BlockLargeTransmitter<ExtraTileEntityMechanicalPipe>, ExtraItemBlockMechanicalPipe> registerMechanicalPipe(String nameTier, BlockTypeTile<ExtraTileEntityMechanicalPipe> type) {
        return ExtraBlocks.registerTieredBlock(nameTier + "_mechanical_pipe", () -> new BlockLargeTransmitter(type), ExtraItemBlockMechanicalPipe::new);
    }

    private static BlockRegistryObject<BlockSmallTransmitter<ExtraTileEntityPressurizedTube>, ExtraItemBlockPressurizedTube> registerPressurizedTube(String nameTier, BlockTypeTile<ExtraTileEntityPressurizedTube> type) {
        return ExtraBlocks.registerTieredBlock(nameTier + "_pressurized_tube", () -> new BlockSmallTransmitter(type), ExtraItemBlockPressurizedTube::new);
    }

    private static BlockRegistryObject<BlockLargeTransmitter<ExtraTileEntityLogisticalTransporter>, ExtraItemBlockLogisticalTransporter> registerLogisticalTransporter(String nameTier, BlockTypeTile<ExtraTileEntityLogisticalTransporter> type) {
        return ExtraBlocks.registerTieredBlock(nameTier + "_logistical_transporter", () -> new BlockLargeTransmitter(type), ExtraItemBlockLogisticalTransporter::new);
    }

    private static BlockRegistryObject<BlockSmallTransmitter<ExtraTileEntityThermodynamicConductor>, ExtraItemBlockThermodynamicConductor> registerThermodynamicConductor(String nameTier, BlockTypeTile<ExtraTileEntityThermodynamicConductor> type) {
        return ExtraBlocks.registerTieredBlock(nameTier + "_thermodynamic_conductor", () -> new BlockSmallTransmitter(type), ExtraItemBlockThermodynamicConductor::new);
    }

    private static BlockRegistryObject<BlockTile.BlockTileModel<ExtraTileEntityChemicalTank, Machine<ExtraTileEntityChemicalTank>>, ExtraItemBlockChemicalTank> registerChemicalTank(Machine<ExtraTileEntityChemicalTank> type) {
        CTTier tier = (CTTier)Objects.requireNonNull((ExtraAttributeTier)type.get(ExtraAttributeTier.class)).tier();
        return ExtraBlocks.registerTieredBlock((IAdvancedTier)tier, "_chemical_tank", (MapColor color) -> new BlockTile.BlockTileModel((BlockTypeTile)type, properties -> properties.mapColor(color)), ExtraItemBlockChemicalTank::new).forItemHolder(holder -> holder.addAttachedContainerCapabilities(ContainerType.CHEMICAL, () -> ChemicalTanksBuilder.builder().addTank(ExtraComponentBackedChemicalTankTank::create).build(), new IMekanismConfig[0]).addAttachmentOnlyContainers(ContainerType.ITEM, () -> ItemSlotsBuilder.builder().addChemicalDrainSlot(0).addChemicalFillSlot(0).build()));
    }

    private static BlockRegistryObject<BlockLargeCapRadioactiveWasteBarrel, ItemBlockLargeCapRadioactiveWasteBarrel> registryWasteBarrel(BlockTypeTile<TileEntityLargeCapRadioactiveWasteBarrel> type) {
        RWBTier tier = (RWBTier)Objects.requireNonNull((ExtraAttributeTier)type.get(ExtraAttributeTier.class)).tier();
        return ExtraBlocks.registerTieredBlock((IAdvancedTier)tier, "_radioactive_waste_barrel", () -> new BlockLargeCapRadioactiveWasteBarrel(type), ItemBlockLargeCapRadioactiveWasteBarrel::new);
    }

    private static <TILE extends TileEntityExtraFactory<?>> BlockRegistryObject<BlockExtraFactoryMachine.BlockExtraFactory<?>, ItemBlockExtraFactory> registerFactory(ExtraFactory<TILE> type) {
        ExtraFactoryTier tier = (ExtraFactoryTier)((ExtraAttributeTier)type.get(ExtraAttributeTier.class)).tier();
        BlockRegistryObject<BlockExtraFactoryMachine.BlockExtraFactory, ItemBlockExtraFactory> factory = ExtraBlocks.registerTieredBlock((IAdvancedTier)tier, "_" + type.getFactoryType().getRegistryNameComponent() + "_factory", () -> new BlockExtraFactoryMachine.BlockExtraFactory(type), ItemBlockExtraFactory::new);
        factory.forItemHolder(holder -> {
            int processes = tier.processes;
            Predicate<ItemStack> recipeInputPredicate = switch (type.getFactoryType()) {
                default -> throw new MatchException(null, null);
                case FactoryType.SMELTING -> s -> ((InputRecipeCache.SingleItem)MekanismRecipeType.SMELTING.getInputCache()).containsInput(null, s);
                case FactoryType.ENRICHING -> s -> ((InputRecipeCache.SingleItem)MekanismRecipeType.ENRICHING.getInputCache()).containsInput(null, s);
                case FactoryType.CRUSHING -> s -> ((InputRecipeCache.SingleItem)MekanismRecipeType.CRUSHING.getInputCache()).containsInput(null, s);
                case FactoryType.COMPRESSING -> s -> ((InputRecipeCache.ItemChemical)MekanismRecipeType.COMPRESSING.getInputCache()).containsInputA(null, s);
                case FactoryType.COMBINING -> s -> ((InputRecipeCache.DoubleItem)MekanismRecipeType.COMBINING.getInputCache()).containsInputA(null, s);
                case FactoryType.PURIFYING -> s -> ((InputRecipeCache.ItemChemical)MekanismRecipeType.PURIFYING.getInputCache()).containsInputA(null, s);
                case FactoryType.INJECTING -> s -> ((InputRecipeCache.ItemChemical)MekanismRecipeType.INJECTING.getInputCache()).containsInputA(null, s);
                case FactoryType.INFUSING -> s -> ((InputRecipeCache.ItemChemical)MekanismRecipeType.METALLURGIC_INFUSING.getInputCache()).containsInputA(null, s);
                case FactoryType.SAWING -> s -> ((InputRecipeCache.SingleItem)MekanismRecipeType.SAWING.getInputCache()).containsInput(null, s);
            };
            switch (type.getFactoryType()) {
                case SMELTING: 
                case ENRICHING: 
                case CRUSHING: {
                    holder.addAttachmentOnlyContainers(ContainerType.ITEM, () -> ItemSlotsBuilder.builder().addBasicFactorySlots(processes, recipeInputPredicate).addEnergy().build());
                    break;
                }
                case COMPRESSING: 
                case PURIFYING: 
                case INJECTING: {
                    holder.addAttachmentOnlyContainers(ContainerType.CHEMICAL, () -> {
                        ChemicalTanksBuilder chemicalTanksBuilder = ChemicalTanksBuilder.builder();
                        long l = 210L * (long)processes * (long)processes;
                        return chemicalTanksBuilder.addBasic(l, (IMekanismRecipeTypeProvider)(switch (type.getFactoryType()) {
                            case FactoryType.COMPRESSING -> MekanismRecipeType.COMPRESSING;
                            case FactoryType.INJECTING -> MekanismRecipeType.INJECTING;
                            case FactoryType.PURIFYING -> MekanismRecipeType.PURIFYING;
                            default -> throw new IllegalStateException("Factory type doesn't have a known gas recipe");
                        }), DoubleInputRecipeCache::containsInputB).build();
                    }).addAttachmentOnlyContainers(ContainerType.ITEM, () -> ItemSlotsBuilder.builder().addBasicFactorySlots(processes, recipeInputPredicate).addChemicalFillOrConvertSlot(0).addEnergy().build());
                    break;
                }
                case COMBINING: {
                    holder.addAttachmentOnlyContainers(ContainerType.ITEM, () -> ItemSlotsBuilder.builder().addBasicFactorySlots(processes, recipeInputPredicate).addInput((IMekanismRecipeTypeProvider)MekanismRecipeType.COMBINING, DoubleInputRecipeCache::containsInputB).addEnergy().build());
                    break;
                }
                case INFUSING: {
                    holder.addAttachmentOnlyContainers(ContainerType.CHEMICAL, () -> ChemicalTanksBuilder.builder().addBasic(1000L * (long)processes * (long)processes, (IMekanismRecipeTypeProvider)MekanismRecipeType.METALLURGIC_INFUSING, DoubleInputRecipeCache::containsInputB).build()).addAttachmentOnlyContainers(ContainerType.ITEM, () -> ItemSlotsBuilder.builder().addBasicFactorySlots(processes, recipeInputPredicate).addInfusionFillOrConvertSlot(0).addEnergy().build());
                    break;
                }
                case SAWING: {
                    holder.addAttachmentOnlyContainers(ContainerType.ITEM, () -> ItemSlotsBuilder.builder().addBasicFactorySlots(processes, recipeInputPredicate, true).addEnergy().build());
                }
            }
        });
        return factory;
    }

    public static BlockRegistryObject<BlockExtraFactoryMachine.BlockExtraFactory<?>, ItemBlockExtraFactory> getExtraFactory(@NotNull ExtraFactoryTier tier, @NotNull FactoryType type) {
        return (BlockRegistryObject)FACTORIES.get((Object)tier, (Object)type);
    }

    public static BlockRegistryObject<BlockExtraFactoryMachine.BlockExtraFactory<?>, ItemBlockExtraFactory>[] getExtraFactoryBlocks() {
        return FACTORIES.values().toArray(new BlockRegistryObject[0]);
    }

    public static void register(IEventBus eventBus) {
        EXTRA_BLOCKS.register(eventBus);
    }

    static {
        for (ExtraFactoryTier extraFactoryTier : ExtraEnumUtils.ADVANCED_FACTORY_TIERS) {
            for (FactoryType type : EnumUtils.FACTORY_TYPES) {
                FACTORIES.put((Object)extraFactoryTier, (Object)type, ExtraBlocks.registerFactory(ExtraBlockTypes.getAdvancedFactory(extraFactoryTier, type)));
            }
        }
        for (Enum enum_ : ExtraEnumUtils.EXTRA_RESOURCES) {
            ExtraBlockResourceInfo rawResource;
            if (((ExtraResource)enum_).getResourceBlockInfo() != null) {
                PROCESSED_RESOURCE_BLOCKS.put((IResource)enum_, ExtraBlocks.registerResourceBlock(((ExtraResource)enum_).getResourceBlockInfo()));
            }
            if ((rawResource = ((ExtraResource)enum_).getRawResourceBlockInfo()) == null) continue;
            PROCESSED_RESOURCE_BLOCKS.put(rawResource, ExtraBlocks.registerResourceBlock(rawResource));
        }
        for (Enum enum_ : EnumUtils.ORE_TYPES) {
            if (enum_ != ExtraOreType.NAQUADAH) continue;
            ORES.put((OreType)enum_, ExtraBlocks.registerOre((OreType)enum_));
        }
        ABSOLUTE_BIN = ExtraBlocks.registerBin(ExtraBlockTypes.ABSOLUTE_BIN);
        SUPREME_BIN = ExtraBlocks.registerBin(ExtraBlockTypes.SUPREME_BIN);
        COSMIC_BIN = ExtraBlocks.registerBin(ExtraBlockTypes.COSMIC_BIN);
        INFINITE_BIN = ExtraBlocks.registerBin(ExtraBlockTypes.INFINITE_BIN);
        REINFORCED_INDUCTION_CASING = ExtraBlocks.registerBlock("reinforced_induction_casing", () -> new BlockBasicMultiblock(ExtraBlockTypes.REINFORCED_INDUCTION_CASING, properties -> properties.mapColor(MapColor.COLOR_LIGHT_GRAY)));
        REINFORCED_INDUCTION_PORT = ExtraBlocks.registerBlock("reinforced_induction_port", () -> new BlockBasicMultiblock(ExtraBlockTypes.REINFORCED_INDUCTION_PORT, properties -> properties.mapColor(MapColor.COLOR_LIGHT_GRAY)));
        ABSOLUTE_INDUCTION_CELL = ExtraBlocks.registerInductionCell(ExtraBlockTypes.ABSOLUTE_INDUCTION_CELL);
        SUPREME_INDUCTION_CELL = ExtraBlocks.registerInductionCell(ExtraBlockTypes.SUPREME_INDUCTION_CELL);
        COSMIC_INDUCTION_CELL = ExtraBlocks.registerInductionCell(ExtraBlockTypes.COSMIC_INDUCTION_CELL);
        INFINITE_INDUCTION_CELL = ExtraBlocks.registerInductionCell(ExtraBlockTypes.INFINITE_INDUCTION_CELL);
        ABSOLUTE_INDUCTION_PROVIDER = ExtraBlocks.registerInductionProvider(ExtraBlockTypes.ABSOLUTE_INDUCTION_PROVIDER);
        SUPREME_INDUCTION_PROVIDER = ExtraBlocks.registerInductionProvider(ExtraBlockTypes.SUPREME_INDUCTION_PROVIDER);
        COSMIC_INDUCTION_PROVIDER = ExtraBlocks.registerInductionProvider(ExtraBlockTypes.COSMIC_INDUCTION_PROVIDER);
        INFINITE_INDUCTION_PROVIDER = ExtraBlocks.registerInductionProvider(ExtraBlockTypes.INFINITE_INDUCTION_PROVIDER);
        ABSOLUTE_ENERGY_CUBE = ExtraBlocks.registerEnergyCube(ExtraBlockTypes.ABSOLUTE_ENERGY_CUBE);
        SUPREME_ENERGY_CUBE = ExtraBlocks.registerEnergyCube(ExtraBlockTypes.SUPREME_ENERGY_CUBE);
        COSMIC_ENERGY_CUBE = ExtraBlocks.registerEnergyCube(ExtraBlockTypes.COSMIC_ENERGY_CUBE);
        INFINITE_ENERGY_CUBE = ExtraBlocks.registerEnergyCube(ExtraBlockTypes.INFINITE_ENERGY_CUBE);
        ABSOLUTE_FLUID_TANK = ExtraBlocks.registerFluidTank(ExtraBlockTypes.ABSOLUTE_FLUID_TANK);
        SUPREME_FLUID_TANK = ExtraBlocks.registerFluidTank(ExtraBlockTypes.SUPREME_FLUID_TANK);
        COSMIC_FLUID_TANK = ExtraBlocks.registerFluidTank(ExtraBlockTypes.COSMIC_FLUID_TANK);
        INFINITE_FLUID_TANK = ExtraBlocks.registerFluidTank(ExtraBlockTypes.INFINITE_FLUID_TANK);
        ABSOLUTE_UNIVERSAL_CABLE = ExtraBlocks.registerUniversalCable("absolute", ExtraBlockTypes.ABSOLUTE_UNIVERSAL_CABLE);
        SUPREME_UNIVERSAL_CABLE = ExtraBlocks.registerUniversalCable("supreme", ExtraBlockTypes.SUPREME_UNIVERSAL_CABLE);
        COSMIC_UNIVERSAL_CABLE = ExtraBlocks.registerUniversalCable("cosmic", ExtraBlockTypes.COSMIC_UNIVERSAL_CABLE);
        INFINITE_UNIVERSAL_CABLE = ExtraBlocks.registerUniversalCable("infinite", ExtraBlockTypes.INFINITE_UNIVERSAL_CABLE);
        ABSOLUTE_MECHANICAL_PIPE = ExtraBlocks.registerMechanicalPipe("absolute", ExtraBlockTypes.ABSOLUTE_MECHANICAL_PIPE);
        SUPREME_MECHANICAL_PIPE = ExtraBlocks.registerMechanicalPipe("supreme", ExtraBlockTypes.SUPREME_MECHANICAL_PIPE);
        COSMIC_MECHANICAL_PIPE = ExtraBlocks.registerMechanicalPipe("cosmic", ExtraBlockTypes.COSMIC_MECHANICAL_PIPE);
        INFINITE_MECHANICAL_PIPE = ExtraBlocks.registerMechanicalPipe("infinite", ExtraBlockTypes.INFINITE_MECHANICAL_PIPE);
        ABSOLUTE_PRESSURIZED_TUBE = ExtraBlocks.registerPressurizedTube("absolute", ExtraBlockTypes.ABSOLUTE_PRESSURIZED_TUBE);
        SUPREME_PRESSURIZED_TUBE = ExtraBlocks.registerPressurizedTube("supreme", ExtraBlockTypes.SUPREME_PRESSURIZED_TUBE);
        COSMIC_PRESSURIZED_TUBE = ExtraBlocks.registerPressurizedTube("cosmic", ExtraBlockTypes.COSMIC_PRESSURIZED_TUBE);
        INFINITE_PRESSURIZED_TUBE = ExtraBlocks.registerPressurizedTube("infinite", ExtraBlockTypes.INFINITE_PRESSURIZED_TUBE);
        ABSOLUTE_LOGISTICAL_TRANSPORTER = ExtraBlocks.registerLogisticalTransporter("absolute", ExtraBlockTypes.ABSOLUTE_LOGISTICAL_TRANSPORTER);
        SUPREME_LOGISTICAL_TRANSPORTER = ExtraBlocks.registerLogisticalTransporter("supreme", ExtraBlockTypes.SUPREME_LOGISTICAL_TRANSPORTER);
        COSMIC_LOGISTICAL_TRANSPORTER = ExtraBlocks.registerLogisticalTransporter("cosmic", ExtraBlockTypes.COSMIC_LOGISTICAL_TRANSPORTER);
        INFINITE_LOGISTICAL_TRANSPORTER = ExtraBlocks.registerLogisticalTransporter("infinite", ExtraBlockTypes.INFINITE_LOGISTICAL_TRANSPORTER);
        ABSOLUTE_THERMODYNAMIC_CONDUCTOR = ExtraBlocks.registerThermodynamicConductor("absolute", ExtraBlockTypes.ABSOLUTE_THERMODYNAMIC_CONDUCTOR);
        SUPREME_THERMODYNAMIC_CONDUCTOR = ExtraBlocks.registerThermodynamicConductor("supreme", ExtraBlockTypes.SUPREME_THERMODYNAMIC_CONDUCTOR);
        COSMIC_THERMODYNAMIC_CONDUCTOR = ExtraBlocks.registerThermodynamicConductor("cosmic", ExtraBlockTypes.COSMIC_THERMODYNAMIC_CONDUCTOR);
        INFINITE_THERMODYNAMIC_CONDUCTOR = ExtraBlocks.registerThermodynamicConductor("infinite", ExtraBlockTypes.INFINITE_THERMODYNAMIC_CONDUCTOR);
        ABSOLUTE_CHEMICAL_TANK = ExtraBlocks.registerChemicalTank(ExtraBlockTypes.ABSOLUTE_CHEMICAL_TANK);
        SUPREME_CHEMICAL_TANK = ExtraBlocks.registerChemicalTank(ExtraBlockTypes.SUPREME_CHEMICAL_TANK);
        COSMIC_CHEMICAL_TANK = ExtraBlocks.registerChemicalTank(ExtraBlockTypes.COSMIC_CHEMICAL_TANK);
        INFINITE_CHEMICAL_TANK = ExtraBlocks.registerChemicalTank(ExtraBlockTypes.INFINITE_CHEMICAL_TANK);
        ABSOLUTE_RADIOACTIVE_WASTE_BARREL = ExtraBlocks.registryWasteBarrel(ExtraBlockTypes.ABSOLUTE_RADIOACTIVE_WASTE_BARREL);
        SUPREME_RADIOACTIVE_WASTE_BARREL = ExtraBlocks.registryWasteBarrel(ExtraBlockTypes.SUPREME_RADIOACTIVE_WASTE_BARREL);
        COSMIC_RADIOACTIVE_WASTE_BARREL = ExtraBlocks.registryWasteBarrel(ExtraBlockTypes.COSMIC_RADIOACTIVE_WASTE_BARREL);
        INFINITE_RADIOACTIVE_WASTE_BARREL = ExtraBlocks.registryWasteBarrel(ExtraBlockTypes.INFINITE_RADIOACTIVE_WASTE_BARREL);
        ADVANCE_ELECTRIC_PUMP = EXTRA_BLOCKS.register("advanced_electric_pump", () -> new BlockTile.BlockTileModel(ExtraBlockTypes.ADVANCE_ELECTRIC_PUMP, properties -> properties.mapColor(BlockResourceInfo.STEEL.getMapColor())), ItemBlockTooltip::new).forItemHolder(holder -> holder.addAttachmentOnlyContainers(ContainerType.FLUID, () -> FluidTanksBuilder.builder().addBasic(10000000).build()).addAttachmentOnlyContainers(ContainerType.ITEM, () -> ItemSlotsBuilder.builder().addFluidDrainSlot(0).addOutput().addEnergy().build()));
    }
}

