/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.geore.registry;

import com.shynieke.geore.block.BuddingGeoreBlock;
import com.shynieke.geore.item.GeoreSpyglassItem;
import com.shynieke.geore.registry.GeOreRegistry;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.AmethystBlock;
import net.minecraft.world.level.block.AmethystClusterBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.TintedGlassBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.neoforged.neoforge.registries.DeferredHolder;

public class GeOreBlockReg {
    protected final String name;
    protected final DeferredHolder<Block, AmethystBlock> block;
    protected final DeferredHolder<Block, BuddingGeoreBlock> budding;
    protected final DeferredHolder<Block, AmethystClusterBlock> cluster;
    protected final DeferredHolder<Block, AmethystClusterBlock> large_bud;
    protected final DeferredHolder<Block, AmethystClusterBlock> medium_bud;
    protected final DeferredHolder<Block, AmethystClusterBlock> small_bud;
    protected final DeferredHolder<Block, TintedGlassBlock> tinted_glass;
    protected final DeferredHolder<Item, Item> shard;
    protected final DeferredHolder<Item, GeoreSpyglassItem> spyglass;

    @Nonnull
    public String getName() {
        return this.name;
    }

    public DeferredHolder<Block, AmethystBlock> getBlock() {
        return this.block;
    }

    public DeferredHolder<Block, BuddingGeoreBlock> getBudding() {
        return this.budding;
    }

    public DeferredHolder<Block, AmethystClusterBlock> getCluster() {
        return this.cluster;
    }

    public DeferredHolder<Block, AmethystClusterBlock> getLargeBud() {
        return this.large_bud;
    }

    public DeferredHolder<Block, AmethystClusterBlock> getMediumBud() {
        return this.medium_bud;
    }

    public DeferredHolder<Block, AmethystClusterBlock> getSmallBud() {
        return this.small_bud;
    }

    public DeferredHolder<Item, Item> getShard() {
        return this.shard;
    }

    public DeferredHolder<Item, GeoreSpyglassItem> getSpyglass() {
        return this.spyglass;
    }

    public DeferredHolder<Block, TintedGlassBlock> getTintedGlass() {
        return this.tinted_glass;
    }

    public GeOreBlockReg(String name, MapColor color, int spyglassHex) {
        this(name, color, () -> new Item(new Item.Properties()), spyglassHex);
    }

    public GeOreBlockReg(String name, MapColor color, Supplier<Item> customShard, int spyglassHex) {
        this.name = name;
        this.block = GeOreRegistry.BLOCKS.register(name + "_block", () -> new AmethystBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.AMETHYST_BLOCK).mapColor(color).strength(1.5f).sound(SoundType.AMETHYST).requiresCorrectToolForDrops()));
        GeOreRegistry.ITEMS.register(this.getBlock().getId().getPath(), () -> new BlockItem((Block)this.getBlock().get(), new Item.Properties()));
        this.large_bud = GeOreRegistry.BLOCKS.register("large_" + name + "_bud", () -> new AmethystClusterBlock(5.0f, 3.0f, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.LARGE_AMETHYST_BUD).mapColor(color).noOcclusion().randomTicks().sound(SoundType.AMETHYST_CLUSTER).strength(1.5f).lightLevel(state -> 4)));
        GeOreRegistry.ITEMS.register(this.getLargeBud().getId().getPath(), () -> new BlockItem((Block)this.getLargeBud().get(), new Item.Properties()));
        this.medium_bud = GeOreRegistry.BLOCKS.register("medium_" + name + "_bud", () -> new AmethystClusterBlock(4.0f, 3.0f, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.MEDIUM_AMETHYST_BUD).mapColor(color).noOcclusion().randomTicks().sound(SoundType.AMETHYST_CLUSTER).strength(1.5f).lightLevel(state -> 2)));
        GeOreRegistry.ITEMS.register(this.getMediumBud().getId().getPath(), () -> new BlockItem((Block)this.getMediumBud().get(), new Item.Properties()));
        this.small_bud = GeOreRegistry.BLOCKS.register("small_" + name + "_bud", () -> new AmethystClusterBlock(3.0f, 4.0f, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SMALL_AMETHYST_BUD).mapColor(color).noOcclusion().randomTicks().sound(SoundType.AMETHYST_CLUSTER).strength(1.5f).lightLevel(state -> 1)));
        GeOreRegistry.ITEMS.register(this.getSmallBud().getId().getPath(), () -> new BlockItem((Block)this.getSmallBud().get(), new Item.Properties()));
        this.cluster = GeOreRegistry.BLOCKS.register(name + "_cluster", () -> new AmethystClusterBlock(7.0f, 3.0f, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.AMETHYST_CLUSTER).mapColor(color).noOcclusion().randomTicks().sound(SoundType.AMETHYST_CLUSTER).strength(1.5f).lightLevel(state -> 5)));
        GeOreRegistry.ITEMS.register(this.getCluster().getId().getPath(), () -> new BlockItem((Block)this.getCluster().get(), new Item.Properties()));
        this.budding = GeOreRegistry.BLOCKS.register("budding_" + name, () -> new BuddingGeoreBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BUDDING_AMETHYST).mapColor(color).randomTicks().strength(1.5f).sound(SoundType.AMETHYST).requiresCorrectToolForDrops(), (Supplier<? extends AmethystClusterBlock>)this.getSmallBud(), (Supplier<? extends AmethystClusterBlock>)this.getMediumBud(), (Supplier<? extends AmethystClusterBlock>)this.getLargeBud(), (Supplier<? extends AmethystClusterBlock>)this.getCluster()));
        GeOreRegistry.ITEMS.register(this.getBudding().getId().getPath(), () -> new BlockItem((Block)this.getBudding().get(), new Item.Properties()));
        this.tinted_glass = GeOreRegistry.BLOCKS.register(name + "_tinted_glass", () -> new TintedGlassBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.TINTED_GLASS).mapColor(color).strength(0.3f).sound(SoundType.GLASS).noOcclusion()));
        GeOreRegistry.ITEMS.register(this.getTintedGlass().getId().getPath(), () -> new BlockItem((Block)this.getTintedGlass().get(), new Item.Properties()));
        this.shard = GeOreRegistry.ITEMS.register(name + "_shard", customShard);
        this.spyglass = GeOreRegistry.ITEMS.register(name + "_spyglass", () -> new GeoreSpyglassItem(new Item.Properties(), spyglassHex));
    }
}

