/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.chipped.common.compat.rei;

import earth.terrarium.chipped.common.compat.rei.WorkbenchCategory;
import earth.terrarium.chipped.common.compat.rei.WorkbenchDisplay;
import earth.terrarium.chipped.common.recipes.ChippedRecipe;
import earth.terrarium.chipped.common.registry.ModBlocks;
import earth.terrarium.chipped.common.registry.ModRecipeTypes;
import earth.terrarium.chipped.common.registry.base.ChippedPaletteRegistry;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.client.registry.entry.CollapsibleEntryRegistry;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.minecraft.client.Minecraft;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public class ChippedReiPlugin
implements REIClientPlugin {
    public static final CategoryIdentifier<WorkbenchDisplay> ID = CategoryIdentifier.of((String)"chipped", (String)"workbench");
    private final List<ChippedPaletteRegistry<Block>> paletteRegistries = new ArrayList<ChippedPaletteRegistry<Block>>();

    public void registerCategories(CategoryRegistry registry) {
        registry.add((DisplayCategory)new WorkbenchCategory());
        registry.addWorkstations(ID, new EntryStack[]{EntryStacks.of((ItemLike)((ItemLike)ModBlocks.BOTANIST_WORKBENCH.get())), EntryStacks.of((ItemLike)((ItemLike)ModBlocks.GLASSBLOWER.get())), EntryStacks.of((ItemLike)((ItemLike)ModBlocks.CARPENTERS_TABLE.get())), EntryStacks.of((ItemLike)((ItemLike)ModBlocks.LOOM_TABLE.get())), EntryStacks.of((ItemLike)((ItemLike)ModBlocks.MASON_TABLE.get())), EntryStacks.of((ItemLike)((ItemLike)ModBlocks.ALCHEMY_BENCH.get())), EntryStacks.of((ItemLike)((ItemLike)ModBlocks.TINKERING_TABLE.get()))});
    }

    public void registerDisplays(DisplayRegistry registry) {
        Objects.requireNonNull(Minecraft.getInstance().level).getRecipeManager().getAllRecipesFor((RecipeType)ModRecipeTypes.WORKBENCH.get()).forEach(recipe -> ((ChippedRecipe)recipe.value()).ingredients().forEach(ingredient -> registry.registerRecipeFiller(ChippedRecipe.class, (RecipeType)ModRecipeTypes.WORKBENCH.get(), r -> new WorkbenchDisplay((Ingredient)ingredient))));
    }

    public void registerCollapsibleEntries(CollapsibleEntryRegistry registry) {
        RecipeManager recipeManager = Objects.requireNonNull(Minecraft.getInstance().level).getRecipeManager();
        List<ChippedRecipe> recipes = recipeManager.getAllRecipesFor((RecipeType)ModRecipeTypes.WORKBENCH.get()).stream().map(recipe -> (ChippedRecipe)recipe.value()).toList();
        Object2IntArrayMap palettes = new Object2IntArrayMap();
        recipes.stream().map(ChippedRecipe::ingredients).flatMap(Collection::stream).map(Ingredient::getItems).map(Arrays::asList).forEach(ingredientStacks -> {
            Item baseItem = ((ItemStack)ingredientStacks.getFirst()).getItem();
            String baseItemDescriptionId = baseItem.getDescriptionId();
            int paletteIndex = palettes.getInt((Object)baseItemDescriptionId);
            palettes.put((Object)baseItemDescriptionId, paletteIndex + 1);
            ingredientStacks.removeFirst();
            registry.group(ResourceLocation.fromNamespaceAndPath((String)"chipped", (String)("palettes/" + BuiltInRegistries.ITEM.getKey((Object)baseItem).getPath() + "/" + paletteIndex)), (Component)Component.translatable((String)baseItemDescriptionId).append(" [Palette: " + paletteIndex + "]"), (List)EntryIngredients.ofItemStacks((Collection)ingredientStacks));
        });
    }
}

