/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.capability.ae2;

import appeng.blockentity.networking.EnergyAcceptorBlockEntity;
import ca.teamdman.sfm.common.capability.SFMBlockCapabilityKind;
import ca.teamdman.sfm.common.capability.SFMBlockCapabilityProvider;
import ca.teamdman.sfm.common.capability.SFMBlockCapabilityResult;
import ca.teamdman.sfm.common.capability.SFMWellKnownCapabilities;
import ca.teamdman.sfm.common.util.MCVersionDependentBehaviour;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.energy.IEnergyStorage;
import org.jetbrains.annotations.Nullable;

public class EnergyAcceptorBlockCapabilityProvider
implements SFMBlockCapabilityProvider<IEnergyStorage> {
    @Override
    public boolean matchesCapabilityKind(SFMBlockCapabilityKind<?> capabilityKind) {
        return SFMWellKnownCapabilities.ENERGY.equals(capabilityKind);
    }

    @Override
    @MCVersionDependentBehaviour
    public SFMBlockCapabilityResult<IEnergyStorage> getCapability(SFMBlockCapabilityKind<IEnergyStorage> capabilityKind, Level level, BlockPos pos, BlockState state, @Nullable BlockEntity blockEntity, @Nullable Direction direction) {
        if (blockEntity instanceof EnergyAcceptorBlockEntity) {
            EnergyAcceptorBlockEntity energyAcceptor = (EnergyAcceptorBlockEntity)blockEntity;
            IEnergyStorage energyStorage = (IEnergyStorage)level.getCapability(capabilityKind.capabilityKind(), pos, state, blockEntity, (Object)direction);
            if (energyStorage == null) {
                return SFMBlockCapabilityResult.empty();
            }
            return SFMBlockCapabilityResult.of(new EnergyAcceptorEnergyStorageWrapper(energyStorage));
        }
        return SFMBlockCapabilityResult.empty();
    }

    public record EnergyAcceptorEnergyStorageWrapper(IEnergyStorage inner) implements IEnergyStorage
    {
        public int receiveEnergy(int maxReceive, boolean simulate) {
            return this.inner.receiveEnergy(maxReceive, simulate);
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            return this.inner.extractEnergy(maxExtract, simulate);
        }

        public int getEnergyStored() {
            return this.inner.getEnergyStored();
        }

        public int getMaxEnergyStored() {
            return Integer.MAX_VALUE;
        }

        public boolean canExtract() {
            return this.inner.canExtract();
        }

        public boolean canReceive() {
            return this.inner.canReceive();
        }
    }
}

