/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.facade;

import ca.teamdman.sfm.SFM;
import ca.teamdman.sfm.common.block.IFacadableBlock;
import ca.teamdman.sfm.common.facade.FacadePlanAnalysisResult;
import ca.teamdman.sfm.common.facade.IFacadePlan;
import ca.teamdman.sfm.common.localization.LocalizationKeys;
import ca.teamdman.sfm.common.util.ConfirmationParams;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public record ClearFacadesFacadePlan(Set<BlockPos> positions) implements IFacadePlan
{
    @Override
    public void apply(Level level) {
        this.positions().forEach(pos -> {
            Block existingBlock = level.getBlockState(pos).getBlock();
            if (existingBlock instanceof IFacadableBlock) {
                IFacadableBlock facadableBlock = (IFacadableBlock)existingBlock;
                BlockState nextBlockState = facadableBlock.getNonFacadeBlock().getStateForPlacementByFacadePlan((LevelAccessor)level, (BlockPos)pos);
                level.setBlock(pos, nextBlockState, 10);
            } else {
                SFM.LOGGER.warn("Block {} at {} is not a facadable block", (Object)existingBlock, pos);
            }
        });
    }

    @Override
    @Nullable
    public ConfirmationParams computeWarning(Level level) {
        FacadePlanAnalysisResult analysisResult = FacadePlanAnalysisResult.analyze(level, this.positions);
        if (analysisResult.shouldWarn()) {
            return ConfirmationParams.of(LocalizationKeys.FACADE_CONFIRM_CLEAR_SCREEN_TITLE.getComponent(), LocalizationKeys.FACADE_CONFIRM_CLEAR_SCREEN_MESSAGE.getComponent(analysisResult.facadeDataToCount().size(), analysisResult.countAffected()));
        }
        return null;
    }
}

