/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.label;

import ca.teamdman.sfm.common.blockentity.ManagerBlockEntity;
import ca.teamdman.sfm.common.item.LabelGunItem;
import ca.teamdman.sfm.common.label.LabelGunManagerPushOrPullAction;
import ca.teamdman.sfm.common.label.LabelGunPickLabelAction;
import ca.teamdman.sfm.common.label.LabelGunPlan;
import ca.teamdman.sfm.common.label.LabelGunPlanTargets;
import ca.teamdman.sfm.common.label.LabelGunToggleLabelAction;
import ca.teamdman.sfm.common.label.LabelGunUnsetBlockLabelsAction;
import ca.teamdman.sfm.common.label.LabelPositionHolder;
import ca.teamdman.sfm.common.localization.LocalizationKeys;
import ca.teamdman.sfm.common.net.ServerboundLabelGunUsePacket;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;

public class LabelGunPlanner {
    @Nullable
    public static LabelGunPlan getLabelGunPlan(Player player, ServerboundLabelGunUsePacket msg, boolean doWarning) {
        BlockEntity blockEntity;
        ItemStack gunStack = player.getItemInHand(msg.hand());
        Level level = player.level();
        if (!(gunStack.getItem() instanceof LabelGunItem)) {
            return null;
        }
        LabelPositionHolder gunLabels = LabelPositionHolder.from(gunStack).toOwned();
        if (!msg.isTargetManagerModifierActive() && (blockEntity = level.getBlockEntity(msg.pos())) instanceof ManagerBlockEntity) {
            ManagerBlockEntity manager = (ManagerBlockEntity)blockEntity;
            return new LabelGunManagerPushOrPullAction(player, level, msg, gunStack, gunLabels, manager);
        }
        String activeLabel = LabelGunItem.getActiveLabel(gunStack);
        LabelGunPlanTargets targets = LabelGunPlanTargets.getTargets(level, msg);
        if (doWarning && !targets.warnBecauseNoCableNeighbour().isEmpty()) {
            player.sendSystemMessage((Component)LocalizationKeys.LABEL_GUN_CHAT_SKIPPED_BLOCKS.getComponent(targets.warnBecauseNoCableNeighbour().size()));
        }
        if (msg.isClearModifierActive()) {
            return new LabelGunUnsetBlockLabelsAction(player, level, msg, gunStack, gunLabels, targets, activeLabel);
        }
        if (msg.isPickBlockModifierActive()) {
            return new LabelGunPickLabelAction(player, level, msg, gunStack, gunLabels, targets, activeLabel);
        }
        return new LabelGunToggleLabelAction(player, level, msg, gunStack, gunLabels, targets, activeLabel);
    }
}

