/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.net;

import ca.teamdman.sfm.common.blockentity.ManagerBlockEntity;
import ca.teamdman.sfm.common.containermenu.ManagerContainerMenu;
import ca.teamdman.sfm.common.net.SFMPacket;
import ca.teamdman.sfm.common.net.SFMPacketDaddy;
import ca.teamdman.sfm.common.net.SFMPacketHandlingContext;
import ca.teamdman.sfm.common.program.linting.ProgramLinter;
import ca.teamdman.sfml.ast.Program;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.item.ItemStack;

public record ServerboundManagerFixPacket(int windowId, BlockPos pos) implements SFMPacket
{

    public static class Daddy
    implements SFMPacketDaddy<ServerboundManagerFixPacket> {
        @Override
        public SFMPacketDaddy.PacketDirection getPacketDirection() {
            return SFMPacketDaddy.PacketDirection.SERVERBOUND;
        }

        @Override
        public void encode(ServerboundManagerFixPacket msg, RegistryFriendlyByteBuf friendlyByteBuf) {
            friendlyByteBuf.writeVarInt(msg.windowId());
            friendlyByteBuf.writeBlockPos(msg.pos());
        }

        @Override
        public ServerboundManagerFixPacket decode(RegistryFriendlyByteBuf friendlyByteBuf) {
            return new ServerboundManagerFixPacket(friendlyByteBuf.readVarInt(), friendlyByteBuf.readBlockPos());
        }

        @Override
        public void handle(ServerboundManagerFixPacket msg, SFMPacketHandlingContext context) {
            context.handleServerboundContainerPacket(ManagerContainerMenu.class, ManagerBlockEntity.class, msg.pos, msg.windowId, (menu, manager) -> {
                Program program;
                ItemStack disk = manager.getDisk();
                if (disk != null && (program = manager.getProgram()) != null) {
                    ProgramLinter.fixWarnings(manager, disk, program);
                }
            });
        }

        @Override
        public Class<ServerboundManagerFixPacket> getPacketClass() {
            return ServerboundManagerFixPacket.class;
        }
    }
}

