/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.program.linting;

import ca.teamdman.sfm.common.blockentity.ManagerBlockEntity;
import ca.teamdman.sfm.common.cablenetwork.CableNetworkManager;
import ca.teamdman.sfm.common.capability.SFMBlockCapabilityDiscovery;
import ca.teamdman.sfm.common.item.DiskItem;
import ca.teamdman.sfm.common.label.LabelPositionHolder;
import ca.teamdman.sfm.common.localization.LocalizationKeys;
import ca.teamdman.sfm.common.program.linting.IProgramLinter;
import ca.teamdman.sfml.ast.Program;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.extensions.ILevelExtension;
import org.jetbrains.annotations.Nullable;

public class LabelLinter
implements IProgramLinter {
    @Override
    public ArrayList<TranslatableContents> gatherWarnings(Program program, LabelPositionHolder labelPositionHolder, @Nullable ManagerBlockEntity managerBlockEntity) {
        ArrayList<TranslatableContents> warnings = new ArrayList<TranslatableContents>();
        this.addWarningsForLabelsInProgramButNotInHolder(program, labelPositionHolder, warnings);
        this.addWarningsForLabelsInHolderButNotInProgram(program, labelPositionHolder, warnings);
        if (managerBlockEntity != null && managerBlockEntity.getLevel() != null) {
            this.addWarningsForLabelsUsedInWorldButNotConnectedByCables(managerBlockEntity, labelPositionHolder, warnings, managerBlockEntity.getLevel());
        }
        if (!warnings.isEmpty()) {
            warnings.add(LocalizationKeys.PROGRAM_REMINDER_PUSH_LABELS.get());
        }
        return warnings;
    }

    @Override
    public void fixWarnings(ManagerBlockEntity managerBlockEntity, ItemStack diskStack, Program program) {
        if (managerBlockEntity == null || managerBlockEntity.getLevel() == null) {
            return;
        }
        this.fixWarningsByRemovingBadLabelsFromDisk(managerBlockEntity, diskStack, program);
    }

    private void addWarningsForLabelsInProgramButNotInHolder(Program program, LabelPositionHolder labels, ArrayList<TranslatableContents> warnings) {
        for (String label : program.referencedLabels()) {
            boolean isUsed = !labels.getPositions(label).isEmpty();
            if (isUsed) continue;
            warnings.add(LocalizationKeys.PROGRAM_WARNING_UNUSED_LABEL.get(label));
        }
    }

    private void addWarningsForLabelsInHolderButNotInProgram(Program program, LabelPositionHolder labels, ArrayList<TranslatableContents> warnings) {
        labels.labels().keySet().stream().filter(x -> !program.referencedLabels().contains(x)).forEach(label -> warnings.add(LocalizationKeys.PROGRAM_WARNING_UNDEFINED_LABEL.get(label)));
    }

    private void addWarningsForLabelsUsedInWorldButNotConnectedByCables(ManagerBlockEntity manager, LabelPositionHolder labels, ArrayList<TranslatableContents> warnings, Level level) {
        CableNetworkManager.getOrRegisterNetworkFromManagerPosition(manager).ifPresent(network -> labels.forEach((label, pos) -> {
            boolean viable;
            boolean adjacent = network.isAdjacentToCable((BlockPos)pos);
            if (!adjacent) {
                warnings.add(LocalizationKeys.PROGRAM_WARNING_DISCONNECTED_LABEL.get(label, String.format("[%d,%d,%d]", pos.getX(), pos.getY(), pos.getZ())));
            }
            if (!(viable = SFMBlockCapabilityDiscovery.hasAnyCapabilityAnyDirection((ILevelExtension)level, pos)) && adjacent) {
                warnings.add(LocalizationKeys.PROGRAM_WARNING_CONNECTED_BUT_NOT_VIABLE_LABEL.get(label, String.format("[%d,%d,%d]", pos.getX(), pos.getY(), pos.getZ())));
            }
        }));
    }

    private void fixWarningsByRemovingBadLabelsFromDisk(ManagerBlockEntity manager, ItemStack disk, Program program) {
        LabelPositionHolder labels = LabelPositionHolder.from(disk);
        labels.removeIf(label -> !program.referencedLabels().contains(label));
        CableNetworkManager.getOrRegisterNetworkFromManagerPosition(manager).ifPresent(network -> labels.removeIf((label, pos) -> !network.isAdjacentToCable((BlockPos)pos)));
        Level level = manager.getLevel();
        labels.removeIf((label, pos) -> !SFMBlockCapabilityDiscovery.hasAnyCapabilityAnyDirection((ILevelExtension)level, pos));
        labels.save(disk);
        ArrayList<TranslatableContents> updatedWarnings = this.gatherWarnings(program, labels, manager);
        DiskItem.setWarnings(disk, updatedWarnings);
    }
}

