/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.recipe;

import ca.teamdman.sfm.common.blockentity.PrintingPressBlockEntity;
import ca.teamdman.sfm.common.item.FormItem;
import ca.teamdman.sfm.common.registry.SFMRecipeSerializers;
import ca.teamdman.sfm.common.registry.SFMRecipeTypes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public record PrintingPressRecipe(Ingredient form, Ingredient ink, Ingredient paper) implements Recipe<PrintingPressBlockEntity>
{
    public boolean matches(PrintingPressBlockEntity pContainer, Level pLevel) {
        return this.paper.test(pContainer.getPaper()) && this.ink.test(pContainer.getInk()) && this.form.test(FormItem.getBorrowedReferenceFromForm(pContainer.getForm()));
    }

    public ItemStack assemble(PrintingPressBlockEntity pContainer, HolderLookup.Provider provider) {
        ItemStack rtn = FormItem.getCopiedReferenceFromForm(pContainer.getForm());
        rtn.setCount(pContainer.getPaper().getCount());
        return rtn;
    }

    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider pRegistries) {
        return ItemStack.EMPTY;
    }

    public RecipeSerializer<?> getSerializer() {
        return SFMRecipeSerializers.PRINTING_PRESS.get();
    }

    public RecipeType<?> getType() {
        return SFMRecipeTypes.PRINTING_PRESS.get();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        PrintingPressRecipe that = (PrintingPressRecipe)obj;
        return Objects.equals(this.form, that.form) && Objects.equals(this.ink, that.ink) && Objects.equals(this.paper, that.paper);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.form, this.ink, this.paper);
    }

    @Override
    public String toString() {
        return "PrintingPressRecipe[form=" + String.valueOf(this.form) + ", ink=" + String.valueOf(this.ink) + ", paper=" + String.valueOf(this.paper) + "]";
    }

    public static class Serializer
    implements RecipeSerializer<PrintingPressRecipe> {
        private final MapCodec<PrintingPressRecipe> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Ingredient.CODEC.fieldOf("form").forGetter(PrintingPressRecipe::form), (App)Ingredient.CODEC.fieldOf("ink").forGetter(PrintingPressRecipe::ink), (App)Ingredient.CODEC.fieldOf("paper").forGetter(PrintingPressRecipe::paper)).apply((Applicative)builder, PrintingPressRecipe::new));
        private final StreamCodec<RegistryFriendlyByteBuf, PrintingPressRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<PrintingPressRecipe> codec() {
            return this.CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, PrintingPressRecipe> streamCodec() {
            return this.STREAM_CODEC;
        }

        public static PrintingPressRecipe fromNetwork(RegistryFriendlyByteBuf buf) {
            Ingredient form = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buf);
            Ingredient ink = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buf);
            Ingredient paper = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buf);
            return new PrintingPressRecipe(form, ink, paper);
        }

        public static void toNetwork(RegistryFriendlyByteBuf buf, PrintingPressRecipe pRecipe) {
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buf, (Object)pRecipe.form);
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buf, (Object)pRecipe.ink);
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buf, (Object)pRecipe.paper);
        }
    }
}

