/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.neoforge;

import com.google.gson.JsonElement;
import java.util.Objects;
import java.util.UUID;
import me.lucko.spark.common.command.sender.AbstractCommandSender;
import me.lucko.spark.lib.adventure.text.serializer.gson.GsonComponentSerializer;
import me.lucko.spark.neoforge.plugin.NeoForgeServerSparkPlugin;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;

public class NeoForgeServerCommandSender
extends AbstractCommandSender<CommandSourceStack> {
    private final NeoForgeServerSparkPlugin plugin;

    public NeoForgeServerCommandSender(CommandSourceStack commandSource, NeoForgeServerSparkPlugin plugin) {
        super(commandSource);
        this.plugin = plugin;
    }

    @Override
    public String getName() {
        String name = ((CommandSourceStack)this.delegate).getTextName();
        if (((CommandSourceStack)this.delegate).getEntity() != null && name.equals("Server")) {
            return "Console";
        }
        return name;
    }

    @Override
    public UUID getUniqueId() {
        Entity entity = ((CommandSourceStack)this.delegate).getEntity();
        return entity != null ? entity.getUUID() : null;
    }

    @Override
    public void sendMessage(me.lucko.spark.lib.adventure.text.Component message) {
        MutableComponent component = Component.Serializer.fromJson((JsonElement)GsonComponentSerializer.gson().serializeToTree(message), (HolderLookup.Provider)RegistryAccess.EMPTY);
        Objects.requireNonNull(component, "component");
        ((CommandSourceStack)this.delegate).sendSystemMessage((Component)component);
    }

    @Override
    public boolean hasPermission(String permission) {
        return this.plugin.hasPermission((CommandSourceStack)this.delegate, permission);
    }

    @Override
    protected Object getObjectForComparison() {
        UUID uniqueId = this.getUniqueId();
        if (uniqueId != null) {
            return uniqueId;
        }
        Entity entity = ((CommandSourceStack)this.delegate).getEntity();
        if (entity != null) {
            return entity;
        }
        return this.getName();
    }
}

