/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekaf.common.attachments.containers.item;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalHandler;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.functions.ConstantPredicates;
import mekanism.common.attachments.containers.ContainerType;
import mekanism.common.attachments.containers.creator.BaseContainerCreator;
import mekanism.common.attachments.containers.creator.IBasicContainerCreator;
import mekanism.common.attachments.containers.item.AttachedItems;
import mekanism.common.attachments.containers.item.ComponentBackedInventorySlot;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.integration.energy.EnergyCompatUtils;
import mekanism.common.inventory.slot.EnergyInventorySlot;
import mekanism.common.inventory.slot.chemical.ChemicalInventorySlot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class AFItemSlotsBuilder {
    private static final IBasicContainerCreator<ComponentBackedInventorySlot> OUTPUT_SLOT_CREATOR = (type, attachedTo, containerIndex) -> new ComponentBackedInventorySlot(attachedTo, containerIndex, ConstantPredicates.alwaysTrueBi(), ConstantPredicates.internalOnly(), ConstantPredicates.alwaysTrue());
    private static final BiPredicate<@NotNull ItemStack, @NotNull AutomationType> FILL_CONVERT_ENERGY_SLOT_CAN_EXTRACT = (stack, automationType) -> automationType == AutomationType.MANUAL || !EnergyInventorySlot.fillInsertCheck((ItemStack)stack) && EnergyInventorySlot.getPotentialConversion(null, (ItemStack)stack) == 0L;
    private static final BiPredicate<@NotNull ItemStack, @NotNull AutomationType> FILL_CONVERT_ENERGY_SLOT_CAN_INSERT = (stack, automationType) -> {
        if (EnergyInventorySlot.fillInsertCheck((ItemStack)stack)) {
            return true;
        }
        return EnergyInventorySlot.getPotentialConversion(null, (ItemStack)stack) > 0L;
    };
    private static final Predicate<ItemStack> FILL_CONVERT_ENERGY_SLOT_VALIDATOR = stack -> EnergyCompatUtils.hasStrictEnergyHandler((ItemStack)stack) || EnergyInventorySlot.getPotentialConversion(null, (ItemStack)stack) > 0L;
    private static final IBasicContainerCreator<ComponentBackedInventorySlot> FILL_CONVERT_ENERGY_SLOT_CREATOR = (type, attachedTo, containerIndex) -> new ComponentBackedInventorySlot(attachedTo, containerIndex, FILL_CONVERT_ENERGY_SLOT_CAN_EXTRACT, FILL_CONVERT_ENERGY_SLOT_CAN_INSERT, FILL_CONVERT_ENERGY_SLOT_VALIDATOR);
    private final List<IBasicContainerCreator<? extends ComponentBackedInventorySlot>> slotCreators = new ArrayList<IBasicContainerCreator<? extends ComponentBackedInventorySlot>>();

    public static AFItemSlotsBuilder builder() {
        return new AFItemSlotsBuilder();
    }

    private AFItemSlotsBuilder() {
    }

    public BaseContainerCreator<AttachedItems, ComponentBackedInventorySlot> build() {
        return new AFBaseInventorySlotCreator(this.slotCreators);
    }

    public AFItemSlotsBuilder addInputFactorySlots(int process, Predicate<ItemStack> recipeInputPredicate) {
        IBasicContainerCreator inputSlotCreator = (type, attachedTo, containerIndex) -> new ComponentBackedInventorySlot(attachedTo, containerIndex, ConstantPredicates.notExternal(), ConstantPredicates.alwaysTrueBi(), recipeInputPredicate);
        for (int i = 0; i < process; ++i) {
            this.addSlot((IBasicContainerCreator<? extends ComponentBackedInventorySlot>)inputSlotCreator);
        }
        return this;
    }

    public AFItemSlotsBuilder addOutputFactorySlots(int process) {
        for (int i = 0; i < process; ++i) {
            this.addOutput();
        }
        return this;
    }

    public AFItemSlotsBuilder addOutput() {
        return this.addSlot(OUTPUT_SLOT_CREATOR);
    }

    public AFItemSlotsBuilder addEnergy() {
        return this.addSlot(FILL_CONVERT_ENERGY_SLOT_CREATOR);
    }

    public AFItemSlotsBuilder addSlot(IBasicContainerCreator<? extends ComponentBackedInventorySlot> slot) {
        this.slotCreators.add(slot);
        return this;
    }

    private boolean canChemicalFillOrConvertExtract(ItemStack attachedTo, int tankIndex, ItemStack stack) {
        ChemicalStack conversion;
        int tanks;
        IChemicalHandler handler = (IChemicalHandler)Capabilities.CHEMICAL.getCapability(stack);
        IChemicalTank chemicalTank = null;
        if (handler != null && (tanks = handler.getChemicalTanks()) > 0) {
            chemicalTank = (IChemicalTank)ContainerType.CHEMICAL.createContainer(attachedTo, tankIndex);
            for (int tank = 0; tank < tanks; ++tank) {
                if (!chemicalTank.isValid(handler.getChemicalInTank(tank))) continue;
                return false;
            }
        }
        if ((conversion = ChemicalInventorySlot.getPotentialConversion(null, (ItemStack)stack)).isEmpty()) {
            return true;
        }
        if (chemicalTank == null) {
            chemicalTank = (IChemicalTank)ContainerType.CHEMICAL.createContainer(attachedTo, tankIndex);
        }
        return !chemicalTank.isValid(conversion);
    }

    private boolean canChemicalFillOrConvertInsert(ItemStack attachedTo, int tankIndex, ItemStack stack) {
        ChemicalStack conversion;
        IChemicalTank chemicalTank = null;
        IChemicalHandler handler = (IChemicalHandler)Capabilities.CHEMICAL.getCapability(stack);
        if (handler != null) {
            for (int tank = 0; tank < handler.getChemicalTanks(); ++tank) {
                ChemicalStack chemicalInTank = handler.getChemicalInTank(tank);
                if (chemicalInTank.isEmpty()) continue;
                if (chemicalTank == null) {
                    chemicalTank = (IChemicalTank)ContainerType.CHEMICAL.createContainer(attachedTo, tankIndex);
                }
                if (chemicalTank.insert(chemicalInTank, Action.SIMULATE, AutomationType.INTERNAL).getAmount() >= chemicalInTank.getAmount()) continue;
                return true;
            }
        }
        if ((conversion = ChemicalInventorySlot.getPotentialConversion(null, (ItemStack)stack)).isEmpty()) {
            return false;
        }
        if (chemicalTank == null) {
            chemicalTank = (IChemicalTank)ContainerType.CHEMICAL.createContainer(attachedTo, tankIndex);
        }
        if (chemicalTank.insert(conversion, Action.SIMULATE, AutomationType.INTERNAL).getAmount() < conversion.getAmount()) {
            return true;
        }
        return chemicalTank.getNeeded() == 0L && chemicalTank.isTypeEqual(conversion) && chemicalTank.isValid(conversion);
    }

    public AFItemSlotsBuilder addChemicalFillOrConvertSlot(int tankIndex) {
        return this.addSlot((IBasicContainerCreator<? extends ComponentBackedInventorySlot>)((IBasicContainerCreator)(type, attachedTo, containerIndex) -> new ComponentBackedInventorySlot(attachedTo, containerIndex, (stack, automationType) -> automationType == AutomationType.MANUAL || this.canChemicalFillOrConvertExtract(attachedTo, tankIndex, (ItemStack)stack), (stack, automationType) -> this.canChemicalFillOrConvertInsert(attachedTo, tankIndex, (ItemStack)stack), ConstantPredicates.alwaysTrue())));
    }

    private static class AFBaseInventorySlotCreator
    extends BaseContainerCreator<AttachedItems, ComponentBackedInventorySlot> {
        public AFBaseInventorySlotCreator(List<IBasicContainerCreator<? extends ComponentBackedInventorySlot>> creators) {
            super(creators);
        }

        public AttachedItems initStorage(int containers) {
            return AttachedItems.create((int)containers);
        }
    }
}

