/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekaf.common.tile.factory;

import com.jerry.mekaf.common.capabilities.energy.AdvancedFactoryEnergyContainer;
import com.jerry.mekaf.common.tile.factory.TileEntityItemToChemicalFactory;
import com.jerry.mekaf.common.upgrade.ItemChemicalToChemicalUpgradeData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.function.BooleanSupplier;
import mekanism.api.IContentsListener;
import mekanism.api.Upgrade;
import mekanism.api.chemical.BasicChemicalTank;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.math.MathUtils;
import mekanism.api.recipes.ChemicalDissolutionRecipe;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.cache.ItemStackConstantChemicalToObjectCachedRecipe;
import mekanism.api.recipes.cache.TwoInputCachedRecipe;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.inputs.ILongInputHandler;
import mekanism.api.recipes.inputs.InputHelper;
import mekanism.api.recipes.outputs.IOutputHandler;
import mekanism.client.recipe_viewer.type.IRecipeViewerRecipeType;
import mekanism.client.recipe_viewer.type.RecipeViewerRecipeType;
import mekanism.common.Mekanism;
import mekanism.common.capabilities.holder.chemical.ChemicalTankHelper;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.inventory.slot.chemical.ChemicalInventorySlot;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.recipe.IMekanismRecipeTypeProvider;
import mekanism.common.recipe.MekanismRecipeType;
import mekanism.common.recipe.lookup.IDoubleRecipeLookupHandler;
import mekanism.common.recipe.lookup.IRecipeLookupHandler;
import mekanism.common.recipe.lookup.cache.DoubleInputRecipeCache;
import mekanism.common.recipe.lookup.cache.InputRecipeCache;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.tile.component.config.ConfigInfo;
import mekanism.common.tile.component.config.DataType;
import mekanism.common.tile.component.config.slot.ChemicalSlotInfo;
import mekanism.common.tile.component.config.slot.ISlotInfo;
import mekanism.common.tile.component.config.slot.InventorySlotInfo;
import mekanism.common.tile.interfaces.IHasDumpButton;
import mekanism.common.tile.interfaces.IUpgradeTile;
import mekanism.common.upgrade.IUpgradeData;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.StatUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityDissolvingFactory
extends TileEntityItemToChemicalFactory<ChemicalDissolutionRecipe>
implements IHasDumpButton,
IRecipeLookupHandler.ConstantUsageRecipeLookupHandler,
IDoubleRecipeLookupHandler.ItemChemicalRecipeLookupHandler<ChemicalDissolutionRecipe> {
    private static final DoubleInputRecipeCache.CheckRecipeType<ItemStack, ChemicalStack, ChemicalDissolutionRecipe, ChemicalStack> OUTPUT_CHECK = (recipe, input, extra, output) -> ChemicalStack.isSameChemical((ChemicalStack)((ChemicalStack)recipe.getOutput(input, extra)), (ChemicalStack)output);
    private static final List<CachedRecipe.OperationTracker.RecipeError> TRACKED_ERROR_TYPES = List.of(CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_ENERGY, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_ENERGY_REDUCED_RATE, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_INPUT, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_SECONDARY_INPUT, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_OUTPUT_SPACE, CachedRecipe.OperationTracker.RecipeError.INPUT_DOESNT_PRODUCE_OUTPUT);
    private static final Set<CachedRecipe.OperationTracker.RecipeError> GLOBAL_ERROR_TYPES = Set.of(CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_ENERGY, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_SECONDARY_INPUT);
    private final ILongInputHandler<@NotNull ChemicalStack> chemicalInputHandler;
    private final ItemStackConstantChemicalToObjectCachedRecipe.ChemicalUsageMultiplier injectUsageMultiplier;
    private double injectUsage = 1.0;
    private final long[] usedSoFar;
    public IChemicalTank injectTank;
    ChemicalInventorySlot chemicalInputSlot;

    public TileEntityDissolvingFactory(Holder<Block> blockProvider, BlockPos pos, BlockState state) {
        super(blockProvider, pos, state, TRACKED_ERROR_TYPES, GLOBAL_ERROR_TYPES);
        ConfigInfo chemicalConfig;
        ConfigInfo itemConfig = this.configComponent.getConfig(TransmissionType.ITEM);
        if (itemConfig != null) {
            itemConfig.addSlotInfo(DataType.EXTRA, (ISlotInfo)new InventorySlotInfo(true, true, new IInventorySlot[]{this.chemicalInputSlot}));
        }
        if ((chemicalConfig = this.configComponent.getConfig(TransmissionType.CHEMICAL)) != null) {
            chemicalConfig.addSlotInfo(DataType.INPUT, (ISlotInfo)new ChemicalSlotInfo(true, false, new IChemicalTank[]{this.injectTank}));
            ArrayList<IChemicalTank> ioTank = new ArrayList<IChemicalTank>(List.of(this.injectTank));
            ioTank.addAll(this.outputChemicalTanks);
            chemicalConfig.addSlotInfo(DataType.INPUT_OUTPUT, (ISlotInfo)new ChemicalSlotInfo(true, true, ioTank));
        }
        this.ejectorComponent = new TileComponentEjector((TileEntityMekanism)this);
        this.ejectorComponent.setOutputData(this.configComponent, new TransmissionType[]{TransmissionType.ITEM, TransmissionType.CHEMICAL}).setCanTankEject(tank -> tank != this.injectTank);
        this.usedSoFar = new long[this.tier.processes];
        this.chemicalInputHandler = InputHelper.getConstantInputHandler((IChemicalTank)this.injectTank);
        this.injectUsageMultiplier = (usedSoFar, operatingTicks) -> StatUtils.inversePoisson((double)this.injectUsage);
    }

    @Override
    protected void addTanks(ChemicalTankHelper builder, IContentsListener listener, IContentsListener updateSortingListener) {
        super.addTanks(builder, listener, updateSortingListener);
        this.injectTank = BasicChemicalTank.inputModern((long)(10000L * (long)this.tier.processes), arg_0 -> ((TileEntityDissolvingFactory)this).containsRecipeB(arg_0), (IContentsListener)this.markAllMonitorsChanged(listener));
        builder.addTank(this.injectTank);
    }

    @Override
    protected void addSlots(InventorySlotHelper builder, IContentsListener listener, IContentsListener updateSortingListener) {
        super.addSlots(builder, listener, updateSortingListener);
        this.chemicalInputSlot = ChemicalInventorySlot.fillOrConvert((IChemicalTank)this.injectTank, () -> ((TileEntityDissolvingFactory)this).getLevel(), (IContentsListener)listener, (int)7, (int)70);
        builder.addSlot((IInventorySlot)this.chemicalInputSlot);
    }

    @Override
    public IChemicalTank getChemicalTankBar() {
        return this.injectTank;
    }

    @Override
    protected void handleSecondaryFuel() {
        this.chemicalInputSlot.fillTankOrConvert();
    }

    @Override
    public boolean hasSecondaryResourceBar() {
        return true;
    }

    @Override
    @Contract(value="null, _ -> false")
    protected boolean isCachedRecipeValid(@Nullable CachedRecipe<ChemicalDissolutionRecipe> cached, @NotNull ItemStack stack) {
        if (cached != null) {
            ChemicalDissolutionRecipe cachedRecipe = (ChemicalDissolutionRecipe)cached.getRecipe();
            return cachedRecipe.getItemInput().testType(stack) && (this.injectTank.isEmpty() || cachedRecipe.getChemicalInput().testType(this.injectTank.getTypeHolder()));
        }
        return false;
    }

    @Override
    @Nullable
    protected ChemicalDissolutionRecipe findRecipe(int process, @NotNull ItemStack fallbackInput, @NotNull IChemicalTank outputSlot) {
        return (ChemicalDissolutionRecipe)((InputRecipeCache.ItemChemical)this.getRecipeType().getInputCache()).findTypeBasedRecipe(this.level, (Object)fallbackInput, (Object)this.injectTank.getStack(), (Object)outputSlot.getStack(), OUTPUT_CHECK);
    }

    @Override
    protected int getNeededInput(ChemicalDissolutionRecipe recipe, ItemStack inputStack) {
        return MathUtils.clampToInt((long)recipe.getItemInput().getNeededAmount(inputStack));
    }

    @Override
    public boolean isItemValidForSlot(@NotNull ItemStack stack) {
        return this.containsRecipeBA(stack, this.injectTank.getStack());
    }

    @Override
    public boolean isValidInputItem(@NotNull ItemStack stack) {
        return this.containsRecipeA(stack);
    }

    @NotNull
    public IMekanismRecipeTypeProvider<?, ChemicalDissolutionRecipe, InputRecipeCache.ItemChemical<ChemicalDissolutionRecipe>> getRecipeType() {
        return MekanismRecipeType.DISSOLUTION;
    }

    @Nullable
    public IRecipeViewerRecipeType<ChemicalDissolutionRecipe> recipeViewerType() {
        return RecipeViewerRecipeType.DISSOLUTION;
    }

    @Nullable
    public ChemicalDissolutionRecipe getRecipe(int cacheIndex) {
        return (ChemicalDissolutionRecipe)this.findFirstRecipe(this.itemInputHandlers[cacheIndex], (IInputHandler)this.chemicalInputHandler);
    }

    @NotNull
    public CachedRecipe<ChemicalDissolutionRecipe> createNewCachedRecipe(@NotNull ChemicalDissolutionRecipe recipe, int cacheIndex) {
        Object cachedRecipe = recipe.perTickUsage() ? ItemStackConstantChemicalToObjectCachedRecipe.dissolution((ChemicalDissolutionRecipe)recipe, (BooleanSupplier)this.recheckAllRecipeErrors[cacheIndex], (IInputHandler)this.itemInputHandlers[cacheIndex], this.chemicalInputHandler, (ItemStackConstantChemicalToObjectCachedRecipe.ChemicalUsageMultiplier)this.injectUsageMultiplier, used -> {
            this.usedSoFar[cacheIndex] = used;
        }, (IOutputHandler)this.chemicalOutputHandlers[cacheIndex]) : TwoInputCachedRecipe.itemChemicalToChemical((ChemicalDissolutionRecipe)recipe, (BooleanSupplier)this.recheckAllRecipeErrors[cacheIndex], (IInputHandler)this.itemInputHandlers[cacheIndex], this.chemicalInputHandler, (IOutputHandler)this.chemicalOutputHandlers[cacheIndex]);
        return cachedRecipe.setErrorsChanged(errors -> this.errorTracker.onErrorsChanged((Set<CachedRecipe.OperationTracker.RecipeError>)errors, cacheIndex)).setCanHolderFunction(() -> ((TileEntityDissolvingFactory)this).canFunction()).setActive(active -> this.setActiveState(active, cacheIndex)).setEnergyRequirements(() -> ((AdvancedFactoryEnergyContainer)this.energyContainer).getEnergyPerTick(), (IEnergyContainer)this.energyContainer).setRequiredTicks(this::getTicksRequired).setOnFinish(() -> ((TileEntityDissolvingFactory)this).markForSave()).setOperatingTicksChanged(operatingTicks -> {
            this.progress[cacheIndex] = operatingTicks;
        }).setBaselineMaxOperations(this::getOperationsPerTick);
    }

    @Override
    public void recalculateUpgrades(Upgrade upgrade) {
        super.recalculateUpgrades(upgrade);
        if (upgrade == Upgrade.CHEMICAL || upgrade == Upgrade.SPEED) {
            this.injectUsage = MekanismUtils.getGasPerTickMeanMultiplier((IUpgradeTile)this);
        }
    }

    public long getSavedUsedSoFar(int cacheIndex) {
        return this.usedSoFar[cacheIndex];
    }

    @Override
    public void loadAdditional(@NotNull CompoundTag nbt, @NotNull HolderLookup.Provider provider) {
        super.loadAdditional(nbt, provider);
        if (nbt.contains("used_so_far", 12)) {
            long[] savedUsed = nbt.getLongArray("used_so_far");
            if (this.tier.processes != savedUsed.length) {
                Arrays.fill(this.usedSoFar, 0L);
            }
            for (int i = 0; i < this.tier.processes && i < savedUsed.length; ++i) {
                this.usedSoFar[i] = savedUsed[i];
            }
        } else {
            Arrays.fill(this.usedSoFar, 0L);
        }
    }

    @Override
    public void saveAdditional(@NotNull CompoundTag nbtTags, @NotNull HolderLookup.Provider provider) {
        super.saveAdditional(nbtTags, provider);
        nbtTags.putLongArray("used_so_far", Arrays.copyOf(this.usedSoFar, this.usedSoFar.length));
    }

    @Override
    public void parseUpgradeData(HolderLookup.Provider provider, @NotNull IUpgradeData upgradeData) {
        if (upgradeData instanceof ItemChemicalToChemicalUpgradeData) {
            ItemChemicalToChemicalUpgradeData data = (ItemChemicalToChemicalUpgradeData)upgradeData;
            super.parseUpgradeData(provider, upgradeData);
            this.injectTank.deserializeNBT(provider, data.inputTank.serializeNBT(provider));
            this.chemicalInputSlot.deserializeNBT(provider, data.chemicalSlot.serializeNBT(provider));
            System.arraycopy(data.usedSoFar, 0, this.usedSoFar, 0, data.usedSoFar.length);
        } else {
            Mekanism.logger.warn("Unhandled upgrade data.", new Throwable());
        }
    }

    @Nullable
    public IUpgradeData getUpgradeData(HolderLookup.Provider provider) {
        return new ItemChemicalToChemicalUpgradeData(provider, this.redstone, this.getControlType(), (IEnergyContainer)this.getEnergyContainer(), this.progress, this.usedSoFar, this.energySlot, this.chemicalInputSlot, this.inputItemSlots, this.injectTank, this.outputChemicalTanks, this.isSorting(), this.getComponents());
    }

    public void dump() {
        this.injectTank.setEmpty();
    }
}

