/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekmm.api.recipes.basic;

import com.jerry.mekmm.api.recipes.MoreMachineRecipeSerializers;
import com.jerry.mekmm.api.recipes.RecyclerRecipe;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.recipes.ingredients.ItemStackIngredient;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import org.jetbrains.annotations.Contract;

@NothingNullByDefault
public class BasicRecyclerRecipe
extends RecyclerRecipe {
    private final ItemStackIngredient input;
    private final ItemStack chanceOutput;
    private final double chance;

    public BasicRecyclerRecipe(ItemStackIngredient input, ItemStack chanceOutput, double chance) {
        this.input = Objects.requireNonNull(input, "Input cannot be null.");
        Objects.requireNonNull(chanceOutput, "Output cannot be null.");
        if (chanceOutput.isEmpty()) {
            throw new IllegalArgumentException("Output cannot be null.");
        }
        if (chance < 0.0 || chance > 1.0) {
            throw new IllegalArgumentException("Output chance must be at least zero and at most one.");
        }
        this.chanceOutput = chanceOutput.copy();
        this.chance = chance;
    }

    @Override
    public boolean test(ItemStack stack) {
        return this.input.test(stack);
    }

    @Override
    @Contract(value="_ -> new")
    public RecyclerRecipe.ChanceOutput getOutput(ItemStack input) {
        return new BasicChanceOutput(this.chance > 0.0 ? RANDOM.nextDouble() : 0.0);
    }

    public ItemStack getChanceOutputRaw() {
        return this.chanceOutput;
    }

    @Override
    public List<ItemStack> getChanceOutputDefinition() {
        return this.chanceOutput.isEmpty() ? Collections.emptyList() : Collections.singletonList(this.chanceOutput);
    }

    @Override
    public double getOutputChance() {
        return this.chance;
    }

    @Override
    public ItemStackIngredient getInput() {
        return this.input;
    }

    public RecipeSerializer<BasicRecyclerRecipe> getSerializer() {
        return (RecipeSerializer)MoreMachineRecipeSerializers.RECYCLER.get();
    }

    public class BasicChanceOutput
    implements RecyclerRecipe.ChanceOutput {
        protected final double rand;

        protected BasicChanceOutput(double rand) {
            this.rand = rand;
        }

        @Override
        public ItemStack getMaxChanceOutput() {
            return BasicRecyclerRecipe.this.chance > 0.0 ? BasicRecyclerRecipe.this.chanceOutput.copy() : ItemStack.EMPTY;
        }

        @Override
        public ItemStack getChanceOutput() {
            if (this.rand <= BasicRecyclerRecipe.this.chance) {
                return BasicRecyclerRecipe.this.chanceOutput.copy();
            }
            return ItemStack.EMPTY;
        }

        @Override
        public ItemStack nextChanceOutput() {
            double rand;
            if (BasicRecyclerRecipe.this.chance > 0.0 && (rand = RANDOM.nextDouble()) <= BasicRecyclerRecipe.this.chance) {
                return BasicRecyclerRecipe.this.chanceOutput.copy();
            }
            return ItemStack.EMPTY;
        }
    }
}

