/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekmm.client.gui.machine;

import com.jerry.mekmm.common.MMLang;
import com.jerry.mekmm.common.tile.machine.TileEntityAmbientGasCollector;
import java.util.ArrayList;
import mekanism.api.chemical.ChemicalStack;
import mekanism.client.gui.GuiMekanismTile;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.GuiInnerScreen;
import mekanism.client.gui.element.bar.GuiVerticalPowerBar;
import mekanism.client.gui.element.gauge.GaugeType;
import mekanism.client.gui.element.gauge.GuiChemicalGauge;
import mekanism.client.gui.element.tab.GuiEnergyTab;
import mekanism.common.MekanismLang;
import mekanism.common.capabilities.energy.MachineEnergyContainer;
import mekanism.common.inventory.container.tile.MekanismTileContainer;
import mekanism.common.inventory.warning.WarningTracker;
import mekanism.common.util.text.EnergyDisplay;
import mekanism.common.util.text.TextUtils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import org.jetbrains.annotations.NotNull;

public class GuiAmbientGasCollector
extends GuiMekanismTile<TileEntityAmbientGasCollector, MekanismTileContainer<TileEntityAmbientGasCollector>> {
    public GuiAmbientGasCollector(MekanismTileContainer<TileEntityAmbientGasCollector> container, Inventory inv, Component title) {
        super(container, inv, title);
        this.titleLabelY = 5;
        this.inventoryLabelY += 2;
        this.dynamicSlots = true;
    }

    protected void addGuiElements() {
        super.addGuiElements();
        this.addRenderableWidget((GuiElement)new GuiInnerScreen((IGuiWrapper)this, 54, 23, 80, 42, () -> {
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(EnergyDisplay.of(((TileEntityAmbientGasCollector)this.tile).getEnergyContainer()).getTextComponent());
            if (((TileEntityAmbientGasCollector)this.tile).getNotBlocking()) {
                list.add(MMLang.NO_BLOCKING.translate());
            } else {
                list.add(MMLang.IS_BLOCKING.translate());
            }
            ChemicalStack chemicalStack = ((TileEntityAmbientGasCollector)this.tile).chemicalTank.getStack();
            if (chemicalStack.isEmpty()) {
                ChemicalStack fallBack = ((TileEntityAmbientGasCollector)this.tile).getActiveType();
                if (fallBack.isEmpty()) {
                    list.add(MekanismLang.NO_CHEMICAL.translate());
                } else {
                    list.add(fallBack.getTextComponent());
                }
            } else {
                list.add(MekanismLang.GENERIC_STORED_MB.translate(new Object[]{chemicalStack, TextUtils.format((long)chemicalStack.getAmount())}));
            }
            return list;
        }));
        ((GuiVerticalPowerBar)this.addRenderableWidget((GuiElement)new GuiVerticalPowerBar((IGuiWrapper)this, ((TileEntityAmbientGasCollector)this.tile).getEnergyContainer(), 164, 15))).warning(WarningTracker.WarningType.NOT_ENOUGH_ENERGY, () -> {
            MachineEnergyContainer<TileEntityAmbientGasCollector> energyContainer = ((TileEntityAmbientGasCollector)this.tile).getEnergyContainer();
            return energyContainer.getEnergyPerTick() > energyContainer.getEnergy();
        });
        ((GuiChemicalGauge)this.addRenderableWidget((GuiElement)new GuiChemicalGauge(() -> ((TileEntityAmbientGasCollector)this.tile).chemicalTank, () -> ((TileEntityAmbientGasCollector)this.tile).getChemicalTanks(null), GaugeType.STANDARD, (IGuiWrapper)this, 6, 13))).warning(WarningTracker.WarningType.NO_SPACE_IN_OUTPUT, () -> ((TileEntityAmbientGasCollector)this.tile).chemicalTank.getNeeded() < (long)((TileEntityAmbientGasCollector)this.tile).estimateIncrementAmount());
        this.addRenderableWidget((GuiElement)new GuiEnergyTab((IGuiWrapper)this, ((TileEntityAmbientGasCollector)this.tile).getEnergyContainer(), ((TileEntityAmbientGasCollector)this.tile)::usedEnergy));
    }

    protected void drawForegroundText(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY) {
        this.renderTitleText(guiGraphics);
        this.renderInventoryText(guiGraphics);
        super.drawForegroundText(guiGraphics, mouseX, mouseY);
    }
}

