/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekmm.client.recipe_viewer;

import com.jerry.mekmm.api.recipes.basic.BasicFluidChemicalToFluidRecipe;
import com.jerry.mekmm.api.recipes.basic.MMBasicChemicalChemicalToChemicalRecipe;
import com.jerry.mekmm.api.recipes.basic.MMBasicItemStackChemicalToItemStackRecipe;
import com.jerry.mekmm.common.registries.MMChemicals;
import com.jerry.mekmm.common.tile.machine.TileEntityChemicalReplicator;
import com.jerry.mekmm.common.tile.machine.TileEntityFluidReplicator;
import com.jerry.mekmm.common.tile.machine.TileEntityReplicator;
import java.util.HashMap;
import java.util.Map;
import mekanism.api.MekanismAPI;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.client.recipe_viewer.RecipeViewerUtils;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;

public class MMRecipeViewerUtils {
    private MMRecipeViewerUtils() {
    }

    public static Map<ResourceLocation, MMBasicItemStackChemicalToItemStackRecipe> getItemReplicatorRecipes() {
        HashMap<ResourceLocation, MMBasicItemStackChemicalToItemStackRecipe> replicator = new HashMap<ResourceLocation, MMBasicItemStackChemicalToItemStackRecipe>();
        for (Map.Entry entry : BuiltInRegistries.ITEM.entrySet()) {
            MMBasicItemStackChemicalToItemStackRecipe recipe = TileEntityReplicator.getRecipe(((Item)entry.getValue()).getDefaultInstance(), MMChemicals.UU_MATTER.asStack(1L));
            if (recipe == null) continue;
            replicator.put(RecipeViewerUtils.synthetic((ResourceLocation)((ResourceKey)entry.getKey()).location(), (String)"replicator", (String)"mekmm"), recipe);
        }
        return replicator;
    }

    public static Map<ResourceLocation, BasicFluidChemicalToFluidRecipe> getFluidReplicatorRecipes() {
        HashMap<ResourceLocation, BasicFluidChemicalToFluidRecipe> replicator = new HashMap<ResourceLocation, BasicFluidChemicalToFluidRecipe>();
        for (Map.Entry entry : BuiltInRegistries.FLUID.entrySet()) {
            BasicFluidChemicalToFluidRecipe recipe = TileEntityFluidReplicator.getRecipe(new FluidStack((Fluid)entry.getValue(), 1), MMChemicals.UU_MATTER.asStack(1L));
            if (recipe == null) continue;
            replicator.put(RecipeViewerUtils.synthetic((ResourceLocation)((ResourceKey)entry.getKey()).location(), (String)"replicator", (String)"mekmm"), recipe);
        }
        return replicator;
    }

    public static Map<ResourceLocation, MMBasicChemicalChemicalToChemicalRecipe> getChemicalReplicatorRecipes() {
        HashMap<ResourceLocation, MMBasicChemicalChemicalToChemicalRecipe> replicator = new HashMap<ResourceLocation, MMBasicChemicalChemicalToChemicalRecipe>();
        for (Map.Entry entry : MekanismAPI.CHEMICAL_REGISTRY.entrySet()) {
            MMBasicChemicalChemicalToChemicalRecipe recipe = TileEntityChemicalReplicator.getRecipe(new ChemicalStack(MekanismAPI.CHEMICAL_REGISTRY.wrapAsHolder((Object)((Chemical)entry.getValue())), 1L), MMChemicals.UU_MATTER.asStack(1L));
            if (recipe == null) continue;
            replicator.put(RecipeViewerUtils.synthetic((ResourceLocation)((ResourceKey)entry.getKey()).location(), (String)"replicator", (String)"mekmm"), recipe);
        }
        return replicator;
    }
}

