/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekmm.common.tile.factory;

import com.jerry.mekmm.common.block.attribute.MMAttributeFactoryType;
import com.jerry.mekmm.common.content.blocktype.MMFactoryType;
import com.jerry.mekmm.common.inventory.slot.MMFactoryInputInventorySlot;
import com.jerry.mekmm.common.util.MMUtils;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import java.util.function.ToIntBiFunction;
import mekanism.api.Action;
import mekanism.api.IContentsListener;
import mekanism.api.Upgrade;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.recipes.MekanismRecipe;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.common.CommonWorldTickHandler;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.capabilities.energy.MachineEnergyContainer;
import mekanism.common.capabilities.holder.energy.EnergyContainerHelper;
import mekanism.common.capabilities.holder.energy.IEnergyContainerHolder;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.integration.computer.ComputerException;
import mekanism.common.integration.computer.SpecialComputerMethodWrapper;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.integration.computer.annotation.WrappingComputerMethod;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.sync.ISyncableData;
import mekanism.common.inventory.container.sync.SyncableBoolean;
import mekanism.common.inventory.container.sync.SyncableInt;
import mekanism.common.inventory.container.sync.SyncableLong;
import mekanism.common.inventory.slot.EnergyInventorySlot;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.recipe.lookup.IRecipeLookupHandler;
import mekanism.common.recipe.lookup.monitor.FactoryRecipeCacheLookupMonitor;
import mekanism.common.registries.MekanismDataComponents;
import mekanism.common.tier.FactoryTier;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.component.ITileComponent;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.tile.component.config.ConfigInfo;
import mekanism.common.tile.component.config.DataType;
import mekanism.common.tile.component.config.slot.ISlotInfo;
import mekanism.common.tile.component.config.slot.InventorySlotInfo;
import mekanism.common.tile.interfaces.ISideConfiguration;
import mekanism.common.tile.interfaces.IUpgradeTile;
import mekanism.common.tile.prefab.TileEntityConfigurableMachine;
import mekanism.common.tile.prefab.TileEntityRecipeMachine;
import mekanism.common.upgrade.IUpgradeData;
import mekanism.common.upgrade.MachineUpgradeData;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NBTUtils;
import mekanism.common.util.UpgradeUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.util.ItemStackMap;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MMTileEntityFactory<RECIPE extends MekanismRecipe<?>>
extends TileEntityConfigurableMachine
implements IRecipeLookupHandler<RECIPE> {
    protected static final int BASE_TICKS_REQUIRED = 200;
    protected FactoryRecipeCacheLookupMonitor<RECIPE>[] recipeCacheLookupMonitors;
    protected BooleanSupplier[] recheckAllRecipeErrors;
    protected final ErrorTracker errorTracker;
    private final boolean[] activeStates;
    protected ProcessInfo[] processInfoSlots;
    public FactoryTier tier;
    public final int[] progress;
    private int ticksRequired = 200;
    private int operationsPerTick = 1;
    private boolean sorting;
    private boolean sortingNeeded = true;
    private long lastUsage = 0L;
    @NotNull
    protected final MMFactoryType type;
    protected MachineEnergyContainer<MMTileEntityFactory<?>> energyContainer;
    protected final List<IInventorySlot> inputSlots;
    protected final List<IInventorySlot> outputSlots;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getEnergyItem"}, docPlaceholder="energy slot")
    EnergyInventorySlot energySlot;

    protected MMTileEntityFactory(Holder<Block> blockProvider, BlockPos pos, BlockState state, List<CachedRecipe.OperationTracker.RecipeError> errorTypes, Set<CachedRecipe.OperationTracker.RecipeError> globalErrorTypes) {
        super(blockProvider, pos, state);
        ConfigInfo itemConfig;
        this.type = ((MMAttributeFactoryType)Attribute.getOrThrow(blockProvider, MMAttributeFactoryType.class)).getMMFactoryType();
        this.inputSlots = new ArrayList<IInventorySlot>();
        this.outputSlots = new ArrayList<IInventorySlot>();
        for (ProcessInfo info : this.processInfoSlots) {
            this.inputSlots.add((IInventorySlot)info.inputSlot());
            this.outputSlots.add(info.outputSlot());
            if (info.secondaryOutputSlot() == null) continue;
            this.outputSlots.add(info.secondaryOutputSlot());
        }
        this.configComponent.setupItemIOConfig(this.inputSlots, this.outputSlots, (IInventorySlot)this.energySlot, false);
        IInventorySlot extraSlot = this.getExtraSlot();
        if (extraSlot != null && (itemConfig = this.configComponent.getConfig(TransmissionType.ITEM)) != null) {
            itemConfig.addSlotInfo(DataType.EXTRA, (ISlotInfo)new InventorySlotInfo(true, true, new IInventorySlot[]{extraSlot}));
        }
        this.configComponent.setupInputConfig(TransmissionType.ENERGY, this.energyContainer);
        this.ejectorComponent = new TileComponentEjector((TileEntityMekanism)this);
        this.ejectorComponent.setOutputData(this.configComponent, new TransmissionType[]{TransmissionType.ITEM});
        this.progress = new int[this.tier.processes];
        this.activeStates = new boolean[this.tier.processes];
        this.recheckAllRecipeErrors = new BooleanSupplier[this.tier.processes];
        for (int i = 0; i < this.recheckAllRecipeErrors.length; ++i) {
            this.recheckAllRecipeErrors[i] = TileEntityRecipeMachine.shouldRecheckAllErrors((TileEntityMekanism)this);
        }
        this.errorTracker = new ErrorTracker(errorTypes, globalErrorTypes, this.tier.processes);
    }

    protected IContentsListener markAllMonitorsChanged(IContentsListener listener) {
        return () -> {
            listener.onContentsChanged();
            for (FactoryRecipeCacheLookupMonitor<RECIPE> cacheLookupMonitor : this.recipeCacheLookupMonitors) {
                cacheLookupMonitor.onChange();
            }
        };
    }

    protected void presetVariables() {
        super.presetVariables();
        this.tier = (FactoryTier)Attribute.getTier((Holder)this.getBlockHolder(), FactoryTier.class);
        Runnable setSortingNeeded = () -> {
            this.sortingNeeded = true;
        };
        this.recipeCacheLookupMonitors = new FactoryRecipeCacheLookupMonitor[this.tier.processes];
        for (int i = 0; i < this.recipeCacheLookupMonitors.length; ++i) {
            this.recipeCacheLookupMonitors[i] = new FactoryRecipeCacheLookupMonitor((IRecipeLookupHandler)this, i, setSortingNeeded);
        }
    }

    @NotNull
    protected IEnergyContainerHolder getInitialEnergyContainers(IContentsListener listener) {
        EnergyContainerHelper builder = EnergyContainerHelper.forSideWithConfig((ISideConfiguration)this);
        this.energyContainer = MachineEnergyContainer.input((TileEntityMekanism)this, () -> {
            listener.onContentsChanged();
            for (FactoryRecipeCacheLookupMonitor<RECIPE> cacheLookupMonitor : this.recipeCacheLookupMonitors) {
                cacheLookupMonitor.unpause();
            }
        });
        builder.addContainer((IEnergyContainer)this.energyContainer);
        return builder.build();
    }

    @NotNull
    protected IInventorySlotHolder getInitialInventory(IContentsListener listener) {
        InventorySlotHelper builder = InventorySlotHelper.forSideWithConfig((ISideConfiguration)this);
        this.addSlots(builder, listener, () -> {
            listener.onContentsChanged();
            this.sortingNeeded = true;
        });
        this.energySlot = EnergyInventorySlot.fillOrConvert(this.energyContainer, () -> ((MMTileEntityFactory)this).getLevel(), (IContentsListener)listener, (int)7, (int)13);
        builder.addSlot((IInventorySlot)this.energySlot);
        return builder.build();
    }

    protected abstract void addSlots(InventorySlotHelper var1, IContentsListener var2, IContentsListener var3);

    @Nullable
    protected IInventorySlot getExtraSlot() {
        return null;
    }

    public MMFactoryType getMMFactoryType() {
        return this.type;
    }

    protected boolean onUpdateServer() {
        boolean sendUpdatePacket = super.onUpdateServer();
        this.energySlot.fillContainerOrConvert();
        this.handleSecondaryFuel();
        if (this.sortingNeeded && this.isSorting()) {
            this.sortingNeeded = false;
            this.sortInventory();
        } else if (!this.sortingNeeded && CommonWorldTickHandler.flushTagAndRecipeCaches) {
            this.sortingNeeded = true;
        }
        long prev = this.energyContainer.getEnergy();
        for (int i = 0; i < this.recipeCacheLookupMonitors.length; ++i) {
            if (this.recipeCacheLookupMonitors[i].updateAndProcess()) continue;
            this.activeStates[i] = false;
        }
        boolean isActive = false;
        for (boolean state : this.activeStates) {
            if (!state) continue;
            isActive = true;
            break;
        }
        this.setActive(isActive);
        this.lastUsage = isActive ? prev - this.energyContainer.getEnergy() : 0L;
        return sendUpdatePacket;
    }

    public boolean inputProducesOutput(int process, @NotNull ItemStack fallbackInput, @NotNull IInventorySlot outputSlot, @Nullable IInventorySlot secondaryOutputSlot, boolean updateCache) {
        return outputSlot.isEmpty() || this.getRecipeForInput(process, fallbackInput, outputSlot, secondaryOutputSlot, updateCache) != null;
    }

    @Contract(value="null, _ -> false")
    protected abstract boolean isCachedRecipeValid(@Nullable CachedRecipe<RECIPE> var1, @NotNull ItemStack var2);

    @Nullable
    protected RECIPE getRecipeForInput(int process, @NotNull ItemStack fallbackInput, @NotNull IInventorySlot outputSlot, @Nullable IInventorySlot secondaryOutputSlot, boolean updateCache) {
        CachedRecipe<RECIPE> cached;
        if (!CommonWorldTickHandler.flushTagAndRecipeCaches && this.isCachedRecipeValid(cached = this.getCachedRecipe(process), fallbackInput)) {
            return (RECIPE)cached.getRecipe();
        }
        RECIPE foundRecipe = this.findRecipe(process, fallbackInput, outputSlot, secondaryOutputSlot);
        if (foundRecipe == null) {
            return null;
        }
        if (updateCache) {
            this.recipeCacheLookupMonitors[process].updateCachedRecipe(foundRecipe);
        }
        return foundRecipe;
    }

    @Nullable
    protected abstract RECIPE findRecipe(int var1, @NotNull ItemStack var2, @NotNull IInventorySlot var3, @Nullable IInventorySlot var4);

    protected abstract int getNeededInput(RECIPE var1, ItemStack var2);

    @Nullable
    private CachedRecipe<RECIPE> getCachedRecipe(int cacheIndex) {
        return this.recipeCacheLookupMonitors[cacheIndex].getCachedRecipe(cacheIndex);
    }

    public BooleanSupplier getWarningCheck(CachedRecipe.OperationTracker.RecipeError error, int processIndex) {
        return this.errorTracker.getWarningCheck(error, processIndex);
    }

    public void clearRecipeErrors(int cacheIndex) {
        Arrays.fill(this.errorTracker.trackedErrors[cacheIndex], false);
    }

    protected void setActiveState(boolean state, int cacheIndex) {
        this.activeStates[cacheIndex] = state;
    }

    protected void handleSecondaryFuel() {
    }

    public abstract boolean isItemValidForSlot(@NotNull ItemStack var1);

    public abstract boolean isValidInputItem(@NotNull ItemStack var1);

    public int getProgress(int cacheIndex) {
        return this.progress[cacheIndex];
    }

    public int getSavedOperatingTicks(int cacheIndex) {
        return this.getProgress(cacheIndex);
    }

    public double getScaledProgress(int i, int process) {
        return (double)this.getProgress(process) * (double)i / (double)this.ticksRequired;
    }

    public void toggleSorting() {
        this.sorting = !this.isSorting();
        this.markForSave();
    }

    @ComputerMethod(nameOverride="isAutoSortEnabled")
    public boolean isSorting() {
        return this.sorting;
    }

    @ComputerMethod(nameOverride="getEnergyUsage", methodDescription="Get the energy used in the last tick by the machine")
    public long getLastUsage() {
        return this.lastUsage;
    }

    @ComputerMethod(methodDescription="Total number of ticks it takes currently for the recipe to complete")
    public int getTicksRequired() {
        return this.ticksRequired;
    }

    public int getOperationsPerTick() {
        return this.operationsPerTick;
    }

    public void loadAdditional(@NotNull CompoundTag nbt, @NotNull HolderLookup.Provider provider) {
        super.loadAdditional(nbt, provider);
        if (nbt.contains("progress", 11)) {
            int[] savedProgress = nbt.getIntArray("progress");
            if (this.tier.processes != savedProgress.length) {
                Arrays.fill(this.progress, 0);
            }
            for (int i = 0; i < this.tier.processes && i < savedProgress.length; ++i) {
                this.progress[i] = savedProgress[i];
            }
        }
    }

    public void saveAdditional(@NotNull CompoundTag nbtTags, @NotNull HolderLookup.Provider provider) {
        super.saveAdditional(nbtTags, provider);
        nbtTags.putIntArray("progress", Arrays.copyOf(this.progress, this.progress.length));
    }

    public void writeSustainedData(HolderLookup.Provider provider, CompoundTag data) {
        super.writeSustainedData(provider, data);
        data.putBoolean("sorting", this.isSorting());
    }

    public void readSustainedData(HolderLookup.Provider provider, @NotNull CompoundTag data) {
        super.readSustainedData(provider, data);
        NBTUtils.setBooleanIfPresent((CompoundTag)data, (String)"sorting", value -> {
            this.sorting = value;
        });
    }

    protected void collectImplicitComponents(@NotNull DataComponentMap.Builder builder) {
        super.collectImplicitComponents(builder);
        builder.set((Supplier)MekanismDataComponents.SORTING, (Object)this.isSorting());
    }

    protected void applyImplicitComponents(@NotNull BlockEntity.DataComponentInput input) {
        super.applyImplicitComponents(input);
        this.sorting = (Boolean)input.getOrDefault((Supplier)MekanismDataComponents.SORTING, (Object)this.sorting);
    }

    public void recalculateUpgrades(Upgrade upgrade) {
        super.recalculateUpgrades(upgrade);
        if (upgrade == Upgrade.SPEED) {
            this.ticksRequired = MekanismUtils.getTicks((IUpgradeTile)this, (int)200);
            this.operationsPerTick = MekanismUtils.getOperationsPerTick((IUpgradeTile)this, (int)200, (int)1);
        }
    }

    @NotNull
    public List<Component> getInfo(@NotNull Upgrade upgrade) {
        return UpgradeUtils.getMultScaledInfo((IUpgradeTile)this, (Upgrade)upgrade);
    }

    public boolean isConfigurationDataCompatible(Block blockType) {
        return super.isConfigurationDataCompatible(blockType) || MMUtils.isSameMMTypeFactory((Holder<Block>)this.getBlockHolder(), blockType);
    }

    public boolean hasSecondaryResourceBar() {
        return false;
    }

    public MachineEnergyContainer<MMTileEntityFactory<?>> getEnergyContainer() {
        return this.energyContainer;
    }

    public void addContainerTrackers(MekanismContainer container) {
        super.addContainerTrackers(container);
        container.trackArray(this.progress);
        this.errorTracker.track(container);
        container.track((ISyncableData)SyncableLong.create(this::getLastUsage, value -> {
            this.lastUsage = value;
        }));
        container.track((ISyncableData)SyncableBoolean.create(this::isSorting, value -> {
            this.sorting = value;
        }));
        container.track((ISyncableData)SyncableInt.create(this::getTicksRequired, value -> {
            this.ticksRequired = value;
        }));
    }

    public void parseUpgradeData(HolderLookup.Provider provider, @NotNull IUpgradeData upgradeData) {
        if (upgradeData instanceof MachineUpgradeData) {
            int i;
            MachineUpgradeData data = (MachineUpgradeData)upgradeData;
            this.redstone = data.redstone;
            this.setControlType(data.controlType);
            this.getEnergyContainer().setEnergy(data.energyContainer.getEnergy());
            this.sorting = data.sorting;
            this.energySlot.deserializeNBT(provider, data.energySlot.serializeNBT(provider));
            System.arraycopy(data.progress, 0, this.progress, 0, data.progress.length);
            for (i = 0; i < data.inputSlots.size(); ++i) {
                this.inputSlots.get(i).deserializeNBT(provider, (Tag)((IInventorySlot)data.inputSlots.get(i)).serializeNBT(provider));
            }
            for (i = 0; i < data.outputSlots.size(); ++i) {
                this.outputSlots.get(i).setStack(((IInventorySlot)data.outputSlots.get(i)).getStack());
            }
            for (ITileComponent component : this.getComponents()) {
                component.read(data.components, provider);
            }
        } else {
            super.parseUpgradeData(provider, upgradeData);
        }
    }

    protected void validateValidProcess(int process) throws ComputerException {
        if (process < 0 || process >= this.progress.length) {
            throw new ComputerException("Process: '%d' is out of bounds, as this factory only has '%d' processes (zero indexed).", new Object[]{process, this.progress.length});
        }
    }

    @ComputerMethod(requiresPublicSecurity=true)
    void setAutoSort(boolean enabled) throws ComputerException {
        this.validateSecurityIsPublic();
        if (this.sorting != enabled) {
            this.sorting = enabled;
            this.markForSave();
        }
    }

    @ComputerMethod
    int getRecipeProgress(int process) throws ComputerException {
        this.validateValidProcess(process);
        return this.getProgress(process);
    }

    @ComputerMethod
    ItemStack getInput(int process) throws ComputerException {
        this.validateValidProcess(process);
        return this.processInfoSlots[process].inputSlot().getStack();
    }

    @ComputerMethod
    ItemStack getOutput(int process) throws ComputerException {
        this.validateValidProcess(process);
        return this.processInfoSlots[process].outputSlot().getStack();
    }

    private void sortInventory() {
        Map processes = ItemStackMap.createTypeAndTagMap();
        ArrayList<ProcessInfo> emptyProcesses = new ArrayList<ProcessInfo>();
        for (ProcessInfo processInfo : this.processInfoSlots) {
            CachedRecipe<RECIPE> cachedRecipe;
            MMFactoryInputInventorySlot inputSlot = processInfo.inputSlot();
            if (inputSlot.isEmpty()) {
                emptyProcesses.add(processInfo);
                continue;
            }
            ItemStack inputStack = inputSlot.getStack();
            RecipeProcessInfo recipeProcessInfo = processes.computeIfAbsent(inputStack, i -> new RecipeProcessInfo());
            recipeProcessInfo.processes.add(processInfo);
            recipeProcessInfo.totalCount += inputStack.getCount();
            if (recipeProcessInfo.lazyMinPerSlot != null || CommonWorldTickHandler.flushTagAndRecipeCaches || !this.isCachedRecipeValid(cachedRecipe = this.getCachedRecipe(processInfo.process()), inputStack)) continue;
            recipeProcessInfo.item = inputStack;
            recipeProcessInfo.recipe = cachedRecipe.getRecipe();
            recipeProcessInfo.lazyMinPerSlot = (info, factory) -> factory.getNeededInput(info.recipe, (ItemStack)info.item);
        }
        if (processes.isEmpty()) {
            return;
        }
        for (Map.Entry entry : processes.entrySet()) {
            RecipeProcessInfo recipeProcessInfo = (RecipeProcessInfo)entry.getValue();
            if (recipeProcessInfo.lazyMinPerSlot != null) continue;
            recipeProcessInfo.item = entry.getKey();
            recipeProcessInfo.lazyMinPerSlot = (info, factory) -> {
                ItemStack item = (ItemStack)info.item;
                ItemStack largerInput = item.copyWithCount(Math.min(item.getMaxStackSize(), info.totalCount));
                ProcessInfo processInfo = info.processes.getFirst();
                info.recipe = factory.getRecipeForInput(processInfo.process(), largerInput, processInfo.outputSlot(), processInfo.secondaryOutputSlot(), true);
                if (info.recipe != null) {
                    return factory.getNeededInput(info.recipe, largerInput);
                }
                return 1;
            };
        }
        if (!emptyProcesses.isEmpty()) {
            this.addEmptySlotsAsTargets(processes, emptyProcesses);
        }
        this.distributeItems(processes);
    }

    private void addEmptySlotsAsTargets(Map<ItemStack, RecipeProcessInfo<RECIPE>> processes, List<ProcessInfo> emptyProcesses) {
        for (Map.Entry<ItemStack, RecipeProcessInfo<RECIPE>> entry : processes.entrySet()) {
            int processCount;
            RecipeProcessInfo<RECIPE> recipeProcessInfo = entry.getValue();
            int minPerSlot = recipeProcessInfo.getMinPerSlot(this);
            int maxSlots = recipeProcessInfo.totalCount / minPerSlot;
            if (maxSlots <= 1 || maxSlots <= (processCount = recipeProcessInfo.processes.size())) continue;
            ItemStack sourceStack = entry.getKey();
            int emptyToAdd = maxSlots - processCount;
            int added = 0;
            ArrayList<ProcessInfo> toRemove = new ArrayList<ProcessInfo>();
            for (ProcessInfo emptyProcess : emptyProcesses) {
                if (!this.inputProducesOutput(emptyProcess.process(), sourceStack, emptyProcess.outputSlot(), emptyProcess.secondaryOutputSlot(), true)) continue;
                recipeProcessInfo.processes.add(emptyProcess);
                toRemove.add(emptyProcess);
                if (++added < emptyToAdd) continue;
                break;
            }
            emptyProcesses.removeAll(toRemove);
            if (!emptyProcesses.isEmpty()) continue;
            break;
        }
    }

    private void distributeItems(Map<ItemStack, RecipeProcessInfo<RECIPE>> processes) {
        for (Map.Entry<ItemStack, RecipeProcessInfo<RECIPE>> entry : processes.entrySet()) {
            ItemStack item;
            int maxStackSize;
            int numberPerSlot;
            RecipeProcessInfo<RECIPE> recipeProcessInfo = entry.getValue();
            int processCount = recipeProcessInfo.processes.size();
            if (processCount == 1 || (numberPerSlot = recipeProcessInfo.totalCount / processCount) == (maxStackSize = (item = entry.getKey()).getMaxStackSize())) continue;
            int remainder = recipeProcessInfo.totalCount % processCount;
            int minPerSlot = recipeProcessInfo.getMinPerSlot(this);
            if (minPerSlot > 1) {
                int perSlotRemainder = numberPerSlot % minPerSlot;
                if (perSlotRemainder > 0) {
                    numberPerSlot -= perSlotRemainder;
                    remainder += perSlotRemainder * processCount;
                }
                if (numberPerSlot + minPerSlot > maxStackSize) {
                    minPerSlot = maxStackSize - numberPerSlot;
                }
            }
            for (int i = 0; i < processCount; ++i) {
                ProcessInfo processInfo = recipeProcessInfo.processes.get(i);
                MMFactoryInputInventorySlot inputSlot = processInfo.inputSlot();
                int sizeForSlot = numberPerSlot;
                if (remainder > 0) {
                    if (remainder > minPerSlot) {
                        sizeForSlot += minPerSlot;
                        remainder -= minPerSlot;
                    } else {
                        sizeForSlot += remainder;
                        remainder = 0;
                    }
                }
                if (inputSlot.isEmpty()) {
                    if (sizeForSlot <= 0) continue;
                    inputSlot.setStackUnchecked(item.copyWithCount(sizeForSlot));
                    continue;
                }
                if (sizeForSlot == 0) {
                    inputSlot.setEmpty();
                    continue;
                }
                if (inputSlot.getCount() == sizeForSlot) continue;
                MekanismUtils.logMismatchedStackSize((long)sizeForSlot, (long)inputSlot.setStackSize(sizeForSlot, Action.EXECUTE));
            }
        }
    }

    public record ProcessInfo(int process, @NotNull MMFactoryInputInventorySlot inputSlot, @NotNull IInventorySlot outputSlot, @Nullable IInventorySlot secondaryOutputSlot) {
    }

    protected static class ErrorTracker {
        private final List<CachedRecipe.OperationTracker.RecipeError> errorTypes;
        private final IntSet globalTypes;
        private final boolean[][] trackedErrors;
        private final int processes;

        public ErrorTracker(List<CachedRecipe.OperationTracker.RecipeError> errorTypes, Set<CachedRecipe.OperationTracker.RecipeError> globalErrorTypes, int processes) {
            this.errorTypes = List.copyOf(errorTypes);
            this.globalTypes = new IntArraySet(globalErrorTypes.size());
            for (int i = 0; i < this.errorTypes.size(); ++i) {
                CachedRecipe.OperationTracker.RecipeError error = this.errorTypes.get(i);
                if (!globalErrorTypes.contains(error)) continue;
                this.globalTypes.add(i);
            }
            this.processes = processes;
            this.trackedErrors = new boolean[this.processes][];
            int errors = this.errorTypes.size();
            for (int i = 0; i < this.trackedErrors.length; ++i) {
                this.trackedErrors[i] = new boolean[errors];
            }
        }

        private void track(MekanismContainer container) {
            container.trackArray(this.trackedErrors);
        }

        public void onErrorsChanged(Set<CachedRecipe.OperationTracker.RecipeError> errors, int processIndex) {
            boolean[] processTrackedErrors = this.trackedErrors[processIndex];
            for (int i = 0; i < processTrackedErrors.length; ++i) {
                processTrackedErrors[i] = errors.contains(this.errorTypes.get(i));
            }
        }

        private BooleanSupplier getWarningCheck(CachedRecipe.OperationTracker.RecipeError error, int processIndex) {
            int errorIndex;
            if (processIndex >= 0 && processIndex < this.processes && (errorIndex = this.errorTypes.indexOf(error)) >= 0) {
                if (this.globalTypes.contains(errorIndex)) {
                    return () -> {
                        for (boolean[] tracked : this.trackedErrors) {
                            if (!tracked[errorIndex]) continue;
                            return true;
                        }
                        return false;
                    };
                }
                return () -> this.trackedErrors[processIndex][errorIndex];
            }
            return () -> false;
        }
    }

    private static class RecipeProcessInfo<RECIPE extends MekanismRecipe<?>> {
        private final List<ProcessInfo> processes = new ArrayList<ProcessInfo>();
        @Nullable
        private ToIntBiFunction<RecipeProcessInfo<RECIPE>, MMTileEntityFactory<RECIPE>> lazyMinPerSlot;
        private Object item;
        private RECIPE recipe;
        private int minPerSlot = 1;
        private int totalCount;

        private RecipeProcessInfo() {
        }

        public int getMinPerSlot(MMTileEntityFactory<RECIPE> factory) {
            if (this.lazyMinPerSlot != null) {
                this.minPerSlot = Math.max(1, this.lazyMinPerSlot.applyAsInt(this, factory));
                this.lazyMinPerSlot = null;
            }
            return this.minPerSlot;
        }
    }
}

