/*
 * Decompiled with CFR 0.152.
 */
package com.breakinblocks.beer.network;

import com.breakinblocks.beer.Beer;
import com.breakinblocks.beer.event.ItemModifierHandler;
import io.netty.buffer.ByteBuf;
import java.util.function.IntFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.util.ByIdMap;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record ApplyItemModifierPacket(BlockPos pos, ItemModifierHandler.ModifierType modifierType, boolean increase, boolean success, int rangeX, int rangeY, int rangeZ) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ApplyItemModifierPacket> TYPE = new CustomPacketPayload.Type(Beer.rl("apply_item_modifier"));
    public static final StreamCodec<ByteBuf, ApplyItemModifierPacket> STREAM_CODEC = new StreamCodec<ByteBuf, ApplyItemModifierPacket>(){

        public ApplyItemModifierPacket decode(ByteBuf buffer) {
            BlockPos pos = (BlockPos)BlockPos.STREAM_CODEC.decode((Object)buffer);
            ItemModifierHandler.ModifierType modifierType = ModifierTypeStreamCodec.INSTANCE.decode(buffer);
            boolean increase = buffer.readBoolean();
            boolean success = buffer.readBoolean();
            int rangeX = buffer.readInt();
            int rangeY = buffer.readInt();
            int rangeZ = buffer.readInt();
            return new ApplyItemModifierPacket(pos, modifierType, increase, success, rangeX, rangeY, rangeZ);
        }

        public void encode(ByteBuf buffer, ApplyItemModifierPacket packet) {
            BlockPos.STREAM_CODEC.encode((Object)buffer, (Object)packet.pos());
            ModifierTypeStreamCodec.INSTANCE.encode(buffer, packet.modifierType());
            buffer.writeBoolean(packet.increase());
            buffer.writeBoolean(packet.success());
            buffer.writeInt(packet.rangeX());
            buffer.writeInt(packet.rangeY());
            buffer.writeInt(packet.rangeZ());
        }
    };

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(ApplyItemModifierPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Level level = context.player().level();
            if (level.isClientSide()) {
                ApplyItemModifierPacket.handleClient(packet, level);
            }
        });
    }

    private static void handleClient(ApplyItemModifierPacket packet, Level level) {
    }

    private static class ModifierTypeStreamCodec
    implements StreamCodec<ByteBuf, ItemModifierHandler.ModifierType> {
        public static final ModifierTypeStreamCodec INSTANCE = new ModifierTypeStreamCodec();
        private static final IntFunction<ItemModifierHandler.ModifierType> BY_ID = ByIdMap.continuous(Enum::ordinal, (Object[])ItemModifierHandler.ModifierType.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO);

        private ModifierTypeStreamCodec() {
        }

        public ItemModifierHandler.ModifierType decode(ByteBuf buffer) {
            byte id = buffer.readByte();
            return BY_ID.apply(id);
        }

        public void encode(ByteBuf buffer, ItemModifierHandler.ModifierType modifierType) {
            buffer.writeByte(modifierType.ordinal());
        }
    }
}

