/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.toastcontrol;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.shadowsoffire.toastcontrol.ControlledDeque;
import dev.shadowsoffire.toastcontrol.ToastConfig;
import dev.shadowsoffire.toastcontrol.ToastControl;
import java.util.ArrayDeque;
import java.util.BitSet;
import java.util.Deque;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.util.Mth;

public class BetterToastComponent
extends ToastComponent {
    private Deque<BetterToastInstance<?>> topDownList = new ArrayDeque();

    public BetterToastComponent() {
        super(Minecraft.getInstance());
        this.queued = new ControlledDeque();
        this.occupiedSlots = new BitSet((Integer)ToastConfig.INSTANCE.toastCount.get());
    }

    public void render(GuiGraphics gfx) {
        if (!this.minecraft.options.hideGui) {
            int width = gfx.guiWidth();
            this.visible.removeIf(inst -> {
                if (inst != null && inst.render(width, gfx)) {
                    this.occupiedSlots.clear(inst.index, inst.index + inst.slotCount);
                    this.topDownList.remove(inst);
                    return true;
                }
                return false;
            });
            if (!this.queued.isEmpty() && this.freeSlots() > 0) {
                this.queued.removeIf(toast -> {
                    int count = toast.slotCount();
                    int freeIdx = this.findFreeIndex(count);
                    if (freeIdx != -1) {
                        BetterToastInstance inst = new BetterToastInstance(this, toast, freeIdx, count);
                        this.visible.add(inst);
                        this.occupiedSlots.set(freeIdx, freeIdx + count);
                        this.topDownList.forEach(t -> {
                            t.animationTime = -1L;
                        });
                        this.topDownList.addFirst(inst);
                        return true;
                    }
                    return false;
                });
            }
        }
    }

    public void clear() {
        super.clear();
        this.topDownList.clear();
    }

    public int findFreeIndex(int pSlotCount) {
        if (this.freeSlots() >= pSlotCount) {
            int i = 0;
            for (int j = 0; j < (Integer)ToastConfig.INSTANCE.toastCount.get(); ++j) {
                if (this.occupiedSlots.get(j)) {
                    i = 0;
                    continue;
                }
                if (++i != pSlotCount) continue;
                return j + 1 - i;
            }
        }
        return -1;
    }

    public int freeSlots() {
        return (Integer)ToastConfig.INSTANCE.toastCount.get() - this.occupiedSlots.cardinality();
    }

    public class BetterToastInstance<T extends Toast>
    extends ToastComponent.ToastInstance<T> {
        protected int forcedShowTime;
        final /* synthetic */ BetterToastComponent this$0;

        /*
         * WARNING - Possible parameter corruption
         */
        protected BetterToastInstance(T toast, int index, int slotCount) {
            this.this$0 = (BetterToastComponent)this$0;
            super((ToastComponent)this$0, toast, index, slotCount);
            this.forcedShowTime = 0;
            ToastControl.tracker.add(this);
        }

        public boolean tick() {
            return this.forcedShowTime++ > (Integer)ToastConfig.INSTANCE.forceTime.get();
        }

        protected float getVisibility(long sysTime) {
            float f = Mth.clamp((float)((float)(sysTime - this.animationTime) / 600.0f), (float)0.0f, (float)1.0f);
            f *= f;
            if (((Boolean)ToastConfig.INSTANCE.noSlide.get()).booleanValue()) {
                return 1.0f;
            }
            return this.forcedShowTime > (Integer)ToastConfig.INSTANCE.forceTime.get() && this.visibility == Toast.Visibility.HIDE ? 1.0f - f : f;
        }

        public boolean render(int scaledWidth, GuiGraphics gfx) {
            long sysTime = Util.getMillis();
            int trueIdx = 0;
            if (((Boolean)ToastConfig.INSTANCE.topDown.get()).booleanValue()) {
                for (BetterToastInstance<?> next : this.this$0.topDownList) {
                    if (next == this) break;
                    ++trueIdx;
                }
            }
            if (this.animationTime == -1L) {
                this.animationTime = sysTime;
                this.visibility.playSound(this.this$0.minecraft.getSoundManager());
            }
            if (this.visibility == Toast.Visibility.SHOW && this.getVisibility(sysTime) != 1.0f) {
                this.visibleTime = sysTime;
            }
            PoseStack stack = gfx.pose();
            stack.pushPose();
            if (((Boolean)ToastConfig.INSTANCE.topDown.get()).booleanValue()) {
                int x = (Boolean)ToastConfig.INSTANCE.startLeft.get() != false ? 0 : scaledWidth - this.toast.width();
                stack.translate((float)x, (float)((trueIdx - 1) * this.toast.height()) + (float)this.toast.height() * this.getVisibility(sysTime), (float)(800 + this.index));
            } else if (((Boolean)ToastConfig.INSTANCE.startLeft.get()).booleanValue()) {
                stack.translate((float)(-this.toast.width()) + (float)this.toast.width() * this.getVisibility(sysTime), (float)(this.index * this.toast.height()), (float)(800 + this.index));
            } else {
                stack.translate((float)scaledWidth - (float)this.toast.width() * this.getVisibility(sysTime), (float)(this.index * this.toast.height()), (float)(800 + this.index));
            }
            stack.translate((float)((Integer)ToastConfig.INSTANCE.offsetX.get()).intValue(), (float)((Integer)ToastConfig.INSTANCE.offsetY.get()).intValue(), 0.0f);
            RenderSystem.enableBlend();
            Toast.Visibility visibility = Toast.Visibility.SHOW;
            if (this.animationTime != -1L) {
                visibility = this.toast.render(gfx, (ToastComponent)this.this$0, sysTime - this.visibleTime);
            }
            RenderSystem.disableBlend();
            stack.popPose();
            if (this.forcedShowTime > (Integer)ToastConfig.INSTANCE.forceTime.get() && visibility != this.visibility) {
                this.animationTime = sysTime - (long)((1.0f - this.getVisibility(sysTime)) * 600.0f);
                this.visibility = visibility;
                this.visibility.playSound(this.this$0.minecraft.getSoundManager());
            }
            return this.forcedShowTime > (Integer)ToastConfig.INSTANCE.forceTime.get() && this.visibility == Toast.Visibility.HIDE && sysTime - this.animationTime > 600L;
        }
    }
}

