/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.colour;

import codechicken.lib.colour.ColourRGBA;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableTable;
import io.netty.buffer.ByteBuf;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.stream.Stream;
import net.covers1624.quack.collection.FastStream;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public enum EnumColour implements StringRepresentable
{
    WHITE("white", "c:dyes/white", "c:wools/white", "item.minecraft.firework_star.white", 0xFFFFFF),
    ORANGE("orange", "c:dyes/orange", "c:wools/orange", "item.minecraft.firework_star.orange", 12608256),
    MAGENTA("magenta", "c:dyes/magenta", "c:wools/magenta", "item.minecraft.firework_star.magenta", 11868853),
    LIGHT_BLUE("light_blue", "c:dyes/light_blue", "c:wools/light_blue", "item.minecraft.firework_star.light_blue", 7308529),
    YELLOW("yellow", "c:dyes/yellow", "c:wools/yellow", "item.minecraft.firework_star.yellow", 0xBFBF00),
    LIME("lime", "c:dyes/lime", "c:wools/lime", "item.minecraft.firework_star.lime", 7074048),
    PINK("pink", "c:dyes/pink", "c:wools/pink", "item.minecraft.firework_star.pink", 15812213),
    GRAY("gray", "c:dyes/gray", "c:wools/gray", "item.minecraft.firework_star.gray", 0x535353),
    LIGHT_GRAY("light_gray", "c:dyes/light_gray", "c:wools/light_gray", "item.minecraft.firework_star.light_gray", 0x939393),
    CYAN("cyan", "c:dyes/cyan", "c:wools/cyan", "item.minecraft.firework_star.cyan", 34695),
    PURPLE("purple", "c:dyes/purple", "c:wools/purple", "item.minecraft.firework_star.purple", 6160576),
    BLUE("blue", "c:dyes/blue", "c:wools/blue", "item.minecraft.firework_star.blue", 1250240),
    BROWN("brown", "c:dyes/brown", "c:wools/brown", "item.minecraft.firework_star.brown", 5187328),
    GREEN("green", "c:dyes/green", "c:wools/green", "item.minecraft.firework_star.green", 558848),
    RED("red", "c:dyes/red", "c:wools/red", "item.minecraft.firework_star.red", 10620678),
    BLACK("black", "c:dyes/black", "c:wools/black", "item.minecraft.firework_star.black", 0x1F1F1F);

    public static final StringRepresentable.EnumCodec<EnumColour> CODEC;
    public static final IntFunction<EnumColour> BY_ID;
    public static final StreamCodec<ByteBuf, EnumColour> STREAM_CODEC;
    private final String name;
    private final ResourceLocation dyeTagName;
    private final ResourceLocation woolTagName;
    private final String unlocalizedName;
    private final int rgb;
    private static final ImmutableTable<EnumColour, EnumColour, EnumColour> mixMap;
    private static final Map<String, EnumColour> nameLookup;
    private static final Map<ResourceLocation, EnumColour> dyeTagLookup;
    private static final Map<ResourceLocation, EnumColour> woolTagLookup;

    private EnumColour(String name, String dyeTagName, String woolTagName, String unlocalizedName, int rgb) {
        this.name = name;
        this.dyeTagName = ResourceLocation.parse((String)dyeTagName);
        this.woolTagName = ResourceLocation.parse((String)woolTagName);
        this.unlocalizedName = unlocalizedName;
        this.rgb = rgb;
    }

    public String getSerializedName() {
        return this.name;
    }

    public ResourceLocation getDyeTagName() {
        return this.dyeTagName;
    }

    public ResourceLocation getWoolTagName() {
        return this.woolTagName;
    }

    public String getUnlocalizedName() {
        return this.unlocalizedName;
    }

    public String getLocalizedName() {
        return I18n.get((String)this.getUnlocalizedName(), (Object[])new Object[0]);
    }

    public int getWoolMeta() {
        return this.ordinal();
    }

    public int getDyeMeta() {
        return 15 - this.ordinal();
    }

    public int rgba() {
        return this.rgba(255);
    }

    public int rgba(int alpha) {
        return this.rgb << 8 | alpha & 0xFF;
    }

    public int argb() {
        return this.argb(255);
    }

    public int argb(int alpha) {
        return (alpha & 0xFF) << 24 | this.rgb;
    }

    public int rgb() {
        return this.rgb;
    }

    public float rF() {
        return (float)(this.rgb >> 16 & 0xFF) / 255.0f;
    }

    public float gF() {
        return (float)(this.rgb >> 8 & 0xFF) / 255.0f;
    }

    public float bF() {
        return (float)(this.rgb & 0xFF) / 255.0f;
    }

    public ColourRGBA getColour() {
        return this.getColour(255);
    }

    public ColourRGBA getColour(int alpha) {
        return new ColourRGBA(this.rgba(alpha));
    }

    @Nullable
    public EnumColour mix(EnumColour b) {
        return EnumColour.mix(this, b);
    }

    @Nullable
    public static EnumColour mix(EnumColour a, EnumColour b) {
        if (a == b) {
            return a;
        }
        return (EnumColour)((Object)mixMap.get((Object)a, (Object)b));
    }

    public static EnumColour fromWoolMeta(int id) {
        return EnumColour.values()[id];
    }

    public static EnumColour fromDyeMeta(int id) {
        return EnumColour.values()[15 - id];
    }

    @Nullable
    public static EnumColour fromDyeTag(ResourceLocation tag) {
        return dyeTagLookup.get(tag);
    }

    @Nullable
    public static EnumColour fromWoolTag(ResourceLocation tag) {
        return woolTagLookup.get(tag);
    }

    @Nullable
    public static EnumColour fromDyeStack(ItemStack stack) {
        return (EnumColour)((Object)FastStream.of((Stream)stack.getTags()).map(TagKey::location).map(dyeTagLookup::get).filter(Objects::nonNull).firstOrDefault());
    }

    @Nullable
    public static EnumColour fromWoolStack(ItemStack stack) {
        return (EnumColour)((Object)FastStream.of((Stream)stack.getTags()).map(TagKey::location).map(woolTagLookup::get).filter(Objects::nonNull).firstOrDefault());
    }

    @Nullable
    public static EnumColour fromName(String name) {
        return nameLookup.get(name);
    }

    static {
        CODEC = StringRepresentable.fromEnum(EnumColour::values);
        BY_ID = ByIdMap.continuous(Enum::ordinal, (Object[])EnumColour.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.WRAP);
        STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, Enum::ordinal);
        nameLookup = FastStream.of((Object[])EnumColour.values()).toMap(e -> e.name, Function.identity());
        dyeTagLookup = FastStream.of((Object[])EnumColour.values()).toMap(e -> e.dyeTagName, Function.identity());
        woolTagLookup = FastStream.of((Object[])EnumColour.values()).toMap(e -> e.woolTagName, Function.identity());
        HashBasedTable tmp = HashBasedTable.create();
        tmp.put((Object)YELLOW, (Object)RED, (Object)ORANGE);
        tmp.put((Object)PINK, (Object)PURPLE, (Object)MAGENTA);
        tmp.put((Object)WHITE, (Object)BLUE, (Object)LIGHT_BLUE);
        tmp.put((Object)WHITE, (Object)GREEN, (Object)LIME);
        tmp.put((Object)WHITE, (Object)RED, (Object)PINK);
        tmp.put((Object)WHITE, (Object)BLACK, (Object)GRAY);
        tmp.put((Object)WHITE, (Object)GRAY, (Object)LIGHT_GRAY);
        tmp.put((Object)BLUE, (Object)GREEN, (Object)CYAN);
        tmp.put((Object)BLUE, (Object)RED, (Object)PURPLE);
        tmp.put((Object)ORANGE, (Object)RED, (Object)BROWN);
        tmp.put((Object)YELLOW, (Object)BLUE, (Object)GREEN);
        ImmutableTable.Builder builder = ImmutableTable.builder();
        tmp.cellSet().forEach(e -> {
            builder.put((Object)((EnumColour)((Object)((Object)e.getRowKey()))), (Object)((EnumColour)((Object)((Object)e.getColumnKey()))), (Object)((EnumColour)((Object)((Object)e.getValue()))));
            builder.put((Object)((EnumColour)((Object)((Object)e.getColumnKey()))), (Object)((EnumColour)((Object)((Object)e.getRowKey()))), (Object)((EnumColour)((Object)((Object)e.getValue()))));
        });
        mixMap = builder.build();
    }
}

