/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.gui.modular.elements;

import codechicken.lib.gui.modular.ModularGui;
import codechicken.lib.gui.modular.elements.GuiButton;
import codechicken.lib.gui.modular.elements.GuiElement;
import codechicken.lib.gui.modular.elements.GuiRectangle;
import codechicken.lib.gui.modular.lib.Constraints;
import codechicken.lib.gui.modular.lib.geometry.Constraint;
import codechicken.lib.gui.modular.lib.geometry.GeoParam;
import codechicken.lib.gui.modular.lib.geometry.GuiParent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public class GuiContextMenu
extends GuiElement<GuiContextMenu> {
    private BiFunction<GuiContextMenu, Supplier<Component>, GuiButton> buttonBuilder = (menu, label) -> (GuiButton)GuiButton.flatColourButton(menu, label, hover -> hover != false ? -12100758 : -15395563).constrain(GeoParam.HEIGHT, Constraint.literal(12.0));
    private final Map<Supplier<Component>, Runnable> options = new LinkedHashMap<Supplier<Component>, Runnable>();
    private final Map<Supplier<Component>, Supplier<List<Component>>> tooltips = new HashMap<Supplier<Component>, Supplier<List<Component>>>();
    private final List<GuiButton> buttons = new ArrayList<GuiButton>();
    private boolean closeOnItemClicked = true;
    private boolean closeOnOutsideClick = true;
    private boolean actionOnClick = false;
    private boolean pressed = false;

    public GuiContextMenu(ModularGui gui) {
        super(gui.getRoot());
        this.jeiExclude();
        this.setOpaque(true);
    }

    public static GuiContextMenu tooltipStyleMenu(GuiParent<?> parent) {
        GuiContextMenu menu = new GuiContextMenu(parent.getModularGui());
        Constraints.bind(GuiRectangle.toolTipBackground(menu), menu);
        return menu;
    }

    public GuiContextMenu setCloseOnItemClicked(boolean closeOnItemClicked) {
        this.closeOnItemClicked = closeOnItemClicked;
        return this;
    }

    public GuiContextMenu setCloseOnOutsideClick(boolean closeOnOutsideClick) {
        this.closeOnOutsideClick = closeOnOutsideClick;
        return this;
    }

    public GuiContextMenu actionOnClick() {
        this.actionOnClick = true;
        this.rebuildButtons();
        return this;
    }

    public GuiContextMenu setButtonBuilder(BiFunction<GuiContextMenu, Supplier<Component>, GuiButton> buttonBuilder) {
        this.buttonBuilder = buttonBuilder;
        return this;
    }

    public GuiContextMenu addOption(Supplier<Component> label, Runnable action) {
        this.options.put(label, action);
        this.rebuildButtons();
        return this;
    }

    public GuiContextMenu addOption(Supplier<Component> label, Supplier<List<Component>> tooltip, Runnable action) {
        this.options.put(label, action);
        this.tooltips.put(label, tooltip);
        this.rebuildButtons();
        return this;
    }

    public GuiContextMenu addOption(Supplier<Component> label, List<Component> tooltip, Runnable action) {
        return this.addOption(label, () -> tooltip, action);
    }

    public GuiContextMenu addOption(Supplier<Component> label, Runnable action, Component ... tooltip) {
        return this.addOption(label, () -> List.of(tooltip), action);
    }

    private void rebuildButtons() {
        this.buttons.forEach(this::removeChild);
        this.buttons.clear();
        this.constrain(GeoParam.WIDTH, Constraint.dynamic(() -> (double)this.options.keySet().stream().mapToInt(e -> this.font().width((FormattedText)e.get())).max().orElse(0) + 6.0 + 4.0));
        double height = 3.0;
        for (Supplier<Component> label : this.options.keySet()) {
            Runnable action = this.options.get(label);
            GuiButton button = (GuiButton)((GuiButton)((GuiButton)this.buttonBuilder.apply(this, label).constrain(GeoParam.TOP, Constraint.relative(this.get(GeoParam.TOP), height))).constrain(GeoParam.LEFT, Constraint.relative(this.get(GeoParam.LEFT), 3.0))).constrain(GeoParam.RIGHT, Constraint.relative(this.get(GeoParam.RIGHT), -3.0));
            if (this.actionOnClick) {
                button.onClick(action);
            } else {
                button.onPress(action);
            }
            if (this.tooltips.containsKey(label)) {
                button.setTooltip((Supplier)this.tooltips.get(label));
            }
            button.getLabel().setScroll(false);
            this.buttons.add(button);
            height += button.ySize();
        }
        this.constrain(GeoParam.HEIGHT, Constraint.literal(height + 3.0));
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button, boolean consumed) {
        consumed = super.mouseClicked(mouseX, mouseY, button, consumed);
        this.pressed = this.isMouseOver();
        if (this.isMouseOver() || consumed) {
            if (this.actionOnClick) {
                if (consumed && this.closeOnItemClicked) {
                    this.close();
                }
                return true;
            }
        } else if (this.closeOnOutsideClick) {
            this.close();
            return true;
        }
        return consumed;
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int button, boolean consumed) {
        consumed = super.mouseReleased(mouseX, mouseY, button, consumed);
        if ((this.isMouseOver() || consumed) && !this.actionOnClick) {
            if (consumed && this.closeOnItemClicked && this.pressed) {
                this.close();
            }
            this.pressed = false;
            return true;
        }
        this.pressed = false;
        return consumed;
    }

    public void close() {
        this.getParent().removeChild(this);
    }

    public GuiContextMenu setNormalizedPos(double x, double y) {
        this.constrain(GeoParam.LEFT, Constraint.dynamic(() -> Math.min(Math.max(x, 0.0), (double)this.scaledScreenWidth() - this.xSize())));
        this.constrain(GeoParam.TOP, Constraint.dynamic(() -> Math.min(Math.max(y, 0.0), (double)this.scaledScreenHeight() - this.ySize())));
        return this;
    }
}

