/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.render.block;

import codechicken.lib.render.block.CCBlockRendererDispatcher;
import codechicken.lib.render.block.ICCBlockRenderer;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.fml.ModList;
import org.embeddedt.embeddium.api.BlockRendererRegistry;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@Deprecated(forRemoval=true)
@ApiStatus.ScheduledForRemoval(inVersion="mc 1.21.2+")
public class BlockRenderingRegistry {
    private static boolean initialized = false;
    private static final Map<Block, ICCBlockRenderer> blockRenderers = new HashMap<Block, ICCBlockRenderer>();
    private static final Map<Fluid, ICCBlockRenderer> fluidRenderers = new HashMap<Fluid, ICCBlockRenderer>();
    private static final List<ICCBlockRenderer> globalRenderers = new ArrayList<ICCBlockRenderer>();

    @OnlyIn(value=Dist.CLIENT)
    public static void init() {
        if (!initialized) {
            Minecraft mc = Minecraft.getInstance();
            BlockRenderDispatcher parentDispatcher = mc.getBlockRenderer();
            mc.blockRenderer = new CCBlockRendererDispatcher(parentDispatcher, mc.getBlockColors());
            initialized = true;
        }
        if (ModList.get().isLoaded("embeddium")) {
            EmbeddiumSupport.init();
        }
    }

    @Deprecated
    public static synchronized void registerRenderer(Block block, ICCBlockRenderer renderer) {
        ICCBlockRenderer prev = blockRenderers.get(block);
        if (prev != null) {
            throw new IllegalArgumentException("Renderer already registered for block. " + String.valueOf(BuiltInRegistries.BLOCK.getKey((Object)block)));
        }
        blockRenderers.put(block, renderer);
    }

    @Deprecated
    public static synchronized void registerRenderer(Fluid fluid, ICCBlockRenderer renderer) {
        ICCBlockRenderer prev = fluidRenderers.get(fluid);
        if (prev != null) {
            throw new IllegalArgumentException("Renderer already registered for fluid. " + String.valueOf(BuiltInRegistries.FLUID.getKey((Object)fluid)));
        }
        fluidRenderers.put(fluid, renderer);
    }

    @Deprecated
    public static synchronized void registerGlobalRenderer(ICCBlockRenderer renderer) {
        globalRenderers.add(renderer);
    }

    @Nullable
    static ICCBlockRenderer findFor(Block block, Predicate<ICCBlockRenderer> pred) {
        for (ICCBlockRenderer renderer : globalRenderers) {
            if (!pred.test(renderer)) continue;
            return renderer;
        }
        ICCBlockRenderer found = blockRenderers.get(block);
        if (found != null && pred.test(found)) {
            return found;
        }
        return null;
    }

    @Nullable
    static ICCBlockRenderer findFor(Fluid fluid, Predicate<ICCBlockRenderer> pred) {
        for (ICCBlockRenderer renderer : globalRenderers) {
            if (!pred.test(renderer)) continue;
            return renderer;
        }
        ICCBlockRenderer found = fluidRenderers.get(fluid);
        if (found != null && pred.test(found)) {
            return found;
        }
        return null;
    }

    private static class EmbeddiumSupport {
        private static final Map<ICCBlockRenderer, BlockRendererRegistry.Renderer> ADAPTERS = new ConcurrentHashMap<ICCBlockRenderer, BlockRendererRegistry.Renderer>();
        private static final ThreadLocal<PoseStack> POSE_STACK_CACHE = ThreadLocal.withInitial(PoseStack::new);

        private EmbeddiumSupport() {
        }

        private static BlockRendererRegistry.Renderer adapt(ICCBlockRenderer renderer) {
            return ADAPTERS.computeIfAbsent(renderer, e -> (ctx, random, consumer) -> {
                e.renderBlock(ctx.state(), ctx.pos(), (BlockAndTintGetter)ctx.world(), POSE_STACK_CACHE.get(), consumer, random, ctx.modelData(), ctx.renderLayer());
                return BlockRendererRegistry.RenderResult.OVERRIDE;
            });
        }

        public static void init() {
            BlockRendererRegistry.instance().registerRenderPopulator((resultList, ctx) -> {
                ICCBlockRenderer renderer = BlockRenderingRegistry.findFor(ctx.state().getBlock(), e -> e.canHandleBlock((BlockAndTintGetter)ctx.world(), ctx.pos(), ctx.state(), ctx.renderLayer()));
                if (renderer != null) {
                    resultList.add(EmbeddiumSupport.adapt(renderer));
                }
            });
        }
    }
}

