/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.minimotd.common.config;

import org.checkerframework.checker.nullness.qual.NonNull;
import xyz.jpenilla.minimotd.common.MiniMOTD;
import xyz.jpenilla.minimotd.common.config.ConfigLoader;
import xyz.jpenilla.minimotd.common.config.MiniMOTDConfig;
import xyz.jpenilla.minimotd.lib.org.spongepowered.configurate.ConfigurateException;

public final class ConfigManager {
    private final MiniMOTD<?> miniMOTD;
    private final ConfigLoader<MiniMOTDConfig> mainConfigLoader;
    private MiniMOTDConfig mainConfig;

    public ConfigManager(@NonNull MiniMOTD<?> miniMOTD) {
        this.miniMOTD = miniMOTD;
        this.mainConfigLoader = new ConfigLoader<MiniMOTDConfig>(MiniMOTDConfig.class, this.miniMOTD.dataDirectory().resolve("main.conf"), options -> options.header("MiniMOTD Main Configuration"));
    }

    public void loadConfigs() {
        try {
            this.mainConfig = this.mainConfigLoader.load();
            this.mainConfigLoader.save(this.mainConfig);
        }
        catch (ConfigurateException e) {
            throw new IllegalStateException("Failed to load config", e);
        }
    }

    public @NonNull MiniMOTDConfig mainConfig() {
        if (this.mainConfig == null) {
            throw new IllegalStateException("Config has not yet been loaded");
        }
        return this.mainConfig;
    }
}

