/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.minimotd.neoforge;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.nio.file.Path;
import javax.imageio.ImageIO;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.protocol.status.ServerStatus;
import net.minecraft.server.MinecraftServer;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.event.server.ServerStoppedEvent;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.jpenilla.minimotd.common.CommandHandler;
import xyz.jpenilla.minimotd.common.MiniMOTD;
import xyz.jpenilla.minimotd.common.MiniMOTDPlatform;
import xyz.jpenilla.minimotd.neoforge.access.ServerStatusFaviconAccess;
import xyz.jpenilla.minimotd.neoforge.util.ComponentConverter;

@Mod(value="minimotd_reforged")
public final class MiniMOTDNeoForge
implements MiniMOTDPlatform<ServerStatus.Favicon> {
    private static MiniMOTDNeoForge instance = null;
    private final Logger logger = LoggerFactory.getLogger(MiniMOTD.class);
    private final Path dataDirectory = FMLPaths.CONFIGDIR.get().resolve("MiniMOTD");
    private final MiniMOTD<ServerStatus.Favicon> miniMOTD;
    private MinecraftServer server;

    public MiniMOTDNeoForge() {
        if (FMLEnvironment.dist != Dist.DEDICATED_SERVER) {
            this.miniMOTD = null;
            return;
        }
        if (instance != null) {
            throw new IllegalStateException("Cannot create a second instance of " + this.getClass().getName());
        }
        instance = this;
        NeoForge.EVENT_BUS.register((Object)this);
        this.miniMOTD = new MiniMOTD<ServerStatus.Favicon>(this);
        this.miniMOTD.logger().info("Done initializing MiniMOTD");
    }

    public @NonNull MiniMOTD<// Could not load outer class - annotation placement on inner may be incorrect
    ServerStatus.Favicon> miniMOTD() {
        return this.miniMOTD;
    }

    @OnlyIn(value=Dist.DEDICATED_SERVER)
    @SubscribeEvent
    public void serverStarting(ServerStartingEvent event) {
        this.server = event.getServer();
    }

    @OnlyIn(value=Dist.DEDICATED_SERVER)
    @SubscribeEvent
    public void serverStopped(ServerStoppedEvent event) {
        this.server = null;
    }

    @OnlyIn(value=Dist.DEDICATED_SERVER)
    @SubscribeEvent
    public void registerCommand(RegisterCommandsEvent event) {
        CommandHandler handler = new CommandHandler(this.miniMOTD);
        final class WrappingExecutor
        implements Command<CommandSourceStack> {
            private final CommandHandler.Executor handler;

            WrappingExecutor(@NonNull MiniMOTDNeoForge this$0, CommandHandler.Executor handler) {
                this.handler = handler;
            }

            public int run(@NonNull CommandContext<CommandSourceStack> context) {
                this.handler.execute((text, success) -> {
                    CommandSourceStack source = (CommandSourceStack)context.getSource();
                    if (source.isSilent()) {
                        return;
                    }
                    if (success && source.source.acceptsSuccess()) {
                        source.sendSystemMessage(ComponentConverter.toNative(text, (HolderLookup.Provider)source.registryAccess()));
                    } else if (!success) {
                        source.sendFailure(ComponentConverter.toNative(text, (HolderLookup.Provider)source.registryAccess()));
                    }
                });
                return 1;
            }
        }
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"minimotd").requires(source -> source.hasPermission(4))).then(Commands.literal((String)"reload").executes((Command)new WrappingExecutor(this, handler::reload)))).then(Commands.literal((String)"about").executes((Command)new WrappingExecutor(this, handler::about)))).then(Commands.literal((String)"help").executes((Command)new WrappingExecutor(this, handler::help))));
    }

    public static @NonNull MiniMOTDNeoForge get() {
        return instance;
    }

    public @NonNull MinecraftServer requireServer() {
        if (this.server == null) {
            throw new IllegalStateException("Server requested before started");
        }
        return this.server;
    }

    @Override
    public @NonNull Path dataDirectory() {
        return this.dataDirectory;
    }

    @Override
    public @NonNull Logger logger() {
        return this.logger;
    }

    @Override
    public // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull ServerStatus.Favicon loadIcon(@NonNull BufferedImage bufferedImage) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)bufferedImage, "PNG", out);
        ServerStatus.Favicon favicon = new ServerStatus.Favicon(out.toByteArray());
        ((ServerStatusFaviconAccess)favicon).cacheEncodedIcon();
        return favicon;
    }
}

