/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.minimotd.neoforge.mixin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.protocol.status.ServerStatus;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.network.ServerStatusPacketListenerImpl;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import xyz.jpenilla.minimotd.common.MiniMOTD;
import xyz.jpenilla.minimotd.common.PingResponse;
import xyz.jpenilla.minimotd.common.config.MiniMOTDConfig;
import xyz.jpenilla.minimotd.neoforge.MiniMOTDNeoForge;
import xyz.jpenilla.minimotd.neoforge.util.ComponentConverter;
import xyz.jpenilla.minimotd.neoforge.util.MutableServerStatus;

@Mixin(value={ServerStatusPacketListenerImpl.class})
abstract class ServerStatusPacketListenerImplMixin {
    ServerStatusPacketListenerImplMixin() {
    }

    @Redirect(method={"handleStatusRequest"}, at=@At(value="FIELD", target="Lnet/minecraft/server/network/ServerStatusPacketListenerImpl;status:Lnet/minecraft/network/protocol/status/ServerStatus;"))
    public ServerStatus injectHandleStatusRequest(ServerStatusPacketListenerImpl instance) {
        try {
            MiniMOTDNeoForge miniMOTDForge = MiniMOTDNeoForge.get();
            MinecraftServer minecraftServer = miniMOTDForge.requireServer();
            ServerStatus vanillaStatus = Objects.requireNonNull(minecraftServer.getStatus(), "vanillaStatus");
            MiniMOTD<ServerStatus.Favicon> miniMOTD = miniMOTDForge.miniMOTD();
            MiniMOTDConfig config = miniMOTD.configManager().mainConfig();
            PingResponse<ServerStatus.Favicon> response = miniMOTD.createMOTD(config, minecraftServer.getPlayerCount(), vanillaStatus.players().map(ServerStatus.Players::max).orElseGet(() -> ((MinecraftServer)minecraftServer).getMaxPlayers()));
            MutableServerStatus modifiedStatus = new MutableServerStatus(vanillaStatus);
            response.motd(motd -> modifiedStatus.description(ComponentConverter.toNative(motd, (HolderLookup.Provider)MiniMOTDNeoForge.get().requireServer().registryAccess())));
            response.icon(favicon -> modifiedStatus.favicon(Optional.of(favicon)));
            if (response.hidePlayerCount()) {
                modifiedStatus.players(Optional.empty());
            } else {
                ArrayList players = new ArrayList(minecraftServer.getPlayerList().getPlayers());
                Collections.shuffle(players);
                List profiles = response.disablePlayerListHover() ? Collections.emptyList() : players.stream().map(Player::getGameProfile).limit(12L).toList();
                ServerStatus.Players newPlayers = new ServerStatus.Players(response.playerCount().maxPlayers(), response.playerCount().onlinePlayers(), profiles);
                modifiedStatus.players(Optional.of(newPlayers));
            }
            return modifiedStatus.toServerStatus();
        }
        catch (Exception e) {
            MiniMOTDNeoForge.get().logger().error("Error processing motd", (Throwable)e);
            throw e;
        }
    }

    @Redirect(method={"handleStatusRequest(Lnet/minecraft/network/protocol/status/ServerboundStatusRequestPacket;)V"}, at=@At(value="FIELD", target="Lnet/minecraft/server/network/ServerStatusPacketListenerImpl;statusCache:Ljava/lang/String;", remap=false))
    public String injectStatusJsonAccess(ServerStatusPacketListenerImpl instance) {
        return null;
    }
}

