/*
 * Decompiled with CFR 0.152.
 */
package com.cyanogen.cognition.block;

import com.cyanogen.cognition.block.ExperienceReceivingBlock;
import com.cyanogen.cognition.block_entities.MolecularMetamorpherEntity;
import com.cyanogen.cognition.gui.MolecularMetamorpherMenu;
import com.cyanogen.cognition.registries.RegisterBlockEntities;
import com.cyanogen.cognition.utils.ItemUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MolecularMetamorpherBlock
extends ExperienceReceivingBlock
implements EntityBlock {
    public MolecularMetamorpherBlock() {
        super(BlockBehaviour.Properties.of().strength(9.0f).destroyTime(1.2f).explosionResistance(9.0f).noOcclusion().sound(SoundType.METAL).requiresCorrectToolForDrops());
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        player.openMenu(this.getMenuProvider(state, level, pos), pos);
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    @Override
    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        ItemInteractionResult result = super.useItemOn(stack, state, level, pos, player, hand, hitResult);
        if (result == ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION) {
            player.openMenu(this.getMenuProvider(state, level, pos), pos);
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return result;
    }

    public VoxelShape wholeShape() {
        VoxelShape base = Shapes.create((AABB)new AABB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0));
        VoxelShape pedestal = Shapes.create((AABB)new AABB(0.125, 0.5, 0.125, 0.875, 0.625, 0.875));
        VoxelShape emitter = Shapes.create((AABB)new AABB(0.34375, 1.0625, 0.34375, 0.65625, 1.625, 0.65625));
        VoxelShape baseWhole = Shapes.join((VoxelShape)base, (VoxelShape)pedestal, (BooleanOp)BooleanOp.OR);
        return Shapes.join((VoxelShape)baseWhole, (VoxelShape)emitter, (BooleanOp)BooleanOp.OR);
    }

    public boolean collisionExtendsVertically(BlockState state, BlockGetter level, BlockPos pos, Entity collidingEntity) {
        return true;
    }

    public VoxelShape getInteractionShape(BlockState state, BlockGetter getter, BlockPos pos) {
        return this.wholeShape();
    }

    public VoxelShape getShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return this.wholeShape();
    }

    public int getLightEmission(BlockState state, BlockGetter getter, BlockPos pos) {
        MolecularMetamorpherEntity metamorpher;
        BlockEntity blockEntity = getter.getBlockEntity(pos);
        if (blockEntity instanceof MolecularMetamorpherEntity && (metamorpher = (MolecularMetamorpherEntity)blockEntity).isBusy()) {
            return 7;
        }
        return 0;
    }

    @NotNull
    public MenuProvider getMenuProvider(BlockState state, Level level, final BlockPos pos) {
        ItemStackHandler inputHandler = null;
        ItemStackHandler outputHandler = null;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof MolecularMetamorpherEntity) {
            MolecularMetamorpherEntity metamorpher = (MolecularMetamorpherEntity)blockEntity;
            inputHandler = metamorpher.getInputHandler();
            outputHandler = metamorpher.getOutputHandler();
        }
        final ItemStackHandler inputs = inputHandler;
        final ItemStackHandler output = outputHandler;
        return new MenuProvider(){

            public Component getDisplayName() {
                return Component.literal((String)"Molecular Metamorpher");
            }

            public AbstractContainerMenu createMenu(int containerId, Inventory inventory, Player player) {
                return new MolecularMetamorpherMenu(containerId, inventory, (IItemHandler)inputs, (IItemHandler)output, pos);
            }
        };
    }

    public void saveContentsToItem(Level level, BlockPos pos) {
        MolecularMetamorpherEntity metamorpher;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof MolecularMetamorpherEntity && !(metamorpher = (MolecularMetamorpherEntity)blockEntity).isEmpty() && super.getBlockItem() != null) {
            CompoundTag tag = ItemUtils.getCustomDataTag(this.getBlockItem());
            tag.putBoolean("isEmpty", false);
            ItemUtils.saveCustomDataTag(this.getBlockItem(), tag);
        }
    }

    @Override
    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        BlockState blockState = super.playerWillDestroy(level, pos, state, player);
        this.saveContentsToItem(level, pos);
        return blockState;
    }

    @Override
    public void onBlockExploded(BlockState state, Level level, BlockPos pos, Explosion explosion) {
        super.onBlockExploded(state, level, pos, explosion);
        this.saveContentsToItem(level, pos);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return blockEntityType == RegisterBlockEntities.MOLECULAR_METAMORPHER.get() ? MolecularMetamorpherEntity::tick : null;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return ((BlockEntityType)RegisterBlockEntities.MOLECULAR_METAMORPHER.get()).create(pos, state);
    }
}

