/*
 * Decompiled with CFR 0.152.
 */
package com.cyanogen.cognition.block_entities;

import com.cyanogen.cognition.block.LinearAcceleratorBlock;
import com.cyanogen.cognition.block_entities.AbstractAcceleratorEntity;
import com.cyanogen.cognition.registries.RegisterBlockEntities;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class LinearAcceleratorEntity
extends AbstractAcceleratorEntity {
    static double orbSpeed = 1.5;
    static double entitySpeed = 0.6;

    public LinearAcceleratorEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)RegisterBlockEntities.LINEAR_ACCELERATOR.get(), pos, state);
    }

    public static <T> void tick(Level level, BlockPos pos, BlockState state, T blockEntity) {
        if (blockEntity instanceof LinearAcceleratorEntity) {
            LinearAcceleratorEntity accelerator = (LinearAcceleratorEntity)((Object)blockEntity);
            if (!accelerator.redstoneEnabled || level.hasNeighborSignal(pos)) {
                if (!((Boolean)state.getValue((Property)LinearAcceleratorBlock.ACTIVE)).booleanValue()) {
                    state = (BlockState)state.setValue((Property)LinearAcceleratorBlock.ACTIVE, (Comparable)Boolean.valueOf(true));
                    level.setBlockAndUpdate(pos, state);
                }
                Direction facing = (Direction)state.getValue((Property)LinearAcceleratorBlock.FACING);
                int x = 0;
                int z = 0;
                switch (facing) {
                    case NORTH: {
                        z = -1;
                        break;
                    }
                    case SOUTH: {
                        z = 1;
                        break;
                    }
                    case EAST: {
                        x = 1;
                        break;
                    }
                    case WEST: {
                        x = -1;
                    }
                }
                float offset = 0.1f;
                AABB area = new AABB((double)((float)pos.getX() + offset), (double)(pos.getY() + 1), (double)((float)pos.getZ() + offset), (double)((float)(pos.getX() + 1) - offset), (double)(pos.getY() + 2), (double)((float)(pos.getZ() + 1) - offset));
                List list = level.getEntities(null, area);
                if (!list.isEmpty()) {
                    for (Entity entity : list) {
                        Player player;
                        boolean isShiftPlayer;
                        boolean bl = isShiftPlayer = entity instanceof Player && (player = (Player)entity).isShiftKeyDown();
                        if (entity instanceof ExperienceOrb) {
                            ExperienceOrb orb = (ExperienceOrb)entity;
                            orb.addDeltaMovement(new Vec3(orbSpeed * (double)x, 0.0, orbSpeed * (double)z));
                            continue;
                        }
                        if (isShiftPlayer) continue;
                        entity.addDeltaMovement(new Vec3(entitySpeed * (double)x, 0.0, entitySpeed * (double)z));
                    }
                }
            } else if (((Boolean)state.getValue((Property)LinearAcceleratorBlock.ACTIVE)).booleanValue()) {
                state = (BlockState)state.setValue((Property)LinearAcceleratorBlock.ACTIVE, (Comparable)Boolean.valueOf(false));
                level.setBlockAndUpdate(pos, state);
            }
        }
    }
}

