/*
 * Decompiled with CFR 0.152.
 */
package com.cyanogen.cognition.gui;

import com.cyanogen.cognition.block_entities.ExperienceObeliskEntity;
import com.cyanogen.cognition.gui.ExperienceObeliskMenu;
import com.cyanogen.cognition.gui.ExperienceObeliskScreen;
import com.cyanogen.cognition.network.experience_obelisk.UpdateRadius;
import com.cyanogen.cognition.network.shared.UpdateRedstone;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.PacketDistributor;

public class ExperienceObeliskOptionsScreen
extends Screen {
    public ExperienceObeliskMenu menu;
    public Level clientLevel;
    public final Inventory inventory;
    public final Component component;
    private final ResourceLocation texture = ResourceLocation.fromNamespaceAndPath((String)"cognition", (String)"textures/gui/screens/experience_obelisk.png");
    private final List<Button> buttons = new ArrayList<Button>();

    protected ExperienceObeliskOptionsScreen(ExperienceObeliskMenu menu, Inventory inventory, Component component) {
        super((Component)Component.literal((String)"Experience Obelisk"));
        this.menu = menu;
        this.clientLevel = menu.level;
        this.inventory = inventory;
        this.component = component;
    }

    public boolean isPauseScreen() {
        return false;
    }

    protected void init() {
        this.setupWidgetElements();
        super.init();
    }

    public void render(GuiGraphics gui, int mouseX, int mouseY, float partialTick) {
        BlockEntity blockEntity;
        this.renderTransparentBackground(gui);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.texture);
        int textureWidth = 256;
        int textureHeight = 256;
        int x = this.width / 2 - 88;
        int y = this.height / 2 - 83;
        gui.blit(this.texture, x, y, 0.0f, 0.0f, 176, 166, textureWidth, textureHeight);
        gui.drawCenteredString(this.font, (Component)Component.translatable((String)"title.cognition.experience_obelisk.settings"), this.width / 2, this.height / 2 - 76, 0xFFFFFF);
        gui.drawString(this.font, (Component)Component.translatable((String)"title.cognition.experience_obelisk.radius"), this.width / 2 - 77, this.height / 2 - 56, 0xFFFFFF);
        gui.drawString(this.font, (Component)Component.translatable((String)"title.cognition.experience_obelisk.redstone"), this.width / 2 - 77, this.height / 2 - 10, 0xFFFFFF);
        double radius = 2.5;
        boolean isRedstoneEnabled = false;
        BlockPos pos = this.menu.getBlockPos();
        if (pos != null && (blockEntity = this.clientLevel.getBlockEntity(pos)) instanceof ExperienceObeliskEntity) {
            ExperienceObeliskEntity obelisk = (ExperienceObeliskEntity)blockEntity;
            radius = obelisk.getRadius();
            isRedstoneEnabled = obelisk.isRedstoneEnabled();
        }
        this.clearWidgets();
        this.buttons.get(2).setMessage((Component)Component.literal((String)String.valueOf(radius)));
        if (isRedstoneEnabled) {
            this.buttons.get(4).setMessage((Component)Component.translatable((String)"button.cognition.experience_obelisk.enabled"));
        } else {
            this.buttons.get(4).setMessage((Component)Component.translatable((String)"button.cognition.experience_obelisk.ignored"));
        }
        this.loadWidgetElements();
        for (Renderable widget : this.renderables) {
            widget.render(gui, mouseX, mouseY, partialTick);
        }
    }

    private void loadWidgetElements() {
        if (!this.buttons.isEmpty()) {
            for (Button b : this.buttons) {
                b.setFocused(false);
                this.addRenderableWidget((GuiEventListener)b);
            }
        }
    }

    private void updateRadius(double change) {
        BlockPos pos = this.menu.getBlockPos();
        if (pos != null) {
            PacketDistributor.sendToServer((CustomPacketPayload)new UpdateRadius(pos, change), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    private void toggleRedstone() {
        BlockEntity blockEntity;
        BlockPos pos = this.menu.getBlockPos();
        if (pos != null && (blockEntity = this.clientLevel.getBlockEntity(pos)) instanceof ExperienceObeliskEntity) {
            ExperienceObeliskEntity obelisk = (ExperienceObeliskEntity)blockEntity;
            PacketDistributor.sendToServer((CustomPacketPayload)new UpdateRedstone(this.menu.getBlockPos(), !obelisk.isRedstoneEnabled()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    private void setupWidgetElements() {
        boolean isRedstoneEnabled;
        BlockEntity blockEntity;
        this.buttons.clear();
        int w = 50;
        int h = 20;
        int s = 2;
        int y1 = 43;
        int y2 = -3;
        double radius = 2.5;
        BlockPos pos = this.menu.getBlockPos();
        if (pos != null && (blockEntity = this.clientLevel.getBlockEntity(pos)) instanceof ExperienceObeliskEntity) {
            ExperienceObeliskEntity obelisk = (ExperienceObeliskEntity)blockEntity;
            radius = obelisk.getRadius();
            isRedstoneEnabled = obelisk.isRedstoneEnabled();
        } else {
            isRedstoneEnabled = false;
        }
        Style green = Style.EMPTY.withColor(4587355);
        Style red = Style.EMPTY.withColor(16729419);
        MutableComponent status = isRedstoneEnabled ? Component.translatable((String)"button.cognition.experience_obelisk.enabled") : Component.translatable((String)"button.cognition.experience_obelisk.ignored");
        Button back = Button.builder((Component)Component.translatable((String)"button.cognition.experience_obelisk.back"), onPress -> Minecraft.getInstance().setScreen((Screen)new ExperienceObeliskScreen(this.menu, this.inventory, this.component))).size(20, 20).pos(this.width / 2 + 91, this.height / 2 - 78).tooltip(Tooltip.create((Component)Component.translatable((String)"tooltip.cognition.experience_obelisk.back"))).build();
        Button decreaseRadius = Button.builder((Component)Component.literal((String)"-").setStyle(red), onPress -> this.updateRadius(-0.5)).size(26, h).pos(this.width / 2 - 56, this.height / 2 - y1).build();
        Button resetRadius = Button.builder((Component)Component.literal((String)String.valueOf(radius)), onPress -> this.updateRadius(0.0)).size(50, h).pos(this.width / 2 - 25, this.height / 2 - y1).tooltip(Tooltip.create((Component)Component.translatable((String)"tooltip.cognition.experience_obelisk.radius"))).build();
        Button increaseRadius = Button.builder((Component)Component.literal((String)"+").setStyle(green), onPress -> this.updateRadius(0.5)).size(26, h).pos(this.width / 2 + 30, this.height / 2 - y1).build();
        Button toggleRedstone = Button.builder((Component)status, onPress -> this.toggleRedstone()).size(w, h).pos(this.width / 2 - 25, this.height / 2 - y2).build();
        this.buttons.add(back);
        this.buttons.add(decreaseRadius);
        this.buttons.add(resetRadius);
        this.buttons.add(increaseRadius);
        this.buttons.add(toggleRedstone);
    }
}

