/*
 * Decompiled with CFR 0.152.
 */
package com.cyanogen.cognition.item;

import com.cyanogen.cognition.item.CognitiveToolset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;

public class CognitiveArmorset {
    public static final AttributeModifier ARMOR_RANGE = new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"cognition", (String)"armor_range"), 0.5, AttributeModifier.Operation.ADD_VALUE);
    public static ArmorMaterial COGNITIVE_ARMOR_MATERIAL = new ArmorMaterial(CognitiveArmorset.getDefenseForSlot(), 15, SoundEvents.ARMOR_EQUIP_NETHERITE, () -> CognitiveToolset.COGNITIVE_TIER.getRepairIngredient(), List.of(new ArmorMaterial.Layer(ResourceLocation.withDefaultNamespace((String)"cognitive"))), 1.0f, 0.0f);

    public static List<ItemAttributeModifiers.Entry> increasedReach(EquipmentSlotGroup slotGroup) {
        ArrayList<ItemAttributeModifiers.Entry> list = new ArrayList<ItemAttributeModifiers.Entry>();
        list.add(new ItemAttributeModifiers.Entry(Attributes.BLOCK_INTERACTION_RANGE, ARMOR_RANGE, slotGroup));
        list.add(new ItemAttributeModifiers.Entry(Attributes.ENTITY_INTERACTION_RANGE, ARMOR_RANGE, slotGroup));
        return list;
    }

    public static Map<ArmorItem.Type, Integer> getDefenseForSlot() {
        HashMap<ArmorItem.Type, Integer> map = new HashMap<ArmorItem.Type, Integer>();
        map.put(ArmorItem.Type.HELMET, 3);
        map.put(ArmorItem.Type.CHESTPLATE, 7);
        map.put(ArmorItem.Type.LEGGINGS, 6);
        map.put(ArmorItem.Type.BOOTS, 2);
        return map;
    }

    public static class ExtraAttributeArmorItem
    extends ArmorItem {
        private final List<ItemAttributeModifiers.Entry> extraModifiers;

        public ExtraAttributeArmorItem(Holder<ArmorMaterial> material, ArmorItem.Type type, List<ItemAttributeModifiers.Entry> extraModifiers, int maxDamage) {
            super(material, type, new Item.Properties().durability(maxDamage));
            this.extraModifiers = extraModifiers;
        }

        public int getDefaultMaxStackSize() {
            return 1;
        }

        public int getMaxStackSize(ItemStack stack) {
            return 1;
        }

        public ItemAttributeModifiers getDefaultAttributeModifiers() {
            List fromSuper = super.getDefaultAttributeModifiers().modifiers();
            ArrayList<ItemAttributeModifiers.Entry> modifierList = new ArrayList<ItemAttributeModifiers.Entry>(fromSuper);
            if (!(fromSuper.isEmpty() || this.extraModifiers.isEmpty() || fromSuper.contains(this.extraModifiers.getFirst()))) {
                modifierList.addAll(this.extraModifiers);
            }
            ItemAttributeModifiers.Builder builder = ItemAttributeModifiers.builder();
            for (ItemAttributeModifiers.Entry entry : modifierList) {
                builder.add(entry.attribute(), entry.modifier(), entry.slot());
            }
            return builder.build();
        }
    }
}

