/*
 * Decompiled with CFR 0.152.
 */
package com.cyanogen.cognition.saved_data;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;

public class MemoryTabletData
extends SavedData {
    private boolean hasLinkedObelisk = false;
    private BlockPos linkedObelisk = new BlockPos(0, 0, 0);
    private String dimension = "minecraft:overworld";
    private long experienceToRecover = 0L;

    public CompoundTag save(CompoundTag tag, HolderLookup.Provider provider) {
        tag.putBoolean("HasLinkedObelisk", this.hasLinkedObelisk);
        tag.putIntArray("LinkedObelisk", new int[]{this.linkedObelisk.getX(), this.linkedObelisk.getY(), this.linkedObelisk.getZ()});
        tag.putString("Dimension", this.dimension);
        tag.putLong("ExperienceToRecover", this.experienceToRecover);
        return tag;
    }

    public MemoryTabletData load(CompoundTag tag) {
        this.hasLinkedObelisk = tag.getBoolean("HasLinkedObelisk");
        int[] pos = tag.getIntArray("LinkedObelisk");
        this.linkedObelisk = new BlockPos(pos[0], pos[1], pos[2]);
        this.dimension = tag.getString("Dimension");
        this.experienceToRecover = tag.getLong("ExperienceToRecover");
        return this;
    }

    public static MemoryTabletData loadStatic(CompoundTag tag, HolderLookup.Provider provider) {
        MemoryTabletData data = new MemoryTabletData();
        return data.load(tag);
    }

    public void setLinkedObelisk(BlockPos pos, String dimension, boolean hasLinkedObelisk) {
        this.linkedObelisk = pos;
        this.dimension = dimension;
        this.hasLinkedObelisk = hasLinkedObelisk;
        this.setDirty();
    }

    public boolean hasLinkedObelisk() {
        return this.hasLinkedObelisk;
    }

    public BlockPos getLinkedObelisk() {
        return this.linkedObelisk;
    }

    public String getDimension() {
        return this.dimension;
    }

    public boolean dimensionMatches(Level level) {
        return level.dimension().location().toString().equals(this.dimension);
    }

    public void setExperienceToRecover(long points) {
        this.experienceToRecover = points;
        this.setDirty();
    }

    public long getExperienceToRecover() {
        return this.experienceToRecover;
    }

    public static SavedData.Factory<MemoryTabletData> factory(@Nullable MemoryTabletData data) {
        if (data != null) {
            return new SavedData.Factory(() -> data, MemoryTabletData::loadStatic);
        }
        return new SavedData.Factory(MemoryTabletData::new, MemoryTabletData::loadStatic);
    }

    @Nullable
    public static MemoryTabletData getFromStorage(Level level, String uuid) {
        if (level.getServer() != null) {
            DimensionDataStorage overworldStorage = level.getServer().overworld().getDataStorage();
            return (MemoryTabletData)overworldStorage.get(MemoryTabletData.factory(null), "memory_tablet_data_of_" + uuid);
        }
        return null;
    }

    @Nullable
    public static MemoryTabletData getFromStorage(Player player) {
        return MemoryTabletData.getFromStorage(player.level(), player.getStringUUID());
    }

    public static void createAndSaveToStorage(Level level, String uuid, MemoryTabletData data) {
        if (level.getServer() != null) {
            DimensionDataStorage overworldStorage = level.getServer().overworld().getDataStorage();
            overworldStorage.computeIfAbsent(MemoryTabletData.factory(data), "memory_tablet_data_of_" + uuid);
            overworldStorage.save();
        }
    }

    public static void createAndSaveToStorage(Player player, MemoryTabletData data) {
        MemoryTabletData.createAndSaveToStorage(player.level(), player.getStringUUID(), data);
    }

    public String toString() {
        return "[Memory Tablet Data] \nHasLinkedObelisk: " + this.hasLinkedObelisk + "\nLinkedObelisk: " + this.linkedObelisk.toShortString() + "\nDimension: " + this.dimension + "\nExperienceToRecover: " + this.experienceToRecover;
    }
}

