/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.client.screens;

import com.direwolf20.justdirethings.client.screens.basescreens.BaseMachineScreen;
import com.direwolf20.justdirethings.client.screens.standardbuttons.ToggleButtonFactory;
import com.direwolf20.justdirethings.client.screens.standardbuttons.ValueButtons;
import com.direwolf20.justdirethings.client.screens.widgets.GrayscaleButton;
import com.direwolf20.justdirethings.client.screens.widgets.NumberButton;
import com.direwolf20.justdirethings.client.screens.widgets.ToggleButton;
import com.direwolf20.justdirethings.common.blockentities.DropperT2BE;
import com.direwolf20.justdirethings.common.blockentities.basebe.AreaAffectingBE;
import com.direwolf20.justdirethings.common.blockentities.basebe.BaseMachineBE;
import com.direwolf20.justdirethings.common.containers.DropperT2Container;
import com.direwolf20.justdirethings.common.network.data.DirectionSettingPayload;
import com.direwolf20.justdirethings.common.network.data.DropperSettingPayload;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Inventory;
import net.neoforged.neoforge.network.PacketDistributor;

public class DropperT2Screen
extends BaseMachineScreen<DropperT2Container> {
    protected int dropCount;
    protected int pickupDelay;

    public DropperT2Screen(DropperT2Container container, Inventory inv, Component name) {
        super(container, inv, name);
        BaseMachineBE baseMachineBE = this.baseMachineBE;
        if (baseMachineBE instanceof DropperT2BE) {
            DropperT2BE dropper = (DropperT2BE)baseMachineBE;
            this.dropCount = dropper.dropCount;
            this.pickupDelay = dropper.pickupDelay;
        }
    }

    @Override
    public void addFilterButtons() {
        this.addRenderableWidget((GuiEventListener)ToggleButtonFactory.COMPARENBTBUTTON(this.getGuiLeft() + 8, this.topSectionTop + 62, this.filterData.compareNBT, b -> {
            this.filterData.compareNBT = !this.filterData.compareNBT;
            ((GrayscaleButton)b).toggleActive();
            this.saveSettings();
        }));
    }

    @Override
    public void addAreaButtons() {
        this.addRenderableWidget((GuiEventListener)ToggleButtonFactory.RENDERAREABUTTON(this.getGuiLeft() + 152, this.topSectionTop + 62, this.renderArea, b -> {
            this.renderArea = !this.renderArea;
            ((GrayscaleButton)b).toggleActive();
            this.saveSettings();
        }));
        this.valueButtonsList.add(new ValueButtons(this.getGuiLeft() + 25, this.topSectionTop + 12, this.xOffset, -9, 9, this.font, (button, value) -> {
            this.xOffset = value;
            this.saveSettings();
        }));
        this.valueButtonsList.add(new ValueButtons(this.getGuiLeft() + 75, this.topSectionTop + 12, this.yOffset, -9, 9, this.font, (button, value) -> {
            this.yOffset = value;
            this.saveSettings();
        }));
        this.valueButtonsList.add(new ValueButtons(this.getGuiLeft() + 125, this.topSectionTop + 12, this.zOffset, -9, 9, this.font, (button, value) -> {
            this.zOffset = value;
            this.saveSettings();
        }));
        this.valueButtonsList.forEach(valueButtons -> valueButtons.widgetList.forEach(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        }));
    }

    @Override
    public void init() {
        super.init();
        this.addRenderableWidget((GuiEventListener)ToggleButtonFactory.DIRECTIONBUTTON(this.getGuiLeft() + 122, this.topSectionTop + 38, this.direction, b -> {
            this.direction = ((ToggleButton)b).getTexturePosition();
            PacketDistributor.sendToServer((CustomPacketPayload)new DirectionSettingPayload(this.direction), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }));
        this.addRenderableWidget((GuiEventListener)new NumberButton(this.getGuiLeft() + 20, this.topSectionTop + 41, 24, 12, this.dropCount, 1, 64, (Component)Component.translatable((String)"justdirethings.screen.dropcount"), b -> {
            this.dropCount = ((NumberButton)b).getValue();
            this.saveSettings();
        }));
        this.addRenderableWidget((GuiEventListener)ToggleButtonFactory.PICKUPDELAYBUTTON(this.getGuiLeft() + 20, this.topSectionTop + 27, this.pickupDelay, b -> {
            this.pickupDelay = ((NumberButton)b).getValue();
            this.saveSettings();
        }));
    }

    @Override
    public void setTopSection() {
        this.extraWidth = 60;
        this.extraHeight = 0;
    }

    @Override
    public void saveSettings() {
        super.saveSettings();
        PacketDistributor.sendToServer((CustomPacketPayload)new DropperSettingPayload(this.dropCount, this.pickupDelay), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        MutableComponent title = this.baseMachineBE.getBlockState().getBlock().getName();
        int titleX = this.topSectionLeft - this.getGuiLeft() + 20 + (this.topSectionWidth - 40) / 2 - this.font.width((FormattedText)title) / 2;
        guiGraphics.drawString(this.font, (Component)title, titleX, this.topSectionTop - this.getGuiTop() - 14, 0x404040, false);
        if (this.baseMachineBE instanceof AreaAffectingBE) {
            int areaWidth = 158;
            int xStart = this.topSectionLeft + this.topSectionWidth / 2 - areaWidth / 2 - this.getGuiLeft();
            guiGraphics.drawString(this.font, (Component)Component.literal((String)"Off"), xStart - 4, this.topSectionTop - this.getGuiTop() + 14, 0x404040, false);
            guiGraphics.drawString(this.font, (Component)Component.literal((String)"X"), xStart + 35, this.topSectionTop - this.getGuiTop() + 4, 0x404040, false);
            guiGraphics.drawString(this.font, (Component)Component.literal((String)"Y"), xStart + 85, this.topSectionTop - this.getGuiTop() + 4, 0x404040, false);
            guiGraphics.drawString(this.font, (Component)Component.literal((String)"Z"), xStart + 135, this.topSectionTop - this.getGuiTop() + 4, 0x404040, false);
        }
    }
}

